/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.COGAdminUtils;
import com.cognos.admin.common.ReflectionUtils;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.resource.v1_0.intf.IResourceLookup;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import com.cognos.portal.fragment.producer.stage.StageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ResourceLookupManager
extends Constants {
    private static final ResourceLookupManager INSTANCE = new ResourceLookupManager();
    private final Map<String, IResourceLookup> resourceLookups = Collections.synchronizedMap(new HashMap());

    private ResourceLookupManager() {
        this.load();
    }

    public static synchronized ResourceLookupManager getInstance() {
        return INSTANCE;
    }

    public void initialize() {
    }

    public boolean validate(String sResourceId) {
        try {
            IResourceID resId = ResourceIdFactory.getResourceID(sResourceId);
            this.resourceLookups.get(resId.getSystem());
        }
        catch (BaseFaultType e) {
            CogAdminLogger.getInstance().warn("validate: Invalid Resource Type.");
        }
        return false;
    }

    public IResource find(IResourceID resourceId) throws BaseFaultType {
        try {
            IResourceLookup rl = this.resourceLookups.get(resourceId.getSystem());
            if (rl != null) {
                return rl.find(resourceId);
            }
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("find", e);
            Object[] args = new String[]{resourceId.toString()};
            throw new BaseFaultType("error.resourcelookup.notfound", args, e);
        }
        Object[] args = new String[]{resourceId.toString()};
        CogAdminLogger.getInstance().warn("find: resourceLookup not found");
        throw new BaseFaultType("error.resourcelookup.notfound", args, null);
    }

    private void load() {
        try {
            String sResourceLookups = COGAdminUtils.getProperty("resourceLookups");
            if (sResourceLookups != null) {
                StringTokenizer token = new StringTokenizer(sResourceLookups, ",");
                while (token.hasMoreTokens()) {
                    String resourceLookup = token.nextToken().trim();
                    this.createResourceLookup(resourceLookup);
                }
            } else {
                CogAdminLogger.getInstance().warn("ResourceLookupManager(). No ResourceLookups are registered within cogadmin.properties");
            }
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("ResourceLookupManager()", e);
        }
    }

    private void createResourceLookup(String sName) throws Exception {
        IResourceLookup instance;
        String pattern = COGAdminUtils.getProperty(sName + ".pattern");
        if (pattern != null && (instance = this.resourceLookups.get(pattern)) == null) {
            String className = COGAdminUtils.getProperty(sName + ".className");
            if (className != null) {
                instance = (IResourceLookup)ReflectionUtils.newInstance(className, IResourceLookup.class);
                if (instance != null) {
                    instance.initialize();
                    this.resourceLookups.put(pattern, instance);
                    return;
                }
            } else if (CogAdminLogger.getInstance().isWarnEnabled()) {
                CogAdminLogger.getInstance().warn(new StringBuffer("createResourceLookup(" + sName + "). className not registered within cogadmin.properties for ResourceLookup").toString());
            }
        }
        if (CogAdminLogger.getInstance().isWarnEnabled()) {
            CogAdminLogger.getInstance().warn(new StringBuffer("createResourceLookup(" + sName + "). Pattern not registered within cogadmin.properties for ResourceLookup").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() throws BaseFaultType {
        Collection<IResourceLookup> values;
        Collection<IResourceLookup> collection = values = this.resourceLookups.values();
        synchronized (collection) {
            for (IResourceLookup lookup : values) {
                if (lookup == null) continue;
                lookup.terminate();
            }
        }
        this.resourceLookups.clear();
        this.load();
    }

    public void terminate() throws BaseFaultType {
    }

    public String getRootResourceId(StageContext context) {
        return this.getRootResourceId(this.getApplication(context.getEnv().getParameter("application")));
    }

    public String getRootResourceId(String application) {
        return this.resourceLookups.get(this.getApplication(application)).getRoot().toString();
    }

    public String getApplication(String application) {
        if (this.resourceLookups.keySet().contains(application)) {
            return application;
        }
        return "cm";
    }

    public String getApplication(IContext context) {
        IResourceID resourceId = (IResourceID)context.getProperty("resourceID");
        return this.getApplication(resourceId != null ? resourceId.getSystem() : null);
    }
}

