/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.CMResourceID;
import com.cognos.admin.resource.v1_0.MBeanActionType;
import com.cognos.admin.resource.v1_0.MBeanByRefActionsHandler;
import com.cognos.admin.resource.v1_0.RolapCubeResource;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.admin.xts.XTSDetailsInstructionException;
import com.cognos.admin.xts.XTSUserRecoverableInstructionException;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.services.IContext;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.util.ArrayList;
import java.util.List;

public class RolapConditionalMBeanCubeActionsHandler
extends MBeanByRefActionsHandler {
    private boolean isStartOperation = false;
    private boolean isStopOrRestartOrPauseOperation = false;
    private boolean isRestartOperation = false;
    public static String CONTEXT_ERROR_DETAIL_PREFIX = "errorDetail";
    private static final String START = "startCubes";
    private static final String FORCE_START = "forceStartCubes";
    private static final String RESTART = "restartCubes";
    private static final String FORCE_STOP = "forceStopCubes";
    private static final String STOP = "stopCubes";
    private static final String PAUSE = "pauseCubes";
    private static final String RUNNING_DEPENDENT_CUBES = "RunningDependentCubes";
    private static final String STOPPED_SOURCE_CUBES = "StoppedSourceCubes";

    @Override
    protected void checkConditions(IContext context, MBeanActionType mat) throws XTSInstructionException, BaseFaultType {
        CogAdminLogger.getInstance().enter("RolapConditionalMBeanCubeActionsHandler::checkConditions", new Object[]{mat.getOperation()});
        int i = 1;
        String errorDetail = null;
        ArrayList<String> userConfirmedImpactedCubes = new ArrayList<String>();
        String operation = mat.getOperation();
        this.isStopOrRestartOrPauseOperation = FORCE_STOP.equals(operation) || STOP.equals(operation) || RESTART.equals(operation) || PAUSE.equals(operation);
        this.isStartOperation = START.equals(operation);
        this.isRestartOperation = RESTART.equals(operation);
        if (this.isStartOperation || this.isStopOrRestartOrPauseOperation) {
            do {
                String impactedCube;
                if ((errorDetail = (String)context.getProperty(CONTEXT_ERROR_DETAIL_PREFIX + i++)) == null || (impactedCube = RolapConditionalMBeanCubeActionsHandler.extractCubeNameFromErrorDetail(errorDetail)) == null) continue;
                CogAdminLogger.getInstance().debug("RolapConditionalMBeanCubeActionsHandler::checkConditions(): adding errorDetail: " + impactedCube);
                userConfirmedImpactedCubes.add(impactedCube);
            } while (errorDetail != null);
            String targetPropertyName = this.isStopOrRestartOrPauseOperation ? RUNNING_DEPENDENT_CUBES : STOPPED_SOURCE_CUBES;
            this.checkOperation(context, mat, userConfirmedImpactedCubes, targetPropertyName);
            if (this.isRestartOperation) {
                this.checkOperation(context, mat, userConfirmedImpactedCubes, STOPPED_SOURCE_CUBES);
            }
        }
        CogAdminLogger.getInstance().exit("Exiting RolapConditionalMBeanCubeActionsHandler::checkConditions()");
    }

    public static String extractCubeNameFromErrorDetail(String errorDetail) {
        try {
            IResourceID resourceId = ResourceIdFactory.getResourceID(errorDetail);
            return RolapConditionalMBeanCubeActionsHandler.extractCubeNameFromResourceId(resourceId);
        }
        catch (BaseFaultType e) {
            return errorDetail;
        }
    }

    public static String extractCubeNameFromResourceId(IResourceID resourceId) throws BaseFaultType {
        if (resourceId == null) {
            return null;
        }
        if (resourceId.getType().endsWith("Cube")) {
            return resourceId.getId();
        }
        return RolapConditionalMBeanCubeActionsHandler.extractCubeNameFromResourceId(resourceId.getReferringResourceID());
    }

    private void checkOperation(IContext context, MBeanActionType mat, ArrayList<String> userConfirmedImpactedCubes, String targetPropertyName) throws XTSDetailsInstructionException, BaseFaultType {
        String operation;
        block12: {
            operation = mat.getOperation();
            CogAdminLogger.getInstance().enter("RolapConditionalMBeanCubeActionsHandler::checkOperation", new String[]{operation, targetPropertyName});
            try {
                IResource res = (IResource)context.getProperty("IResource");
                if (!this.requiresCheck(res, targetPropertyName)) break block12;
                IPropertiesHandler handler = null;
                handler = this.getSinglePropertyHandler(context, res.getResourceID(), targetPropertyName);
                handler.doIt(context);
                ArrayList impactedCubes = handler.getPropertyList();
                CMResourceID cmResourceId = (CMResourceID)res.getResourceID();
                String targetCubeName = cmResourceId.getId();
                ArrayList<String> impactedCubeNames = new ArrayList<String>();
                for (IResourceProperty impactedCube : impactedCubes) {
                    if (impactedCube.getValue() instanceof List) {
                        for (String impactedCubeName : (List)impactedCube.getValue()) {
                            impactedCubeNames.add(impactedCubeName);
                        }
                        continue;
                    }
                    throw new BaseFaultType("Unable to acquire " + impactedCube.getValue() + " property for target cube", new Object[]{res.getResourceID()});
                }
                if (!impactedCubeNames.isEmpty()) {
                    List<String> localizedImpactedCubeNames = this.getLocalizedCubeNames(context, impactedCubeNames);
                    if (this.isStartOperation && this.userHasAgreedToActionImpactedCubes(localizedImpactedCubeNames, userConfirmedImpactedCubes)) {
                        CogAdminLogger.getInstance().debug("RolapConditionalMBeanCubeActionsHandler::checkOperation:Check condition passed. It appears the user has confirmed the current impact list so setting action to 'forceStartCubes'");
                        mat.setOperation(FORCE_START);
                    } else if (localizedImpactedCubeNames.size() > 0) {
                        CogAdminLogger.getInstance().debug("RolapConditionalMBeanCubeActionsHandler::checkOperation:Check condition failed. It appears the user has not confirmed the current impact list so throwing an XTSDetailsInstructionException");
                        XTSDetailsInstructionException exception = this.getException(operation, targetCubeName, targetPropertyName);
                        for (String impactedCubeName : localizedImpactedCubeNames) {
                            exception.addFaultDetail(impactedCubeName);
                        }
                        throw exception;
                    }
                }
            }
            catch (CacheException e) {
                try {
                    throw new BaseFaultType(e);
                }
                catch (Throwable throwable) {
                    CogAdminLogger.getInstance().exit("RolapConditionalMBeanCubeActionsHandler::checkOperation", new String[]{operation, targetPropertyName});
                    throw throwable;
                }
            }
        }
        CogAdminLogger.getInstance().exit("RolapConditionalMBeanCubeActionsHandler::checkOperation", new String[]{operation, targetPropertyName});
    }

    protected List<String> getLocalizedCubeNames(IContext context, List<String> impactedCubeNames) throws BaseFaultType {
        return RolapCubeResource.getLocalizedCubeNames(context, impactedCubeNames);
    }

    protected IPropertiesHandler getSinglePropertyHandler(IContext context, IResourceID resourceId, String targetPropertyName) throws CacheException, BaseFaultType {
        return ResourcePropertiesRetriever.getInstance(context).getSinglePropertyHandler(context, resourceId.getType(), targetPropertyName);
    }

    protected IPropertiesHandler getPropertiesHandler(IContext context, IResourceID resourceId, ArrayList<String> properties) throws CacheException, BaseFaultType {
        return ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, resourceId.getType(), properties);
    }

    private boolean userHasAgreedToActionImpactedCubes(List<String> impactedCubes, List<String> userConfirmedImpactedCubes) {
        for (String impactedCube : impactedCubes) {
            if (userConfirmedImpactedCubes.contains(impactedCube)) continue;
            return false;
        }
        return true;
    }

    private boolean requiresCheck(IResource res, String targetPropertyName) throws BaseFaultType {
        return true;
    }

    private XTSDetailsInstructionException getException(String operation, String targetCubeName, String targetPropertyName) {
        String key = null;
        if (this.isStopOrRestartOrPauseOperation && !targetPropertyName.equals(STOPPED_SOURCE_CUBES)) {
            if (FORCE_STOP.equals(operation)) {
                operation = STOP;
            }
            key = "error." + operation.toLowerCase() + ".hasDependents";
        } else {
            if (this.isRestartOperation && targetPropertyName.equals(STOPPED_SOURCE_CUBES)) {
                operation = START;
                this.isStopOrRestartOrPauseOperation = false;
            }
            key = "error.recoverable." + operation.toLowerCase() + ".confirmStartSources";
        }
        Object[] args = new String[]{targetCubeName};
        return this.isStopOrRestartOrPauseOperation ? new XTSDetailsInstructionException(key, args) : new XTSUserRecoverableInstructionException(key, args);
    }
}

