/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.datastores.ConfiguredCube;
import com.cognos.admin.resource.datastores.CubeConfigurationQuery;
import com.cognos.admin.resource.datastores.actions.AddCubeConfigurationCommand;
import com.cognos.admin.resource.v1_0.CMPropertyType;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceAction;
import com.cognos.admin.ws.cogadmin.v1_0.ExecuteResourceActionResponse;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.admin.xts.ResourceId;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.ibm.cognos.cogadmin.common.SearchPathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class RolapCubeResource
extends Resource {
    public static final String CM_OBJECT_CLASS_ROLAPDATASOURCE = "rolapDataSource";
    public static final String CM_OBJECT_CLASS_ROLAPVIRTUALDATASOURCE = "rolapVirtualDataSource";

    @Override
    protected String buildRelationshipRequest(String requestedType, IContext context) throws BaseFaultType {
        return null;
    }

    @Override
    protected void addQRBTParticipant(RelationshipType relationship, String sType, List<GenericCMObject> participants, ArrayList<String> listOfProperties, IContext context) throws BaseFaultType {
    }

    @Override
    public String getMBeanNamePattern(IContext context) {
        IResourceID refResourceID = this.getResourceID().getReferringResourceID();
        if (refResourceID != null) {
            try {
                IResource resourceObj = ResourceLookupManager.getInstance().find(refResourceID);
                if (Resource.class.isAssignableFrom(resourceObj.getClass())) {
                    Resource resource = (Resource)resourceObj;
                    return resource.getMBeanNamePattern(context);
                }
            }
            catch (BaseFaultType e) {
                CogAdminLogger.getInstance().error("Looking up referring resource failed, letting it fall through, e is " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public void setContext(IContext context) {
        if (context != null) {
            context.setProperty("IResource", (Object)this);
            context.setProperty("cmResourceType", (Object)this.getResourceType());
            IResourceID resID = this.getResourceID();
            context.setProperty("cmSearchPath", (Object)RolapCubeResource.getSearchPath(resID.getId()));
            context.setProperty("resourceID", (Object)resID);
            context.setProperty("resourceMbeanPattern", (Object)this.getMBeanNamePattern(context));
            context.setProperty("cubeName", (Object)resID.getId());
        }
    }

    public static String getSearchPath(String name) {
        return "CAMID(\":\")/*[@objectClass='rolapDataSource' or @objectClass='rolapVirtualDataSource']" + SearchPathUtils.buildNameCritera(name) + "[@shown='true']";
    }

    public static String mapObjectClassToResourceType(String sObjectClass) {
        if (sObjectClass != null) {
            if (sObjectClass.equals(CM_OBJECT_CLASS_ROLAPDATASOURCE)) {
                return "rolapCube";
            }
            if (sObjectClass.equals(CM_OBJECT_CLASS_ROLAPVIRTUALDATASOURCE)) {
                return "rolapVirtualCube";
            }
        }
        return null;
    }

    public static List<String> getLocalizedCubeNames(IContext context, List<String> cubeNames) throws BaseFaultType {
        if (cubeNames != null && cubeNames.size() > 0) {
            ArrayList<String> searchPaths = new ArrayList<String>();
            for (String impactedCubeName : cubeNames) {
                String searchPath = new StringBuffer("CAMID(\":\")/*[@objectClass='rolapDataSource' or @objectClass='rolapVirtualDataSource' and @name='").append(impactedCubeName).append("']").toString();
                searchPaths.add(searchPath);
            }
            CMPropertyType propDefaultName = new CMPropertyType();
            propDefaultName.setCMObjectName("defaultName");
            String requestStr = CMRequestHelper.buildCMQueryRequest(searchPaths, Arrays.asList(propDefaultName));
            List<GenericCMObject> responseItems = CMRequestHelper.makeCMRequest(context, requestStr);
            ArrayList<String> localizedCubeNames = new ArrayList<String>();
            for (GenericCMObject responseItem : responseItems) {
                String localizedCubeName = responseItem.getParameter("defaultName", null);
                localizedCubeNames.add(localizedCubeName);
            }
            return localizedCubeNames;
        }
        return cubeNames;
    }

    @Override
    public ExecuteResourceActionResponse executeResourceAction(ExecuteResourceAction sAction, IContext context) throws BaseFaultType {
        if (sAction.getName().equals("SetCubeProperties")) {
            HashMap<String, String> configValues = new HashMap<String, String>();
            String cubeName = null;
            for (int i = 0; i < sAction.getArgumentCount(); ++i) {
                String[] nameTokens;
                if (sAction.getArgument(i).getName().equals("selected_cube")) {
                    cubeName = sAction.getArgument(i).getContent();
                }
                if (!(nameTokens = sAction.getArgument(i).getName().split("_", 2))[0].equals("rlp") || nameTokens.length <= 1) continue;
                configValues.put(nameTokens[1], sAction.getArgument(i).getContent());
            }
            if (cubeName != null) {
                String resId = ResourceId.getResourceId(context.getProperty("resourceID").toString(), "queryService");
                IResourceID qsResId = ResourceIdFactory.getResourceID(resId);
                try {
                    for (ConfiguredCube cube : CubeConfigurationQuery.getInstance().getQueryServiceConfiguredCubes(context, qsResId.getId(), true)) {
                        if (cubeName != null && !cube.equals(cubeName)) continue;
                        AddCubeConfigurationCommand configCommand = new AddCubeConfigurationCommand(context, null, qsResId, cube.getConfiguredName(), cube.isVirtual(), configValues);
                        try {
                            configCommand.execute();
                        }
                        catch (CommandExecutionException e) {
                            if (!CogAdminLogger.getInstance().isErrorEnabled()) continue;
                            CogAdminLogger.getInstance().error("DatasourceDispatcherResource: Cube configuration failed for cube:" + cube.getConfiguredName() + " on queryService Id:" + qsResId, e);
                        }
                    }
                }
                catch (Exception e1) {
                    if (CogAdminLogger.getInstance().isErrorEnabled()) {
                        CogAdminLogger.getInstance().error("DatasourceDispatcherResource: An error occurred establishing list of cube for queryService Id:" + qsResId);
                    }
                    throw new BaseFaultType(e1);
                }
            }
            ExecuteResourceActionResponse response = new ExecuteResourceActionResponse();
            return response;
        }
        return super.executeResourceAction(sAction, context);
    }
}

