/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.PropertiesHandler;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import java.util.Iterator;
import java.util.Locale;

public abstract class RolapCubeStatusHandler
extends PropertiesHandler {
    protected static final String RUNNING = "running";
    protected static final String DISABLED = "disabled";
    protected static final String STOPPING = "stopping";
    protected static final String STARTING = "starting";
    protected static final String STOPPED = "stopped";
    protected static final String PAUSED = "paused";
    protected static final String PAUSING = "pausing";

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        IResourceProperty prop;
        Object value;
        Object element;
        if (this.m_propertyList == null || this.m_propertyList.size() < 1) {
            CogAdminLogger.getInstance().error("No properties are defined.");
            return;
        }
        PropertyType property = (PropertyType)this.m_propertyList.get(0);
        String propName = (String)property.getValue();
        IResource res = (IResource)context.getProperty("IResource");
        IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getSinglePropertyHandler(context, res.getResourceID().getType(), propName);
        handler.doIt(context);
        Iterator propIter = handler.iterator();
        if (propIter.hasNext() && IResourceProperty.class.isAssignableFrom((element = propIter.next()).getClass()) && (value = (prop = (IResourceProperty)element).getValue()) != null && String.class.isAssignableFrom(value.getClass())) {
            property.setValue(this.localize(context, (String)value));
        }
    }

    protected String localize(IContext context, String key) {
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        return MessagesManagerFacade.getInstance().getMessage(tLocale, this.getMappedValue(key));
    }

    abstract String getMappedValue(String var1);
}

