/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.PropertiesHandler;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularDataSupport;

public class RolapTabularCubeNameListHandler
extends PropertiesHandler {
    @Override
    public void doIt(IContext context) throws BaseFaultType {
        CogAdminLogger.getInstance().enter("RolapTabularCubenameListHandler:doIt()");
        if (this.m_propertyList == null || this.m_propertyList.size() < 1) {
            CogAdminLogger.getInstance().error("No properties are defined.");
            return;
        }
        for (PropertyType property : this.m_propertyList) {
            IResourceProperty prop;
            Object value;
            Object element;
            String propName = (String)property.getValue();
            IResource res = (IResource)context.getProperty("IResource");
            IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getSinglePropertyHandler(context, res.getResourceID().getType(), propName);
            handler.doIt(context);
            Iterator propIter = handler.iterator();
            if (!propIter.hasNext() || !IResourceProperty.class.isAssignableFrom((element = propIter.next()).getClass()) || (value = (prop = (IResourceProperty)element).getValue()) == null || !TabularDataSupport.class.isAssignableFrom(value.getClass())) continue;
            TabularDataSupport tabularCubeData = (TabularDataSupport)value;
            ArrayList<String> cubeNames = this.getCubeNames(tabularCubeData);
            property.setValue(cubeNames);
        }
        CogAdminLogger.getInstance().exit("RolapTabularCubenameListHandler:doIt()");
    }

    public ArrayList<String> getCubeNames(TabularDataSupport tabularCubeData) {
        CogAdminLogger.getInstance().enter("RolapTabularCubenameListHandler:getCubeNames()");
        ArrayList<String> cubeNames = new ArrayList<String>();
        for (Object obj : tabularCubeData.values()) {
            CompositeDataSupport cubeEntry = (CompositeDataSupport)obj;
            String cubeName = cubeEntry.get("cubeName").toString();
            cubeNames.add(cubeName);
            CogAdminLogger.getInstance().debug("RolapTabularCubenameListHandler:getCubeNames() fetched cube:" + cubeName);
        }
        CogAdminLogger.getInstance().exit("RolapTabularCubenameListHandler:getCubeNames()");
        return cubeNames;
    }
}

