/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.COGAdminUtils;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.CMResourceID;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsdm.muws2.v1_1.QueryRelationshipsByType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.QueryRelationshipsByTypeResponse;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipParticipantType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ServerContainerResource
extends Resource {
    @Override
    public QueryRelationshipsByTypeResponse queryRelationshipsByType(QueryRelationshipsByType relationshipType, IContext context) throws BaseFaultType {
        return super.queryRelationshipsByType(relationshipType, context);
    }

    @Override
    protected String buildRelationshipRequest(String requestedType, IContext context) throws BaseFaultType {
        try {
            ArrayList cmProps;
            String sSearchPath = "";
            if (requestedType.equalsIgnoreCase("containedBy")) {
                sSearchPath = "/configuration//dispatcher[@shown='true']";
                Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
                cmProps = ResourcePropertiesRetriever.getInstance(context).getiResourceCMProperties("dispatcher", Constants.QRBT_RESPONSE_PROP_LIST, tLocale);
                PropertyType dispPath = new PropertyType("dispatcherPath", "cm");
                dispPath.setCMObjectName("dispatcherPath");
                cmProps.add(dispPath);
                if (this.getResourceID().getBaseType().equalsIgnoreCase("serverGroup")) {
                    PropertyType svrGroup = new PropertyType("serverGroup", "cm");
                    svrGroup.setCMObjectName("serverGroup");
                    cmProps.add(svrGroup);
                }
            } else {
                if (CogAdminLogger.getInstance().isWarnEnabled()) {
                    CogAdminLogger.getInstance().warn("buildCMRequest(" + requestedType + ") Unsupported Type.");
                }
                throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
            }
            if (sSearchPath.length() > 0) {
                String req = CMRequestHelper.buildCMQueryRequest(sSearchPath, (List)cmProps);
                return req;
            }
            if (CogAdminLogger.getInstance().isWarnEnabled()) {
                CogAdminLogger.getInstance().warn("buildCMRequest(" + requestedType + ") Unsupported Type.");
            }
            throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
        }
        catch (Exception e) {
            if (CogAdminLogger.getInstance().isErrorEnabled()) {
                CogAdminLogger.getInstance().error("buildCMRequest(" + requestedType + ")", e);
            }
            throw new BaseFaultType("error.exception", e);
        }
    }

    protected void addQRBTParticipant(RelationshipType relationship, String sType, List cmObjects, ArrayList listOfProperties, IContext context) throws BaseFaultType {
        ArrayList<RelationshipParticipantType> listOfParticipant = new ArrayList<RelationshipParticipantType>();
        String svrDefaultName = null;
        listOfProperties.addAll(Constants.QRBT_RESPONSE_PROP_WITHOUT_HEALTH_LIST);
        IPropertiesHandler healthHandler = null;
        context.setProperty("resourceMbeanType", (Object)"consolidated");
        context.setProperty("resourceMbeanPattern", (Object)this.getMBeanNamePattern(context));
        healthHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, this.getResourceType(), Constants.QRBT_RESPONSE_PROP_HEALTH_LIST);
        healthHandler.doIt(context);
        this.resetContext(context);
        for (int i = 0; i < cmObjects.size(); ++i) {
            String defaultName;
            String serverStoreID;
            IResourceID participantResourceId;
            String storeID;
            GenericCMObject cmObj;
            block9: {
                cmObj = (GenericCMObject)cmObjects.get(i);
                storeID = cmObj.getParameter("storeID", "");
                if (storeID == null || storeID.length() == 0 || (participantResourceId = this.getParticipantResourceId(cmObj.getType(), storeID, context)) == null) continue;
                serverStoreID = "";
                defaultName = "";
                if (!participantResourceId.getBaseType().equals("dispatcher")) continue;
                if (this.getResourceID().getBaseType().equals("server")) {
                    try {
                        HashMap names = COGAdminUtils.parseDispatcherPath(cmObj.getParameter("dispatcherPath", ""));
                        defaultName = serverStoreID = (String)names.get("host");
                        break block9;
                    }
                    catch (BaseFaultType e) {
                        CogAdminLogger.getInstance().error("Could not parse dispatcher path.", e);
                        continue;
                    }
                }
                if (this.getResourceID().getBaseType().equals("serverGroup")) {
                    serverStoreID = cmObj.getParameter("serverGroup", "");
                    if (serverStoreID == null || serverStoreID.length() == 0) {
                        serverStoreID = "DefaultServerGroup";
                    }
                    defaultName = serverStoreID;
                }
            }
            if (!this.getResourceID().getId().equals(serverStoreID)) continue;
            if (svrDefaultName == null) {
                svrDefaultName = defaultName;
            }
            CMResourceID id = (CMResourceID)ResourceIdFactory.getResourceID(participantResourceId.getType(), storeID, context);
            id.setReferringResourceID(participantResourceId.getReferringResourceID());
            CMResource cmRes = (CMResource)ResourceLookupManager.getInstance().find(id);
            String dispPath = cmObj.getParameter("dispatcherPath", "");
            cmRes.setDispatcherPath(dispPath);
            context.setProperty("cmObject", (Object)cmObj);
            context.setProperty("resourceMbeanPattern", (Object)cmRes.getMBeanNamePattern(context));
            IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, cmRes.getResourceType(), listOfProperties);
            handler.doIt(context);
            this.resetContext(context);
            if (dispPath == null || dispPath.length() <= 0) continue;
            RelationshipParticipantType p = cmRes.generateQRBTPaticipant(handler, healthHandler, context);
            listOfParticipant.add(p);
        }
        if (svrDefaultName == null) {
            IResourceID rootResourceId = (IResourceID)context.getProperty("resourceID");
            svrDefaultName = rootResourceId.getId();
        }
        this.setContext(context);
        IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, this.getResourceType(), listOfProperties);
        handler.doIt(context);
        RelationshipParticipantType participant = this.generateQRBTPaticipant(handler, healthHandler, context, true);
        relationship.addParticipant(participant);
        for (int i = 0; i < listOfParticipant.size(); ++i) {
            RelationshipParticipantType p = (RelationshipParticipantType)listOfParticipant.get(i);
            relationship.addParticipant(p);
        }
    }

    protected IResourceID getParticipantResourceId(String type, String storeId, IContext context) throws BaseFaultType {
        return ResourceIdFactory.getResourceID(type, storeId, context);
    }

    @Override
    public String getMBeanNamePattern(IContext context) {
        StringBuffer pattern = new StringBuffer();
        if (this.isTemplate()) {
            pattern.append("template=" + this.getResourceType());
        } else {
            pattern.append(this.getMBeanNameWithServiceTypePattern(context, "group=" + this.getResourceID().getId()));
        }
        return pattern.toString();
    }

    @Override
    protected void setContext(IContext context) {
        if (context != null) {
            GenericCMObject cmObj = new GenericCMObject("serverContainer");
            String svrStoreID = this.getResourceID().getId();
            if (this.getResourceID().getBaseType().equals("serverGroup") && svrStoreID != null && svrStoreID.equals("DefaultServerGroup")) {
                Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
                svrStoreID = MessagesManagerFacade.getInstance().getMessage(tLocale, "ui.defaultservergroup");
            }
            cmObj.setParameter("defaultName", svrStoreID);
            context.setProperty("cmObject", (Object)cmObj);
            context.setProperty("resourceMbeanPattern", (Object)this.getMBeanNamePattern(context));
            context.setProperty("cmResourceType", (Object)this.getResourceType());
            context.setProperty("IResource", (Object)this);
        }
    }
}

