/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.InstalledComponents;
import com.cognos.admin.common.ReflectionUtils;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.resource.datastores.actions.ContextCache;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.PropertiesHandler;
import com.cognos.admin.resource.v1_0.PropertiesHandlerPropertyType;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.intf.IActionsHandler;
import com.cognos.admin.resource.v1_0.intf.IConditionalActionAccessHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceAction;
import com.cognos.admin.ws.cogadmin.v1_0.ActionType;
import com.cognos.admin.ws.cogadmin.v1_0.SupportedActions;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Element;

@PropertiesHandlerPropertyType(clazz=PropertyType.class)
public class SupportedActionsPropertiesHandler
extends PropertiesHandler {
    public SupportedActionsPropertiesHandler(ArrayList propertyList) {
        super(propertyList);
    }

    public SupportedActionsPropertiesHandler() {
    }

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        if (this.m_propertyList == null || this.m_propertyList.size() == 0) {
            return;
        }
        PropertyType property = (PropertyType)this.m_propertyList.get(0);
        property.setComplexValue(true);
        SupportedActions supportedActions = new SupportedActions();
        ArrayList list = this.getActionTypes(context, null);
        for (int i = 0; i < list.size(); ++i) {
            supportedActions.addAction((ActionType)list.get(i));
        }
        property.setValue(supportedActions);
    }

    protected ArrayList getActionTypes(IContext context, String sCapability) throws BaseFaultType {
        ArrayList<ActionType> actionTypes = new ArrayList<ActionType>();
        String sResourceType = (String)context.getProperty("cmResourceType");
        IActionsHandler handler = ResourcePropertiesRetriever.getInstance(context).getActionsHandler(context, sResourceType, null, sCapability);
        HashMap propertiesCache = new HashMap();
        try {
            String dispPath = (String)context.getProperty("dispPath");
            List<String> installedComponents = InstalledComponents.getInstalledComponents(dispPath);
            Iterator handlerIter = handler.iterator();
            while (handlerIter.hasNext()) {
                List cmResponse;
                IResourceAction actionType = (IResourceAction)handlerIter.next();
                boolean bActionSupported = InstalledComponents.isInstalled(actionType.getRequiredComponents(), installedComponents);
                if (bActionSupported) {
                    List conditions = actionType.getConditions();
                    Iterator conditionsIter = conditions.iterator();
                    block3: while (bActionSupported && conditionsIter.hasNext()) {
                        Element eCondition = (Element)conditionsIter.next();
                        for (Object eHandler : eCondition.elements("handler")) {
                            String handlerClassName = ((Element)eHandler).getText();
                            IConditionalActionAccessHandler accessHandler = (IConditionalActionAccessHandler)ContextCache.getProperty(context, handlerClassName);
                            if (accessHandler == null) {
                                accessHandler = (IConditionalActionAccessHandler)ReflectionUtils.newInstance(handlerClassName);
                                accessHandler.init(context);
                                ContextCache.setProperty(context, handlerClassName, accessHandler);
                            }
                            if (bActionSupported = accessHandler.isAccessible(actionType.getID())) continue;
                            continue block3;
                        }
                    }
                }
                if (bActionSupported && (cmResponse = this.getCMObjects(context, handler.iterator(), sResourceType, propertiesCache)) != null) {
                    Iterator cmRespIter = cmResponse.iterator();
                    ArrayList propertyDefs = (ArrayList)propertiesCache.get(actionType);
                    if (propertyDefs != null) {
                        GenericCMObject cmObj = (GenericCMObject)cmRespIter.next();
                        int i = 0;
                        while (i < propertyDefs.size() && cmRespIter.hasNext()) {
                            String actualValue;
                            PropertyDef requiredPropDef = (PropertyDef)propertyDefs.get(i);
                            String sRequiredValue = requiredPropDef.getValue();
                            String sOperator = requiredPropDef.getOperator();
                            boolean matchAll = sOperator == null || !sOperator.equals("OR");
                            boolean hasProperty = false;
                            String propName = requiredPropDef.getName();
                            if (cmObj.hasArrayParameter(propName)) {
                                bActionSupported = bActionSupported && this.match(sRequiredValue, cmObj.getArrayParameter(propName), matchAll);
                                hasProperty = true;
                            }
                            if ((actualValue = cmObj.getParameter(propName, null)) != null) {
                                bActionSupported = bActionSupported && this.match(sRequiredValue, actualValue.length() == 0 ? "NIL" : actualValue, matchAll);
                                hasProperty = true;
                            }
                            if (hasProperty) {
                                ++i;
                                continue;
                            }
                            if (!cmRespIter.hasNext()) continue;
                            cmObj = (GenericCMObject)cmRespIter.next();
                        }
                    }
                }
                if (!bActionSupported) continue;
                ActionType action = new ActionType();
                action.setName(actionType.getID().toString());
                actionTypes.add(action);
            }
        }
        catch (Exception e) {
            throw new BaseFaultType(e);
        }
        return actionTypes;
    }

    protected List getCMObjects(IContext context, Iterator actionTypes, String sResourceType, HashMap propertiesCache) throws BaseFaultType {
        if (Constants.RESOURCE_TYPES_VIRTUAL.contains(sResourceType)) {
            return null;
        }
        StringBuffer sbRequest = CMRequestHelper.startCMQueryRequest();
        boolean bCanMakeRequest = false;
        while (actionTypes.hasNext()) {
            IResourceAction actionType = (IResourceAction)actionTypes.next();
            ArrayList<PropertyDef> propertyDefs = new ArrayList<PropertyDef>();
            propertiesCache.put(actionType, propertyDefs);
            List conditions = actionType.getConditions();
            for (Element eCondition : conditions) {
                ArrayList<PropertyType> props = new ArrayList<PropertyType>();
                Element eProperties = eCondition.element("properties");
                if (eProperties != null) {
                    List propertyList = eProperties.elements("property");
                    for (Element eProperty : propertyList) {
                        String sName = eProperty.elementText("name");
                        if (sName == null) continue;
                        PropertyType prop = new PropertyType(sName);
                        props.add(prop);
                        Element eValues = eProperty.element("values");
                        propertyDefs.add(new PropertyDef(sName, eValues.getText(), eValues.attributeValue("operator")));
                    }
                }
                if (props.isEmpty()) continue;
                String sSearchPath = eCondition.elementText("searchPath");
                if (sSearchPath == null && "/configuration[@shown='true']".equals(sSearchPath = (String)context.getProperty("cmSearchPath"))) {
                    sSearchPath = "/configuration//dispatcher[@shown='true']";
                }
                bCanMakeRequest = true;
                CMRequestHelper.appendQueryRequest(sbRequest, sSearchPath, props);
            }
        }
        if (bCanMakeRequest) {
            CMRequestHelper.endCMQueryRequest(sbRequest);
            return CMRequestHelper.makeCMRequest(context, sbRequest.toString());
        }
        return null;
    }

    protected boolean match(String expectedList, String actualList, boolean matchAll) {
        List<String> actual = Arrays.asList(actualList.split("\n"));
        return this.match(expectedList, actual, matchAll);
    }

    protected boolean match(String expectedList, List actualList, boolean matchAll) {
        StringTokenizer expected = new StringTokenizer(expectedList);
        boolean match = false;
        while (expected.hasMoreTokens()) {
            match = actualList.contains(expected.nextToken());
            if (match) {
                if (matchAll) continue;
                return true;
            }
            if (!matchAll) continue;
            return false;
        }
        return match;
    }

    private class PropertyDef {
        private String name = null;
        private String value = null;
        private String operator = null;

        public PropertyDef(String name, String value, String operator) {
            this.name = name;
            this.value = value;
            this.operator = operator;
        }

        public String getName() {
            return this.name;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }
    }
}

