/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.AdminMetadataRetriever;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.PropertiesHandler;
import com.cognos.admin.resource.v1_0.PropertiesHandlerPropertyType;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.ws.cogadmin.v1_0.ActionContext;
import com.cognos.admin.ws.cogadmin.v1_0.ActionContexts;
import com.cognos.admin.ws.cogadmin.v1_0.CaptionType;
import com.cognos.admin.ws.cogadmin.v1_0.RelationshipType;
import com.cognos.admin.ws.cogadmin.v1_0.SupportedRelationships;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Locale;

@PropertiesHandlerPropertyType(clazz=PropertyType.class)
public class SupportedRelationshipsPropertiesHandler
extends PropertiesHandler {
    private static final String ACTION_CONTEXT_ID1 = "1";
    private static final String ACTION_CONTEXT_ID2 = "2";
    private static final String ACTION_CONTEXT_ID3 = "3";
    private static final String ACTION_CONTEXT_ID4 = "4";
    private static final String ACTION_CONTEXT_ID5 = "5";
    private static final String ACTION_CONTEXT_ID6 = "6";

    public SupportedRelationshipsPropertiesHandler(ArrayList propertyList) {
        super(propertyList);
    }

    public SupportedRelationshipsPropertiesHandler() {
    }

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        if (this.m_propertyList == null || this.m_propertyList.size() == 0) {
            return;
        }
        PropertyType property = (PropertyType)this.m_propertyList.get(0);
        property.setComplexValue(true);
        Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        String sLocale = tLocale.toString();
        SupportedRelationships sr = new SupportedRelationships();
        RelationshipType rServers = new RelationshipType();
        rServers.setName("servers");
        CaptionType cServers = new CaptionType();
        cServers.setLang(sLocale);
        cServers.setContent(MessagesManagerFacade.getInstance().getMessage(tLocale, "relationship.servers.caption"));
        rServers.addCaption(cServers);
        rServers.setDefault(true);
        this.setActionContexts(rServers, ACTION_CONTEXT_ID2, ACTION_CONTEXT_ID1);
        sr.addRelationship(rServers);
        RelationshipType rServerGroups = new RelationshipType();
        rServerGroups.setName("servergroups");
        CaptionType cServerGroups = new CaptionType();
        cServerGroups.setLang(sLocale);
        cServerGroups.setContent(MessagesManagerFacade.getInstance().getMessage(tLocale, "relationship.servergroups.caption"));
        rServerGroups.addCaption(cServerGroups);
        this.setActionContexts(rServerGroups, ACTION_CONTEXT_ID2, ACTION_CONTEXT_ID1);
        sr.addRelationship(rServerGroups);
        RelationshipType rDispatchers = new RelationshipType();
        rDispatchers.setName("dispatchers");
        CaptionType cDispatchers = new CaptionType();
        cDispatchers.setLang(sLocale);
        cDispatchers.setContent(MessagesManagerFacade.getInstance().getMessage(tLocale, "relationship.dispatchers.caption"));
        rDispatchers.addCaption(cDispatchers);
        this.setActionContexts(rDispatchers, ACTION_CONTEXT_ID4, ACTION_CONTEXT_ID3);
        sr.addRelationship(rDispatchers);
        ArrayList services = AdminMetadataRetriever.getInstance(context).getInstalledServiceTypeIds();
        if (services != null && services.size() > 0) {
            RelationshipType rServicesByType = new RelationshipType();
            rServicesByType.setName("servicesbytype");
            CaptionType cServicesByType = new CaptionType();
            cServicesByType.setLang(sLocale);
            cServicesByType.setContent(MessagesManagerFacade.getInstance().getMessage(tLocale, "relationship.servicesbytype.caption"));
            rServicesByType.addCaption(cServicesByType);
            rServicesByType.setContainer(true);
            RelationshipType rServices = new RelationshipType();
            rServices.setName("services");
            CaptionType cServices = new CaptionType();
            cServices.setLang(sLocale);
            cServices.setContent(MessagesManagerFacade.getInstance().getMessage(tLocale, "relationship.services.caption"));
            rServices.addCaption(cServices);
            this.setActionContexts(rServices, ACTION_CONTEXT_ID5, ACTION_CONTEXT_ID6);
            rServicesByType.addRelationship(rServices);
            for (String serviceId : services) {
                RelationshipType tempRelationship = new RelationshipType();
                tempRelationship.setName(serviceId);
                CaptionType ctempRelationship = new CaptionType();
                ctempRelationship.setLang(sLocale);
                ctempRelationship.setContent(MessagesManager.getInstance().getMessage(tLocale, "relationship." + serviceId + ".caption"));
                tempRelationship.addCaption(ctempRelationship);
                rServicesByType.addRelationship(tempRelationship);
            }
            this.setActionContexts(rServicesByType, ACTION_CONTEXT_ID5, ACTION_CONTEXT_ID6);
            sr.addRelationship(rServicesByType);
        }
        property.setValue(sr);
    }

    private void setActionContexts(RelationshipType rt, String actionContextId, String groupActionContextId) {
        ActionContexts actionContexts = new ActionContexts();
        ActionContext actionContext = new ActionContext();
        actionContext.setId(actionContextId);
        actionContext.setType("Action");
        actionContexts.addContext(actionContext);
        ActionContext groupActionContext = new ActionContext();
        groupActionContext.setId(groupActionContextId);
        groupActionContext.setType("GroupAction");
        actionContexts.addContext(groupActionContext);
        rt.setActionContexts(actionContexts);
    }
}

