/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.AdminMetadataRetriever;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.PropertiesHandler;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResource;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class SupportedResourceTypesPropertiesHandler
extends PropertiesHandler {
    private static String NS_PREFIX = "resource-prop";
    private static String NS_URL = "http://developer.cognos.com/admin/properties";
    private static QName SUPPORTED_RESOURCE_TYPES = new QName("SupportedResourceTypes", new Namespace(NS_PREFIX, NS_URL));
    private static QName RESOURCE_TYPE = new QName("ResourceType", new Namespace(NS_PREFIX, NS_URL));
    private static QName RESOURCE_TYPE_NAME = new QName("Name", new Namespace(NS_PREFIX, NS_URL));
    private static QName RESOURCE_TYPE_CAPTION = new QName("Caption", new Namespace(NS_PREFIX, NS_URL));
    private static QName RESOURCE_TYPE_ICON = new QName("Icon", new Namespace(NS_PREFIX, NS_URL));
    private static QName RESOURCE_TYPE_RESOURCEID = new QName("ResourceId", new Namespace(NS_PREFIX, NS_URL));
    private static QName RESOURCE_TYPE_SUPPORTS_TEMPLATES = new QName("SupportsTemplates", new Namespace(NS_PREFIX, NS_URL));

    public SupportedResourceTypesPropertiesHandler() {
    }

    public SupportedResourceTypesPropertiesHandler(ArrayList propertyList) {
        super(propertyList);
    }

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        if (this.m_propertyList == null || this.m_propertyList.size() == 0) {
            return;
        }
        PropertyType property = (PropertyType)this.m_propertyList.get(0);
        property.setComplexValue(true);
        Element srt = DocumentHelper.createElement((QName)SUPPORTED_RESOURCE_TYPES);
        Locale locale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
        Map resourceTypes = AdminMetadataRetriever.getInstance(ResourceLookupManager.getInstance().getApplication(context)).getResourceTypeCaptions(locale);
        for (Map.Entry entry : resourceTypes.entrySet()) {
            String sResourceType = (String)entry.getKey();
            Element type = DocumentHelper.createElement((QName)RESOURCE_TYPE);
            Element name = DocumentHelper.createElement((QName)RESOURCE_TYPE_NAME);
            name.setText(sResourceType);
            type.add(name);
            Element caption = DocumentHelper.createElement((QName)RESOURCE_TYPE_CAPTION);
            String sCaption = (String)entry.getValue();
            caption.setText(sCaption);
            type.add(caption);
            Element resourceId = DocumentHelper.createElement((QName)RESOURCE_TYPE_RESOURCEID);
            IResource resource = (IResource)context.getProperty("IResource");
            resourceId.setText(ResourceIdFactory.getResourceID(sResourceType, null, context).toString());
            type.add(resourceId);
            ArrayList<String> properties = new ArrayList<String>();
            properties.add("ClassIcon");
            properties.add("SupportsTemplates");
            IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, sResourceType, properties);
            Iterator propertiesIter = handler.iterator();
            while (propertiesIter.hasNext()) {
                IResourceProperty resourceProperty = (IResourceProperty)propertiesIter.next();
                if (resourceProperty.getID().equals("ClassIcon")) {
                    Element icon = DocumentHelper.createElement((QName)RESOURCE_TYPE_ICON);
                    icon.setText((String)resourceProperty.getValue());
                    type.add(icon);
                    continue;
                }
                if (!resourceProperty.getID().equals("SupportsTemplates")) continue;
                Element supportsTemplates = DocumentHelper.createElement((QName)RESOURCE_TYPE_SUPPORTS_TEMPLATES);
                supportsTemplates.setText(((Boolean)resourceProperty.getValue()).toString());
                type.add(supportsTemplates);
            }
            srt.add(type);
        }
        property.setValue(srt);
    }
}

