/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.AdminMetadataRetriever;
import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.COGAdminUtils;
import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.ResourcePropertiesRetriever;
import com.cognos.admin.common.castor.CogadminCastorType;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.CMResource;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.PropertyType;
import com.cognos.admin.resource.v1_0.Resource;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.ICancelInteractiveActivities;
import com.cognos.admin.resource.v1_0.intf.IGetInteractiveActivities;
import com.cognos.admin.resource.v1_0.intf.IPropertiesHandler;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.resource.v1_0.intf.IResourceProperty;
import com.cognos.admin.ws.cogadmin.v1_0.ActivitySummaryType;
import com.cognos.admin.ws.cogadmin.v1_0.ActivityType;
import com.cognos.admin.ws.cogadmin.v1_0.CancelInteractiveActivities;
import com.cognos.admin.ws.cogadmin.v1_0.CancelInteractiveActivitiesResponse;
import com.cognos.admin.ws.cogadmin.v1_0.GetInteractiveActivities;
import com.cognos.admin.ws.cogadmin.v1_0.GetInteractiveActivitiesResponse;
import com.cognos.admin.ws.cogadmin.v1_0.PageType;
import com.cognos.admin.ws.cogadmin.v1_0.StatusSummaryType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.QueryRelationshipsByType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.QueryRelationshipsByTypeResponse;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipParticipantType;
import com.cognos.admin.ws.wsdm.muws2.v1_1.RelationshipType;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;

public class SystemResource
extends Resource
implements IGetInteractiveActivities,
ICancelInteractiveActivities {
    @Override
    public QueryRelationshipsByTypeResponse queryRelationshipsByType(QueryRelationshipsByType relationshipType, IContext context) throws BaseFaultType {
        return super.queryRelationshipsByType(relationshipType, context);
    }

    @Override
    protected void addQRBTParticipant(RelationshipType relationship, String relationshipType, List<GenericCMObject> cmObjects, ArrayList<String> listOfProperties, IContext context) throws BaseFaultType {
        String storeID;
        ArrayList listOfParticipant = new ArrayList(cmObjects.size());
        HashMap servers = new HashMap();
        HashMap<String, String> dispatchers = new HashMap<String, String>();
        if (relationshipType.equals("services") || AdminMetadataRetriever.isService(context, relationshipType)) {
            ArrayList<GenericCMObject> tempCMObjects = new ArrayList<GenericCMObject>(cmObjects.size());
            for (int i = 0; i < cmObjects.size(); ++i) {
                GenericCMObject cmObj = cmObjects.get(i);
                String baseType = ResourceIdFactory.getResourceID(cmObj.getType(), null, context).getBaseType();
                if (baseType.equals("dispatcher")) {
                    storeID = cmObj.getParameter("storeID", "");
                    String dispPath = cmObj.getParameter("dispatcherPath", "");
                    if (dispPath == null || dispPath.length() <= 0 || storeID == null || storeID.length() <= 0) continue;
                    dispatchers.put(storeID, dispPath);
                    continue;
                }
                tempCMObjects.add(cmObj);
            }
            if (tempCMObjects.size() > 0) {
                cmObjects = tempCMObjects;
            }
        }
        IPropertiesHandler healthHandler = null;
        ArrayList sysQRBTProps = null;
        if (relationshipType.equals("dispatchers") || dispatchers.size() > 0 && (relationshipType.equals("services") || AdminMetadataRetriever.isService(context, relationshipType))) {
            context.setProperty("resourceMbeanType", (Object)"consolidated");
            this.setContext(context);
            healthHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, this.getResourceType(), Constants.QRBT_RESPONSE_PROP_HEALTH_LIST);
            healthHandler.doIt(context);
            this.resetContext(context);
            sysQRBTProps = (ArrayList)Constants.QRBT_RESPONSE_PROP_WITHOUT_HEALTH_LIST.clone();
        } else {
            sysQRBTProps = (ArrayList)Constants.QRBT_RESPONSE_PROP_LIST.clone();
        }
        for (int i = 0; i < cmObjects.size(); ++i) {
            GenericCMObject cmObj = cmObjects.get(i);
            storeID = cmObj.getParameter("storeID", "");
            IResourceID resId = ResourceIdFactory.getResourceID(cmObj.getType(), storeID, context);
            String baseType = resId.getBaseType();
            if (storeID == null || storeID.length() == 0) {
                CogAdminLogger.getInstance().warn("addQRBTParticipant: Invalid Object");
                continue;
            }
            if (baseType.equals("configuration")) {
                GenericCMObject sysCMObj = new GenericCMObject("system");
                sysCMObj.setParameter("storeID", resId.getId());
                sysCMObj.setParameter("objectClass", cmObj.getParameter("objectClass", ""));
                context.setProperty("cmObject", (Object)sysCMObj);
                continue;
            }
            String dispPath = "";
            if (baseType.equals("dispatcher")) {
                dispPath = cmObj.getParameter("dispatcherPath", "");
            } else {
                String parentStoreID = cmObj.getParameter("parent", "");
                dispPath = (String)dispatchers.get(parentStoreID);
            }
            CMResource cmRes = (CMResource)ResourceLookupManager.getInstance().find(resId);
            cmRes.setDispatcherPath(dispPath);
            if (relationshipType.equals("servers")) {
                if (!baseType.equals("dispatcher")) continue;
                try {
                    HashMap names = COGAdminUtils.parseDispatcherPath(cmObj.getParameter("dispatcherPath", ""));
                    storeID = (String)names.get("host");
                    this.addServerContainer(context, servers, storeID, cmObj);
                }
                catch (BaseFaultType e) {
                    CogAdminLogger.getInstance().error("Could not parse dispatcher path.", e);
                }
                continue;
            }
            if (relationshipType.equals("servergroups")) {
                String svrGroupName = cmObj.getParameter("serverGroup", "");
                if (svrGroupName == null || svrGroupName.length() == 0) {
                    svrGroupName = "DefaultServerGroup";
                }
                this.addServerContainer(context, servers, svrGroupName, cmObj);
                continue;
            }
            if (relationshipType.equals("dispatchers") && baseType.equals("dispatcher") || relationshipType.equals("services") || AdminMetadataRetriever.isService(context, relationshipType)) {
                context.setProperty("cmObject", (Object)cmObj);
                context.setProperty("resourceMbeanPattern", (Object)cmRes.getMBeanNamePattern(context));
                ArrayList<String> props = new ArrayList<String>();
                props.addAll(listOfProperties);
                props.addAll(Constants.QRBT_RESPONSE_PROP_WITHOUT_HEALTH_LIST);
                IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, cmRes.getResourceType(), props);
                handler.doIt(context);
                this.resetContext(context);
                dispPath = cmRes.getDispatcherPath(context);
                if (dispPath == null || dispPath.length() <= 0) continue;
                RelationshipParticipantType p = cmRes.generateQRBTPaticipant(handler, healthHandler, context);
                listOfParticipant.add(p);
                continue;
            }
            this.addQRBTChildParticipant(context, relationshipType, listOfProperties, listOfParticipant, healthHandler, cmObj, cmRes);
        }
        this.setContext(context);
        sysQRBTProps.addAll(listOfProperties);
        IPropertiesHandler sysHandler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, this.getResourceType(), sysQRBTProps);
        sysHandler.doIt(context);
        RelationshipParticipantType participant = this.generateQRBTPaticipant(sysHandler, healthHandler, context, true);
        relationship.addParticipant(participant);
        this.resetContext(context);
        if (relationshipType.equals("servers")) {
            listOfParticipant = this.buildQRBTContainerParticipants(servers, "server", listOfProperties, context);
        } else if (relationshipType.equals("servergroups")) {
            listOfParticipant = this.buildQRBTContainerParticipants(servers, "serverGroup", listOfProperties, context);
        }
        for (int i = 0; i < listOfParticipant.size(); ++i) {
            RelationshipParticipantType p = (RelationshipParticipantType)listOfParticipant.get(i);
            relationship.addParticipant(p);
        }
    }

    protected void addQRBTChildParticipant(IContext context, String relationshipType, ArrayList listOfProperties, ArrayList listOfParticipant, IPropertiesHandler healthHandler, GenericCMObject cmObj, CMResource cmRes) throws BaseFaultType {
    }

    protected void addServerContainer(IContext context, HashMap containerMap, String storeID, GenericCMObject cmObj) throws BaseFaultType {
        if (containerMap.get(storeID) == null) {
            containerMap.put(storeID, cmObj);
        }
    }

    protected ArrayList buildQRBTContainerParticipants(HashMap containerMap, String resourceType, ArrayList listOfProperties, IContext context) throws BaseFaultType {
        if (containerMap.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<String> props = new ArrayList<String>();
        props.addAll(listOfProperties);
        props.addAll(Constants.QRBT_RESPONSE_PROP_LIST);
        ArrayList<RelationshipParticipantType> listOfparticipants = new ArrayList<RelationshipParticipantType>();
        for (Map.Entry pair : containerMap.entrySet()) {
            String defaultName;
            String storeID = (String)pair.getKey();
            GenericCMObject participantCMObj = (GenericCMObject)pair.getValue();
            String string = defaultName = resourceType != null ? storeID : participantCMObj.getParameter("defaultName", "");
            if (defaultName == null || defaultName.length() == 0) {
                defaultName = "DefaultServerGroup";
            }
            String participantResourceType = resourceType != null ? resourceType : ResourceIdFactory.getResourceID(participantCMObj.getType(), null, context).getBaseType();
            IResourceID id = ResourceIdFactory.getResourceID(participantResourceType, storeID, context);
            Resource res = (Resource)ResourceLookupManager.getInstance().find(id);
            if (storeID != null && storeID.equals("DefaultServerGroup")) {
                Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
                storeID = MessagesManagerFacade.getInstance().getMessage(tLocale, "ui.defaultservergroup");
            }
            GenericCMObject cmObj = new GenericCMObject("serverContainer");
            cmObj.setParameter("defaultName", defaultName);
            context.setProperty("cmObject", (Object)cmObj);
            context.setProperty("resourceMbeanPattern", (Object)res.getMBeanNamePattern(context));
            context.setProperty("resourceID", (Object)res.getResourceID());
            IPropertiesHandler handler = ResourcePropertiesRetriever.getInstance(context).getPropertiesHandler(context, res.getResourceType(), props);
            handler.doIt(context);
            RelationshipParticipantType p = res.generateQRBTPaticipant(handler, null, context);
            listOfparticipants.add(p);
            this.resetContext(context);
        }
        return listOfparticipants;
    }

    @Override
    protected String buildRelationshipRequest(String requestedType, IContext context) throws BaseFaultType {
        try {
            StringBuffer sSearchPath = new StringBuffer();
            ArrayList cmProps = new ArrayList();
            StringBuffer sDispSearchPath = new StringBuffer();
            ArrayList dispProps = new ArrayList();
            Locale tLocale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
            if (requestedType.equalsIgnoreCase("dispatchers") || requestedType.equalsIgnoreCase("servers") || requestedType.equalsIgnoreCase("servergroups")) {
                sSearchPath.append("/configuration//dispatcher[@shown='true']");
                cmProps = ResourcePropertiesRetriever.getInstance(context).getiResourceCMProperties("dispatcher", Constants.QRBT_RESPONSE_PROP_LIST, tLocale);
                PropertyType dispPath = new PropertyType("dispatcherPath", "cm");
                dispPath.setCMObjectName("dispatcherPath");
                cmProps.add(dispPath);
                if (requestedType.equalsIgnoreCase("servergroups")) {
                    PropertyType svrGroup = new PropertyType("serverGroup", "cm");
                    svrGroup.setCMObjectName("serverGroup");
                    cmProps.add(svrGroup);
                }
            } else if (requestedType.equalsIgnoreCase("services")) {
                String seviceFilter = SystemResource.genSearchPathServiceFilter(context);
                if (seviceFilter.length() == 0) {
                    sSearchPath = new StringBuffer();
                } else {
                    sSearchPath.append("/configuration//dispatcher[@shown='true']").append("/*").append(seviceFilter);
                    cmProps = this.getServiceProperties(context, Constants.QRBT_RESPONSE_PROP_LIST, "dispatcher", tLocale);
                    sDispSearchPath.append("/configuration//dispatcher[@shown='true']");
                    this.populateServicePropsForCMRequest(cmProps, dispProps);
                }
            } else if (AdminMetadataRetriever.isService(context, requestedType)) {
                sSearchPath.append("/configuration//dispatcher[@shown='true']").append("/*[@objectClass='").append(requestedType).append("']");
                cmProps = ResourcePropertiesRetriever.getInstance(context).getiResourceCMProperties(requestedType, Constants.QRBT_RESPONSE_PROP_LIST, tLocale);
                sDispSearchPath.append("/configuration//dispatcher[@shown='true']");
                this.populateServicePropsForCMRequest(cmProps, dispProps);
            } else if (this.isSupported(requestedType)) {
                sSearchPath.append(this.getSearchPath(requestedType));
                cmProps = this.getCMProps(context, requestedType, tLocale);
            } else {
                CogAdminLogger.getInstance().warn("buildCMRequest: Unsupported Type");
                throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
            }
            String sysSearchPath = "/configuration[@shown='true']";
            PropertyType sysStoreId = new PropertyType("storeID", "cm");
            sysStoreId.setCMObjectName("storeID");
            PropertyType sysObjectClass = new PropertyType("objectClass", "cm");
            sysObjectClass.setCMObjectName("objectClass");
            ArrayList<PropertyType> sysProps = new ArrayList<PropertyType>();
            sysProps.add(sysStoreId);
            sysProps.add(sysObjectClass);
            if (sSearchPath.length() > 0 && cmProps.size() > 0) {
                StringBuffer req = CMRequestHelper.startCMQueryRequest();
                CMRequestHelper.appendQueryRequest(req, sysSearchPath, sysProps);
                if (sDispSearchPath.length() > 0 && dispProps.size() > 0) {
                    CMRequestHelper.appendQueryRequest(req, sDispSearchPath.append("[permission('read') and @shown='true']").toString(), dispProps);
                }
                CMRequestHelper.appendQueryRequest(req, sSearchPath.append("[permission('read') and @shown='true']").toString(), cmProps);
                CMRequestHelper.endCMQueryRequest(req);
                return req.toString();
            }
            CogAdminLogger.getInstance().warn("buildCMRequest: Unsupported Type");
            throw new BaseFaultType("error.qrbt.unsupportedtype", new String[]{requestedType}, null);
        }
        catch (Exception e) {
            CogAdminLogger.getInstance().error("buildCMRequest", e);
            throw new BaseFaultType("error.exception", e);
        }
    }

    protected boolean isSupported(String relationshipType) {
        return false;
    }

    protected String getDispatcherSearchPath(String requestedType) {
        return null;
    }

    protected String getSearchPath(String requestedType) {
        return null;
    }

    protected ArrayList getCMProps(IContext context, String resourceType, Locale locale) {
        return null;
    }

    private void populateServicePropsForCMRequest(ArrayList cmProps, ArrayList dispProps) {
        PropertyType parent = new PropertyType("parent", "cm");
        parent.setCMObjectName("parent");
        cmProps.add(parent);
        PropertyType dispPath = new PropertyType("dispatcherPath", "cm");
        dispPath.setCMObjectName("dispatcherPath");
        dispProps.add(dispPath);
        PropertyType dispStoreId = new PropertyType("storeID", "cm");
        dispStoreId.setCMObjectName("storeID");
        dispProps.add(dispStoreId);
    }

    @Override
    public String getMBeanNamePattern(IContext context) {
        return this.getMBeanNameWithServiceTypePattern(context, "group=System");
    }

    @Override
    protected void setContext(IContext context) {
        if (context != null) {
            context.setProperty("cmSearchPath", (Object)"/configuration[@shown='true']");
            context.setProperty("resourceMbeanPattern", (Object)this.getMBeanNamePattern(context));
            context.setProperty("cmResourceType", (Object)this.getResourceType());
            context.setProperty("IResource", (Object)this);
        }
    }

    @Override
    public GetInteractiveActivitiesResponse getInteractiveActivities(GetInteractiveActivities request, IContext context) throws BaseFaultType {
        IPropertiesHandler pHandler = ResourcePropertiesRetriever.getInstance(context).getSinglePropertyHandler(context, this.getResourceType(), "InteractiveActivities");
        if (pHandler != null) {
            context.setProperty("getInteractiveActivitiesRequest", (Object)request);
            pHandler.doIt(context);
            ArrayList propList = pHandler.getPropertyList();
            if (propList != null && propList.size() > 0) {
                IResourceProperty prop = (IResourceProperty)propList.get(0);
                Object value = prop.getValue();
                GetInteractiveActivitiesResponse rtr = this.genInteractiveActivitesResponse(value);
                return rtr;
            }
        }
        CogAdminLogger.getInstance().error("GetInteractiveActivities: Couldn't get mbean handler for system resource property 'InteractiveActivities'.");
        throw new BaseFaultType("error.interactiveactivities.general");
    }

    private GetInteractiveActivitiesResponse genInteractiveActivitesResponse(Object value) {
        GetInteractiveActivitiesResponse response = new GetInteractiveActivitiesResponse();
        PageType resultPageInfo = null;
        Object statusSummaryMap = null;
        if (value != null && Object[].class.isAssignableFrom(value.getClass())) {
            Object[] valueObj = (Object[])value;
            resultPageInfo = (PageType)valueObj[0];
            statusSummaryMap = valueObj[2];
            CompositeData[] activityList = (CompositeData[])valueObj[1];
            if (activityList != null) {
                for (int i = 0; i < activityList.length; ++i) {
                    CompositeData data = activityList[i];
                    if (data == null) continue;
                    ActivityType activity = new ActivityType();
                    Set<String> keyset = data.getCompositeType().keySet();
                    for (String itemName : keyset) {
                        Object itemValue = data.get(itemName);
                        if ((itemName.equalsIgnoreCase("StartTime") || itemName.equalsIgnoreCase("RequestTime")) && itemValue != null && Long.class == itemValue.getClass()) {
                            Date aDate = new Date((Long)itemValue);
                            itemValue = COGAdminUtils.XMLSchemaDateFormat.getTimeStamp(aDate);
                        }
                        if (itemName == null || itemName.length() <= 0) continue;
                        com.cognos.admin.ws.cogadmin.v1_0.PropertyType property = new com.cognos.admin.ws.cogadmin.v1_0.PropertyType();
                        property.setName(itemName);
                        property.setContent(itemValue != null ? itemValue.toString() : "");
                        activity.addProperty(property);
                    }
                    response.addActivity(activity);
                }
            }
        }
        if (resultPageInfo == null) {
            resultPageInfo = new PageType();
            com.cognos.admin.ws.cogadmin.v1_0.PropertyType resultPageProperty = new com.cognos.admin.ws.cogadmin.v1_0.PropertyType();
            resultPageProperty.setName("start");
            resultPageProperty.setContent("1");
            resultPageInfo.addPageProperty(resultPageProperty);
            resultPageProperty = new com.cognos.admin.ws.cogadmin.v1_0.PropertyType();
            resultPageProperty.setName("end");
            resultPageProperty.setContent("1");
            resultPageInfo.addPageProperty(resultPageProperty);
            resultPageProperty = new com.cognos.admin.ws.cogadmin.v1_0.PropertyType();
            resultPageProperty.setName("maxObjects");
            resultPageProperty.setContent("0");
            resultPageInfo.addPageProperty(resultPageProperty);
            resultPageProperty = new com.cognos.admin.ws.cogadmin.v1_0.PropertyType();
            resultPageProperty.setName("more");
            resultPageProperty.setContent("false");
            resultPageInfo.addPageProperty(resultPageProperty);
        }
        response.setPageInfo(resultPageInfo);
        ActivitySummaryType summary = new ActivitySummaryType();
        int statusCount = 0;
        if (statusSummaryMap != null) {
            Object valueObj;
            String status;
            Iterator<Object> iter;
            Set<Object> keyset;
            if (statusSummaryMap.getClass() == HashMap.class) {
                HashMap tmpMap = (HashMap)statusSummaryMap;
                keyset = tmpMap.keySet();
                iter = keyset.iterator();
                while (iter.hasNext()) {
                    status = iter.next().toString();
                    valueObj = tmpMap.get(status);
                    if (status == null || valueObj == null) continue;
                    long count = ((long[])valueObj)[0];
                    if (status.length() <= 0 || count < 0L) continue;
                    this.addStatusSummaryType(summary, status, count);
                    ++statusCount;
                }
            } else if (CompositeData.class.isAssignableFrom(statusSummaryMap.getClass())) {
                CompositeData tmpMap = (CompositeData)statusSummaryMap;
                keyset = tmpMap.getCompositeType().keySet();
                iter = keyset.iterator();
                while (iter.hasNext()) {
                    status = iter.next().toString();
                    valueObj = tmpMap.get(status);
                    if (status == null || valueObj == null) continue;
                    long count = (Long)valueObj;
                    if (status.length() <= 0 || count < 0L) continue;
                    this.addStatusSummaryType(summary, status, count);
                    ++statusCount;
                }
            }
        }
        if (statusCount == 0) {
            this.addStatusSummaryType(summary, "total", 0L);
        }
        response.setSummary(summary);
        return response;
    }

    private void addStatusSummaryType(ActivitySummaryType summary, String status, long count) {
        StatusSummaryType summaryType = new StatusSummaryType();
        summaryType.setStatus(status);
        summaryType.setContent(String.valueOf(count));
        summary.addStatusSummary(summaryType);
    }

    @Override
    public CancelInteractiveActivitiesResponse cancelInteractiveActivities(CancelInteractiveActivities request, IContext context) throws BaseFaultType {
        IPropertiesHandler pHandler = ResourcePropertiesRetriever.getInstance(context).getSinglePropertyHandler(context, this.getResourceType(), "InteractiveActivities");
        if (pHandler != null) {
            context.setProperty("cancelInteractiveActivitiesRequest", (Object)request);
            pHandler.doIt(context);
            ArrayList propList = pHandler.getPropertyList();
            if (propList != null && propList.size() > 0) {
                IResourceProperty prop = (IResourceProperty)propList.get(0);
                Object value = prop.getValue();
                CancelInteractiveActivitiesResponse rtr = this.genCancelInteractiveActivitiesResponse(value);
                return rtr;
            }
        }
        CogAdminLogger.getInstance().error("CancelInteractiveActivities: Couldn't get mbean handler for system resource property 'InteractiveActivities'.");
        throw new BaseFaultType("error.interactiveactivities.cancel.general");
    }

    private CancelInteractiveActivitiesResponse genCancelInteractiveActivitiesResponse(Object value) {
        CancelInteractiveActivitiesResponse response = new CancelInteractiveActivitiesResponse();
        if (value != null && Object[].class.isAssignableFrom(value.getClass())) {
            Object[] results = (Object[])value;
            String[] ids = (String[])results[0];
            String[] dispatchers = (String[])results[1];
            String[] responses = (String[])results[2];
            if (responses != null && responses.length > 0) {
                Object[] listOfResults = new Object[responses.length];
                for (int i = 0; i < responses.length; ++i) {
                    CogadminCastorType cct = new CogadminCastorType("Result");
                    CogadminCastorType reqId = new CogadminCastorType("RequestID");
                    reqId.setValue(ids != null && ids[i] != null ? ids[i] : "");
                    cct.addAttribute(reqId);
                    CogadminCastorType disp = new CogadminCastorType("DispatcherName");
                    disp.setValue(dispatchers != null && dispatchers[i] != null ? dispatchers[i] : "");
                    cct.addAttribute(disp);
                    cct.setValue(responses[i]);
                    listOfResults[i] = cct;
                }
                response.setAnyObject(listOfResults);
            }
        }
        return response;
    }
}

