/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.resource.v1_0;

import com.cognos.admin.common.CMRequestHelper;
import com.cognos.admin.common.COGAdminUtils;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.CMPropertyType;
import com.cognos.admin.resource.v1_0.MBeanActionType;
import com.cognos.admin.resource.v1_0.MBeanByRefActionsHandler;
import com.cognos.admin.resource.v1_0.MBeanPropertiesHandler;
import com.cognos.admin.resource.v1_0.RolapCubeResource;
import com.cognos.admin.ws.cogadmin.v1_0.Detail;
import com.cognos.admin.ws.cogadmin.v1_0.Details;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.services.IContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ViewRecentCubeActionMessagesActionsHandler
extends MBeanByRefActionsHandler {
    protected int msgLimit = 50;

    public ViewRecentCubeActionMessagesActionsHandler() {
        this.setMsgLimit(this.msgLimit);
    }

    protected void setMsgLimit(int limit) {
        this.msgLimit = limit;
    }

    protected int getMsgLimit() {
        return this.msgLimit;
    }

    @Override
    public void doIt(IContext context) throws BaseFaultType {
        if (this.m_actionList == null || this.m_actionList.size() != 1) {
            return;
        }
        MBeanActionType mat = (MBeanActionType)this.m_actionList.get(0);
        String sObjectName = mat.getObjectName();
        String sLookupString = mat.getOperation();
        String[] lookupParts = null;
        if (sLookupString != null) {
            lookupParts = sLookupString.split("::", 4);
        }
        if (sObjectName != null && lookupParts != null && lookupParts.length == 4) {
            String mbeanName = this.resolveMBeanObjectName(context, mat);
            ArrayList<String> cubeStateAttName = new ArrayList<String>();
            cubeStateAttName.add(lookupParts[0]);
            AttributeList cubeStateAttList = MBeanPropertiesHandler.queryMBean(this.getMBeanServer(), mbeanName, cubeStateAttName);
            if (cubeStateAttList != null && cubeStateAttList.size() > 0) {
                CompositeData cubeState;
                Object cubeStatesObj;
                Attribute cubeStateAtt = (Attribute)cubeStateAttList.get(0);
                Object messagesObject = null;
                Object cubeStateObj = cubeStateAtt.getValue();
                if (cubeStateObj != null && CompositeData.class.isAssignableFrom(cubeStateObj.getClass()) && (cubeStatesObj = (cubeState = (CompositeData)cubeStateObj).get(lookupParts[1])) != null && TabularData.class.isAssignableFrom(cubeStatesObj.getClass())) {
                    TabularData cubeStates = (TabularData)cubeStatesObj;
                    String sCubeName = (String)context.getProperty(lookupParts[2]);
                    if (sCubeName != null) {
                        Object[] key = new String[]{sCubeName};
                        CompositeData row = cubeStates.get(key);
                        messagesObject = row.get(lookupParts[3]);
                    }
                }
                if (messagesObject != null && TabularData.class.isAssignableFrom(messagesObject.getClass())) {
                    TabularData messages = (TabularData)messagesObject;
                    Details details = new Details();
                    Locale locale = MessagesManagerFacade.createLocale((String)context.getProperty("PRODUCT_LOCALE"));
                    this.populateDetails(context, messages, details, locale);
                    if (details.getDetailCount() > 0) {
                        mat.setValue(details);
                    }
                }
            }
        }
    }

    protected void populateDetails(IContext context, TabularData messages, Details details, Locale locale) throws BaseFaultType {
        for (int i = 0; i < messages.size() && i < this.getMsgLimit(); ++i) {
            Object[] messagesKey = new Long[]{new Long(i)};
            CompositeData message = messages.get(messagesKey);
            if (message == null) continue;
            this.addDetail(context, details, locale, message);
        }
    }

    private void addDetail(IContext context, Details details, Locale locale, CompositeData message) throws BaseFaultType {
        TabularData messageDetails;
        Object messageDetailsObject = message.get("messageDetails");
        if (messageDetailsObject != null && TabularData.class.isAssignableFrom(messageDetailsObject.getClass()) && (messageDetails = (TabularData)messageDetailsObject).size() > 0) {
            Detail detail = new Detail();
            Date timeStamp = (Date)message.get("timestamp");
            detail.setTime(COGAdminUtils.formatDate(timeStamp, "GMT"));
            this.processMessageDetails(context, locale, detail, messageDetails);
            details.addDetail(detail);
        }
    }

    private void processMessageDetails(IContext context, Locale locale, Detail detail, TabularData messageDetails) throws BaseFaultType {
        Object[] key = new String[1];
        for (int j = 0; j < messageDetails.size(); ++j) {
            String keyPrefix = "m" + j + "-";
            key[0] = keyPrefix + "str";
            CompositeData str = messageDetails.get(key);
            if (str != null) {
                detail.addMessage(j, (String)str.get("value"));
                continue;
            }
            key[0] = keyPrefix + "file";
            CompositeData msgBase = messageDetails.get(key);
            if (msgBase == null) continue;
            key[0] = keyPrefix + "id";
            CompositeData msgId = messageDetails.get(key);
            if (msgId == null) continue;
            ArrayList<String> sArgList = new ArrayList<String>();
            int k = 0;
            CompositeData arg = messageDetails.get(key);
            while (arg != null) {
                key[0] = keyPrefix + "p" + k;
                arg = messageDetails.get(key);
                if (arg == null) {
                    key[0] = (String)key[0] + "-c";
                    arg = messageDetails.get(key);
                }
                if (arg != null) {
                    String value = (String)arg.get("value");
                    if (value != null && ((String)key[0]).endsWith("-c")) {
                        value = this.localizeCubeNames(context, value);
                    }
                    sArgList.add(k, value);
                }
                ++k;
            }
            detail.addMessage(j, this.getLocalizedMessage(locale, (String)msgBase.get("value"), (String)msgId.get("value"), sArgList));
        }
    }

    protected String getLocalizedMessage(Locale locale, String msgBaseValue, String msgIdValue, ArrayList<String> sArgList) {
        return COGAdminUtils.getLocalizedMessage(msgBaseValue, locale, msgIdValue, sArgList.toArray());
    }

    private List selectNodes(Document doc, String xPath) {
        return doc.selectNodes(xPath);
    }

    private String localizeCubeNames(IContext context, String xmlCubeList) throws BaseFaultType {
        Document cubeList;
        try {
            cubeList = DocumentHelper.parseText((String)xmlCubeList);
        }
        catch (DocumentException e) {
            throw new BaseFaultType(e);
        }
        ArrayList<String> sSearchPaths = new ArrayList<String>();
        List xqeCubeNames = this.selectNodes(cubeList, "/cubes/cube");
        Iterator iter = xqeCubeNames.iterator();
        while (iter.hasNext()) {
            String childDefaultName = ((Element)iter.next()).getText();
            String sSearchPath = RolapCubeResource.getSearchPath(childDefaultName);
            sSearchPaths.add(sSearchPath);
        }
        List<GenericCMObject> cmObjects = this.getLocalizedCubesFromCM(context, sSearchPaths);
        String cubes = cmObjects.size() > 1 ? "[" : "";
        boolean addComma = false;
        for (GenericCMObject cmObject : cmObjects) {
            if (addComma) {
                cubes = cubes + ", ";
            } else {
                addComma = true;
            }
            cubes = cubes + cmObject.getParameter("defaultName", "");
        }
        if (cmObjects.size() > 1) {
            cubes = cubes + "]";
        }
        return cubes;
    }

    protected List<GenericCMObject> getLocalizedCubesFromCM(IContext context, List sSearchPaths) throws BaseFaultType {
        CMPropertyType propDefaultName = new CMPropertyType();
        propDefaultName.setCMObjectName("defaultName");
        String request = CMRequestHelper.buildCMQueryRequest(sSearchPaths, Arrays.asList(propDefaultName));
        return CMRequestHelper.makeCMRequest(context, request);
    }
}

