/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.service;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.service.DeleteLegacyUIProfilePortalTabsCommand;
import com.cognos.admin.service.Dispatcher;
import com.cognos.admin.service.LocalizeMultitenancyPortalObjectsCommand;
import com.cognos.admin.service.MultitenancyAddPortalObjectsCommand;
import com.cognos.admin.service.QueryNewUserInterfaceProfiles;
import com.cognos.admin.service.UserInterfaceProfilesAddPortalObjectsCommand;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.portal.fragment.service.DashboardService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CogAdminService
extends DashboardService {
    public static final String EDITION_PARAM_NAME = "edition";
    public static final String EDITION_MIDMARKET = "mid-market";
    public static HashMap<String, Collection<Dispatcher>> serverGroupsCache = new HashMap();
    private boolean checkMultiTenancyRequirements = true;
    private boolean checkUIProfilesRequirements = true;

    public void suspend() {
        this.checkUIProfilesRequirements = true;
        super.suspend();
    }

    public void resume() {
        this.checkUIProfilesRequirements = true;
        super.resume();
    }

    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.update(configuration);
        if (this.checkMultiTenancyRequirements) {
            try {
                String edition = configuration.getICCLConfiguration().getValue(EDITION_PARAM_NAME, false);
                if (CogAdminLogger.getInstance().isDebugEnabled()) {
                    CogAdminLogger.getInstance().debug("Configuration indicates installed edition is " + edition);
                }
                if (!EDITION_MIDMARKET.equals(edition)) {
                    this.createMultitenancyTab(configuration);
                } else if (CogAdminLogger.getInstance().isDebugEnabled()) {
                    CogAdminLogger.getInstance().debug("Skipped adding tenant management tool to Cognos Administration because tenancy is not suppored for installed edition: " + edition);
                }
                this.checkMultiTenancyRequirements = false;
            }
            catch (CCLConfigurationException e) {
                CogAdminLogger.getInstance().error("Error determining install edition. Skipped adding tenant management tool to Cognos Administration.");
                this.checkMultiTenancyRequirements = false;
            }
            catch (SoapFaultException e) {
                CogAdminLogger.getInstance().error(((Object)((Object)this)).getClass().getName() + " checkMultiTenancyRequirements command failed: " + e.getDetail(), e);
            }
            catch (CommandExecutionException e) {
                CogAdminLogger.getInstance().error(((Object)((Object)this)).getClass().getName() + " checkMultiTenancyRequirements command failed: " + e.getMessage(), e);
            }
        }
        if (this.checkUIProfilesRequirements) {
            try {
                if (this.isUserInterfaceProfileFeatureEnabled()) {
                    UserInterfaceProfilesAddPortalObjectsCommand addCommand = new UserInterfaceProfilesAddPortalObjectsCommand();
                    addCommand.execute();
                    DeleteLegacyUIProfilePortalTabsCommand deleteCommand = new DeleteLegacyUIProfilePortalTabsCommand();
                    deleteCommand.execute();
                }
                this.checkUIProfilesRequirements = false;
            }
            catch (CommandExecutionException e) {
                CogAdminLogger.getInstance().error(((Object)((Object)this)).getClass().getName() + " checkUIProfilesRequirements Command failed: " + e.getMessage(), e);
            }
        }
    }

    protected boolean isUserInterfaceProfileFeatureEnabled() throws CommandExecutionException {
        QueryNewUserInterfaceProfiles queryCommand = new QueryNewUserInterfaceProfiles();
        queryCommand.execute();
        return queryCommand.isFeatureEnabled();
    }

    public void reconfigure(Configuration configuration) {
        super.reconfigure(configuration);
        this.update(configuration);
    }

    private void update(Configuration configuration) {
        serverGroupsCache.clear();
        DispatcherList dispListObj = (DispatcherList)configuration.getDispatcherList();
        for (Object oServerGroup : dispListObj.getCompleteServerGroups()) {
            String serverGroup = oServerGroup.toString();
            HashSet<Dispatcher> dispList = new HashSet<Dispatcher>();
            Collection dispListElements = dispListObj.getAllDispatcherListElements(serverGroup);
            for (DispatcherListElement dispListElement : dispListElements) {
                Dispatcher dispatcher = new Dispatcher(dispListElement.getName(), dispListElement.getPath());
                dispList.add(dispatcher);
            }
            if (serverGroup == "") {
                serverGroup = "DefaultServerGroup";
            }
            serverGroupsCache.put(serverGroup, dispList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Dispatcher> getServerGroupDispatchers(String serverGroup) {
        HashMap<String, Collection<Dispatcher>> hashMap = serverGroupsCache;
        synchronized (hashMap) {
            HashSet<Dispatcher> dispatchers = new HashSet<Dispatcher>();
            dispatchers.addAll(serverGroupsCache.get(serverGroup));
            return dispatchers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getServerGroups() {
        HashMap<String, Collection<Dispatcher>> hashMap = serverGroupsCache;
        synchronized (hashMap) {
            return serverGroupsCache.keySet();
        }
    }

    protected void createMultitenancyTab(Configuration configuration) throws CommandExecutionException {
        CogAdminLogger.getInstance().debug("Adding tenant management tool to Cognos Administration.");
        new MultitenancyAddPortalObjectsCommand().execute();
        CogAdminLogger.getInstance().debug("Updating tenant management tool with configurated product languages.");
        new LocalizeMultitenancyPortalObjectsCommand().execute();
        CogAdminLogger.getInstance().logTrace("Successfully registered multitenancy portlets", 0, false);
    }
}

