/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.service;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.service.CogAdminContentManagerCommand;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.QName;

public abstract class LocalizePortalObjectsCommand
extends CogAdminContentManagerCommand {
    protected static final String SEARCHPATH_TO_ADMINISTARTION = "/portal/portalPackage[@name='Administration']";
    protected static final String SEARCHPATH_TO_COGADMIN_PRODUCER = "/portal/portalPackage[@name='Administration']/portletFolder[@name='Portlets']/portletFolder[@name='Console']/portletProducer[@name='cogadmin']";
    protected static final String SEARCHPATH_TO_CONSOLE_PAGELETFOLDER = "/portal/portalPackage[@name='Administration']/pageletFolder[@name='Pagelets']/pageletFolder[@name='Console']";
    protected static final String TENANTS_PAGELET_NAME = "Tenants";
    protected static final String USERINTERFACEPROFILE_PAGELET_NAME = "User Interface Profiles";
    protected static final QName BUS_OBJECTS = new QName("objects", BUS_NAMESPACE);
    protected static final QName BUS_ITEM = new QName("item", BUS_NAMESPACE);
    protected static final QName BUS_VALUE = new QName("value", BUS_NAMESPACE);
    protected static final QName BUS_SEARCHPATH = new QName("searchPath", BUS_NAMESPACE);
    protected static final QName BUS_NAME = new QName("name", BUS_NAMESPACE);
    protected static final QName BUS_ACCESS = new QName("access", BUS_NAMESPACE);
    private static final QName BUS_UPDATE = new QName("update", BUS_NAMESPACE);
    private static final QName BUS_LOCALE = new QName("locale", BUS_NAMESPACE);
    Map<String, String> localeMap = null;
    private Element eObjects;

    public LocalizePortalObjectsCommand() {
        this.setDoTrustedRequest(true);
        try {
            this.localeMap = CCLConfigurationFactory.getInstance().getProductLocaleList("en");
        }
        catch (CCLConfigurationException e) {
            String sError = e.getMessage();
            CogAdminLogger.getInstance().error(((Object)((Object)this)).getClass().getName() + " Command failed: " + sError, e);
        }
        finally {
            if (this.localeMap == null) {
                this.localeMap = new HashMap<String, String>();
            }
            if (!this.localeMap.containsKey("en")) {
                this.localeMap.put("en", "English");
            }
        }
    }

    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
    }

    protected void executeImpl(Element requestElement) throws CommandExecutionException {
        Element eUpdate = requestElement.addElement(BUS_UPDATE);
        this.eObjects = eUpdate.addElement(BUS_OBJECTS);
        this.eObjects.addAttribute(SOAPEnvelope.XSI_TYPE, "SOAP-ENC:Array");
        this.eObjects.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClass[2]");
        this.addItems();
    }

    abstract void addItems();

    protected void addItem(String searchPath, String objectClass, HashMap<String, String> names) {
        Element eItem = this.eObjects.addElement(BUS_ITEM);
        eItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":" + objectClass);
        Element eSearch = eItem.addElement(BUS_SEARCHPATH);
        eSearch.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        eSearch.addElement(BUS_VALUE).addText(searchPath);
        Element eName = eItem.addElement(BUS_NAME);
        eName.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":multilingualTokenProp");
        Element eValue = eName.addElement(BUS_VALUE);
        eValue.addAttribute(SOAPEnvelope.XSI_TYPE, "SOAP-ENC:Array");
        eValue.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":multilingualToken[]");
        for (String locale : names.keySet()) {
            Element eValueItem = eValue.addElement(BUS_ITEM);
            eValueItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":multilingualToken");
            Element eItemLocale = eValueItem.addElement(BUS_LOCALE);
            eItemLocale.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            eItemLocale.setText(locale);
            Element eItemValue = eValueItem.addElement(BUS_VALUE);
            eItemValue.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            eItemValue.setText(names.get(locale));
        }
    }
}

