/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.xts;

import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.util.ByteArrayIOStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;

public class PngImageResult
implements IXTSOutputableInstructionResult {
    private byte[] m_pngDataBytes = null;
    private ContentType m_contentType = null;

    public PngImageResult(byte[] pngDataBytes) {
        this.m_pngDataBytes = pngDataBytes;
    }

    public boolean attachmentsSupported() {
        return false;
    }

    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return null;
    }

    public ContentType getDefaultMimeType() throws XTSInstructionException {
        if (this.m_contentType == null) {
            try {
                this.m_contentType = new ContentType("image/png");
            }
            catch (ParseException e) {
                Object[] args = new Object[]{"image/png"};
                throw new XTSInstructionException("protocol.invalidcontenttype", args, (Throwable)e);
            }
        }
        return this.m_contentType;
    }

    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return null;
    }

    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    public int getSupportedOptionsBitMap() {
        return 4;
    }

    public boolean protocolHeaderSupported() {
        return false;
    }

    public boolean statusHeaderSupported() {
        return false;
    }

    public XTSSource getResult() throws XTSInstructionException {
        return new XTSSource((InputStream)new ByteArrayInputStream(this.m_pngDataBytes));
    }

    public void release() throws XTSInstructionException {
    }

    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            bio.write(this.m_pngDataBytes);
            bio.flush();
            bio.writeTo(out);
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, (Throwable)e);
        }
    }
}

