/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.xts;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.admin.ws.wsrf.wsrf_rp.v1_2.TypeFactory;
import com.cognos.admin.xts.CogadminHandler;
import com.cognos.admin.xts.XTSUtils;
import com.cognos.cps.bseries.xts.common.sax.BIBusBufferXMLContentHandler;
import com.cognos.cps.bseries.xts.common.sax.CookieVarsHandler;
import com.cognos.cps.bseries.xts.common.sax.LocalesHandler;
import com.cognos.cps.bseries.xts.common.sax.ParseUtils;
import com.cognos.cps.bseries.xts.common.sax.PassportHandler;
import com.cognos.cps.bseries.xts.common.sax.ServiceSoapHandler;
import com.cognos.cps.bseries.xts.common.utils.SoapUtils;
import com.cognos.cps.common.sax.MultiHandler;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.helpers.ContextImpl;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RequestParser {
    public static final int WSRF_RP = 1;
    public static final int WSDM_MUWS2 = 2;
    public static final int COGADMIN = 3;
    private QName busHeaderQName = new QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
    private BIBusBufferXMLContentHandler busHeaderHandler = new BIBusBufferXMLContentHandler(this.busHeaderQName);
    private LocalesHandler localesHandler = new LocalesHandler();
    private PassportHandler passportHandler = new PassportHandler();
    private CogadminHandler cogadminHeaderHandler = new CogadminHandler();
    private CookieVarsHandler cookieVarsHandler = new CookieVarsHandler();
    private IContext context = null;
    private ServiceSoapHandler soapHandler;
    private SOAPObjectHandler typeFactory;
    private String typeFactoryNamespace;
    private boolean m_bParsePassport = false;

    public static RequestParser create(int factoryType) {
        RequestParser result = null;
        switch (factoryType) {
            case 1: {
                result = new RequestParser(TypeFactory.newInstance(), "http://docs.oasis-open.org/wsrf/rp-2");
                break;
            }
            case 2: {
                result = new RequestParser(com.cognos.admin.ws.wsdm.muws2.v1_1.TypeFactory.newInstance(), "http://docs.oasis-open.org/wsdm/muws2-2.xsd");
                break;
            }
            case 3: {
                result = new RequestParser(com.cognos.admin.ws.cogadmin.v1_0.TypeFactory.newInstance(), "http://developer.cognos.com/admin/properties");
            }
        }
        return result;
    }

    protected RequestParser(SOAPObjectHandler typeFactory, String typeFactoryNamespace) {
        this.typeFactory = typeFactory;
        this.typeFactoryNamespace = typeFactoryNamespace;
    }

    public void parseRequest(Reader body) {
        this.parseRequest(body, false);
    }

    public void parseRequest(Reader body, boolean parsePassport) {
        ContentHandler[] handlers;
        MultiHandler headerHandler = null;
        if (parsePassport) {
            handlers = new ContentHandler[]{this.busHeaderHandler, this.localesHandler, this.cogadminHeaderHandler, this.cookieVarsHandler, this.passportHandler};
            headerHandler = new MultiHandler(handlers);
            this.m_bParsePassport = true;
        } else {
            handlers = new ContentHandler[]{this.busHeaderHandler, this.localesHandler, this.cogadminHeaderHandler, this.cookieVarsHandler};
            headerHandler = new MultiHandler(handlers);
            this.m_bParsePassport = false;
        }
        this.soapHandler = new ServiceSoapHandler(this.getTypeFactory(), (ContentHandler)headerHandler);
        XMLReader xmlReader = ParseUtils.getXMLReader();
        xmlReader.setContentHandler((ContentHandler)this.soapHandler);
        try {
            xmlReader.parse(new InputSource(body));
        }
        catch (IOException e) {
            CogAdminLogger.getInstance().error("Failed to parse request", e);
        }
        catch (SAXException e) {
            CogAdminLogger.getInstance().error("Failed to parse request", e);
        }
    }

    public IResourceID getResourceIdentifier() throws BaseFaultType {
        return this.cogadminHeaderHandler.getResourceIdentifier();
    }

    public IContext getContext() throws BaseFaultType {
        if (null == this.context) {
            this.context = new ContextImpl();
            this.context.setProperty("PRODUCT_LOCALE", (Object)this.localesHandler.getProductLocale());
            this.context.setProperty("CONTENT_LOCALE", (Object)this.localesHandler.getContentLocale());
            this.context.setProperty("BUS_HEADER", (Object)this.busHeaderHandler.getElementAsString(this.busHeaderQName));
            this.context.setProperty("COOKIES", (Object)this.cookieVarsHandler.getCookies());
            if (this.m_bParsePassport) {
                this.context.setProperty("PASSPORT", (Object)this.passportHandler.getPassportID());
            }
            this.context.setProperty("resourceID", (Object)this.cogadminHeaderHandler.getResourceIdentifier());
        }
        return this.context;
    }

    public Object getObject() {
        return this.soapHandler.getObject();
    }

    public String getResponseName() {
        return this.soapHandler.getMethodName() + "Response";
    }

    public Reader getResponseReader(Object response) throws XTSInstructionException {
        return this.getResponseReader(response, true);
    }

    public Reader getResponseReader(Object response, boolean includeEnvelope) throws XTSInstructionException {
        Reader responseReader = null;
        String result = XTSUtils.serialize(this.getTypeFactory(), this.getTypeFactoryNamespace(), response, this.getResponseName());
        if (includeEnvelope) {
            String[] headers = new String[]{this.context.getProperty("BUS_HEADER").toString()};
            responseReader = SoapUtils.createSOAPEnvelopeReader((String)result, (String[])headers, (String)"");
        } else {
            responseReader = new StringReader(result);
        }
        return responseReader;
    }

    public SOAPObjectHandler getTypeFactory() {
        return this.typeFactory;
    }

    public String getTypeFactoryNamespace() {
        return this.typeFactoryNamespace;
    }
}

