/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.xts;

import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;

public class ResourceId {
    public static final String getType(String sResourceId) throws BaseFaultType {
        return ResourceId.getResourceId(sResourceId).getType();
    }

    public static final String getId(String sResourceId) throws BaseFaultType {
        return ResourceId.getResourceId(sResourceId).getId();
    }

    public static final String getReferringResourceId(String sResourceId) throws BaseFaultType {
        return ResourceId.getResourceId(sResourceId).getReferringResourceID().toString();
    }

    public static final String getResourceId(String sResourceId, String type) throws BaseFaultType {
        IResourceID resourceId = ResourceId.getResourceId(sResourceId);
        if (resourceId.getBaseType().equals(type)) {
            return sResourceId;
        }
        return ResourceId.getReferringResourceId(sResourceId, type);
    }

    public static final String getReferringResourceId(String sResourceId, String type) throws BaseFaultType {
        IResourceID resourceId = ResourceId.getResourceId(sResourceId).getReferringResourceID();
        if (resourceId != null) {
            if (resourceId.getBaseType().equals(type)) {
                return resourceId.toString();
            }
            return ResourceId.getReferringResourceId(resourceId.toString(), type);
        }
        return null;
    }

    private static final IResourceID getResourceId(String resourceId) throws BaseFaultType {
        return ResourceIdFactory.getResourceID(resourceId);
    }

    public static final String getDefaultResourceId(String application) {
        return ResourceLookupManager.getInstance().getRootResourceId(application);
    }

    public static final String getMetricsAndSettingsResourceId(String resourceId) throws BaseFaultType {
        try {
            IResourceID currentResId = ResourceIdFactory.getResourceID(resourceId);
            if (currentResId.getBaseType().equals("queryService")) {
                IResourceID refResId = currentResId.getReferringResourceID();
                if (refResId != null) {
                    IResourceID ref = ResourceIdFactory.getResourceID("cm", currentResId.getBaseType(), currentResId.getId(), null);
                    return ResourceIdFactory.getResourceID("cm", refResId.getBaseType(), refResId.getId(), ref).toString();
                }
                return ResourceIdFactory.getResourceID("cm", "queryService", currentResId.getId(), refResId).toString();
            }
        }
        catch (BaseFaultType e) {
            resourceId = ResourceLookupManager.getInstance().getRootResourceId("cm");
        }
        return resourceId;
    }
}

