/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.xts;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.CharArrayReaderWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;

public class XTSResult
implements IXTSOutputableInstructionResult {
    private static final String XML_BASE_CONTENT_TYPE = "text/xml; charset=utf-8";
    private ContentType m_contentType = null;
    Reader m_result = null;

    public XTSResult(Reader reader) {
        this.m_result = reader;
    }

    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter outputStreamWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            CharArrayReaderWriter copyOfWriter = new CharArrayReaderWriter();
            char[] buf = new char[4096];
            int bytesRead = this.m_result.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((Writer)outputStreamWriter).write(buf, 0, bytesRead);
                copyOfWriter.write(buf, 0, bytesRead);
                bytesRead = this.m_result.read(buf, 0, 4096);
            }
            ((Writer)outputStreamWriter).flush();
            copyOfWriter.flush();
            bio.writeTo(out);
            this.m_result = copyOfWriter.convert();
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            XTSInstructionException xie = new XTSInstructionException("instruction.writetooutputstreamfailed", args, (Throwable)e);
            CogAdminLogger.getInstance().error("writeCopyTo", e);
            throw xie;
        }
    }

    public ContentType getDefaultMimeType() throws XTSInstructionException {
        if (this.m_contentType == null) {
            try {
                this.m_contentType = new ContentType(XML_BASE_CONTENT_TYPE);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{XML_BASE_CONTENT_TYPE};
                XTSInstructionException xie = new XTSInstructionException("protocol.invalidcontenttype", args, (Throwable)e);
                CogAdminLogger.getInstance().error("getDefaultMimeType", e);
                throw xie;
            }
        }
        return this.m_contentType;
    }

    public int getSupportedOptionsBitMap() {
        return 1;
    }

    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return null;
    }

    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    public XTSSource getResult() throws XTSInstructionException {
        return new XTSSource(this.m_result);
    }

    public boolean protocolHeaderSupported() {
        return false;
    }

    public boolean statusHeaderSupported() {
        return false;
    }

    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return null;
    }

    public boolean attachmentsSupported() {
        return false;
    }

    public void release() throws XTSInstructionException {
        try {
            this.m_result.close();
        }
        catch (IOException e) {
            XTSInstructionException xie = new XTSInstructionException("error.exception", (Throwable)e);
            CogAdminLogger.getInstance().error("release", e);
            throw xie;
        }
    }
}

