/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.xts.ext;

import com.cognos.admin.common.DateDuration;
import com.cognos.admin.common.DateDurationException;
import com.cognos.admin.common.DurationDefinition;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.common.message.MessagesManagerFacade;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.admin.xts.ext.URLEncoderDecoder;
import com.cognos.i18n.NumericFormat;
import com.cognos.xts.ext.NumberFormatter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class XTSExt {
    private static final int ONE_DAY = 86400000;
    public static final String ISA8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static int LONG_FORMAT = 2;
    public static final String ERROR_GENERATE_DURATION = "ERROR_CALCULATE_DURATION";
    public static final String ERROR_FORMAT_DURATION = "ERROR_FORMAT_DURATION";

    public static String formatDateDifference(String startDate, String endDate, String locale, int style) throws Exception {
        String duration;
        block5: {
            duration = null;
            DateDuration dateDuration = null;
            DurationDefinition durationDefinition = null;
            Locale localeObj = null;
            String errorCode = null;
            try {
                localeObj = !XTSExt.isLocaleDefined(locale) ? MessagesManagerFacade.getServerLocale() : MessagesManagerFacade.createLocale(locale);
                durationDefinition = new DurationDefinition();
                durationDefinition.setStartDate(startDate);
                durationDefinition.setEndDate(endDate);
                durationDefinition.setDateFormat(ISA8601_FORMAT);
                durationDefinition.setLocale(locale);
                dateDuration = DateDuration.calculateDuration(durationDefinition);
                duration = com.cognos.xts.ext.XTSExt.formatDuration((String)dateDuration.getDuration().toString(), (String)locale, (int)style);
            }
            catch (DateDurationException ddex) {
                duration = MessagesManagerFacade.getInstance().getMessage(localeObj, ERROR_GENERATE_DURATION);
                if (CogAdminLogger.getInstance().isErrorEnabled()) {
                    CogAdminLogger.getInstance().error("Error while calculating the duration", ddex);
                }
            }
            catch (Throwable t) {
                if (errorCode == null) {
                    errorCode = ERROR_FORMAT_DURATION;
                }
                duration = MessagesManagerFacade.getInstance().getMessage(localeObj, errorCode);
                if (!CogAdminLogger.getInstance().isErrorEnabled()) break block5;
                CogAdminLogger.getInstance().error("Unexpected error while formatting the date difference", t);
            }
        }
        return duration;
    }

    private static boolean isLocaleDefined(String locale) {
        return locale != null && locale.trim().length() > 0;
    }

    private static StringBuffer format(short number) {
        StringBuffer sb = new StringBuffer(2);
        if (number < 10) {
            sb.append('0');
        }
        return sb.append(number);
    }

    private static String formatNumber(String number, String format, String locale) throws Exception {
        return NumberFormatter.format((String)number, (String)format, (String)locale, (int)2);
    }

    public static String formatPercentage(String number, String locale) throws Exception {
        NumericFormat formatter = new NumericFormat(12, new Locale(locale));
        formatter.setMaximumFractionDigits(2);
        return formatter.format(Double.valueOf(number).doubleValue());
    }

    public static long durationToMilliseconds(String isoDuration) throws Exception {
        if (isoDuration == null || isoDuration.length() == 0) {
            return 0L;
        }
        return com.cognos.xts.ext.XTSExt.durationToMilliseconds((String)isoDuration);
    }

    public static String urlencode(String value) throws UnsupportedEncodingException {
        return URLEncoderDecoder.encode(value, "UTF-8");
    }

    public static String getDefaultResourceId(String application) {
        return ResourceLookupManager.getInstance().getRootResourceId(application);
    }
}

