/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.xts.function;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionResult;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ConvertStoreIdsFromJsonToXml
extends AXTSInstruction
implements IXTSFunctionInstruction {
    static final String ERROR_CONVERTING = "error.convertStoreIdsFromJsonToXml";
    static final String ERROR_NO_PARAMS = "error.convertStoreIdsFromJsonToXml.noParams";
    static final String ERROR_NO_STOREID_PARAM = "error.convertStoreIdsFromJsonToXml.noStoreidParam";
    static final String XML_ELT_NAME_STOREIDS = "storeIDs";
    static final String XML_ELT_NAME_STOREID = "storeID";
    static final String XML_NO_STOREIDS = "<storeIDs/>";
    static final String STOREID_PARAM_NAME = "storeIds";
    static final String STORED_ID_KEY = "storeID";
    private String identifier = null;

    public String getIdentifier() {
        return this.identifier;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.identifier = identifier;
    }

    public boolean isInitialized() {
        return this.identifier != null;
    }

    public void terminate() throws XTSInstructionException {
    }

    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        String json = null;
        XTSFunctionResult result = null;
        String xml = null;
        try {
            json = this.getJsonStringFromParams(instParams);
            xml = this.isJsonStringDefined(json) ? this.jsonToXml(json) : XML_NO_STOREIDS;
            result = new XTSFunctionResult(xml);
        }
        catch (Throwable t) {
            throw new XTSInstructionException(ERROR_CONVERTING, t);
        }
        return result;
    }

    private String getJsonStringFromParams(Map<String, String[]> params) throws XTSInstructionException {
        String[] values = null;
        String json = null;
        if (params == null) {
            throw new XTSInstructionException(ERROR_NO_PARAMS);
        }
        values = params.get(STOREID_PARAM_NAME);
        if (values != null && values.length > 0) {
            json = values[0];
        }
        return json;
    }

    private boolean isJsonStringDefined(String json) {
        return json != null && json.trim().length() > 0;
    }

    private String jsonToXml(String json) throws IOException {
        JSONArray storedIds = null;
        StringBuffer xmlBuffer = null;
        String xml = null;
        Iterator iterator = null;
        JSONObject jsonObject2 = null;
        String storeId = null;
        xmlBuffer = new StringBuffer();
        storedIds = JSONArray.parse((String)json);
        for (JSONObject jsonObject2 : storedIds) {
            storeId = this.retrieveStoreIdFromJsonObject(jsonObject2);
            if (!this.isStoreIdDefined(storeId)) continue;
            xmlBuffer.append(ConvertStoreIdsFromJsonToXml.startXmlTag("storeID") + storeId + ConvertStoreIdsFromJsonToXml.endXmlTag("storeID"));
        }
        xml = xmlBuffer.length() == 0 ? XML_NO_STOREIDS : ConvertStoreIdsFromJsonToXml.startXmlTag(XML_ELT_NAME_STOREIDS) + xmlBuffer.toString() + ConvertStoreIdsFromJsonToXml.endXmlTag(XML_ELT_NAME_STOREIDS);
        return xml.toString();
    }

    private String retrieveStoreIdFromJsonObject(JSONObject jsonObject) {
        String storeId = null;
        Object value = jsonObject.get((Object)"storeID");
        if (value != null && value instanceof String) {
            storeId = value.toString();
        }
        return storeId;
    }

    private boolean isStoreIdDefined(String storeId) {
        return storeId != null && storeId.length() > 0;
    }

    private static String startXmlTag(String name) {
        return "<" + name + ">";
    }

    private static String endXmlTag(String name) {
        return "</" + name + ">";
    }
}

