/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cogadmin;

import com.ibm.cognos.cogadmin.Permissions;

public class PermissionsUtils {
    public static String READ_PERMISSIONS = "read";
    public static String WRITE_PERMISSIONS = "write";
    public static String EXECUTE_PERMISSIONS = "execute";
    public static String TRAVERSE_PERMISSIONS = "traverse";
    public static String SETPOLICY_PERMISSIONS = "setPolicy";

    public static boolean hasReadAccess(String[] permissions) {
        boolean readAccess = false;
        if (permissions != null) {
            for (String permission : permissions) {
                readAccess = readAccess || READ_PERMISSIONS.equals(permission);
            }
        }
        return readAccess;
    }

    public static final Permissions createPermissions(String[] permissionWords) {
        String trimmedWord = null;
        Permissions permissions = null;
        permissions = new Permissions();
        for (int i = 0; i < permissionWords.length; ++i) {
            if (permissionWords[i] == null) continue;
            trimmedWord = permissionWords[i].trim();
            if (!permissions.getCanRead()) {
                permissions.setCanRead(READ_PERMISSIONS.equals(trimmedWord));
            }
            if (!permissions.getCanWrite()) {
                permissions.setCanWrite(WRITE_PERMISSIONS.equals(trimmedWord));
            }
            if (!permissions.getCanExecute()) {
                permissions.setCanExecute(EXECUTE_PERMISSIONS.equals(trimmedWord));
            }
            if (!permissions.getCanTraverse()) {
                permissions.setCanTraverse(TRAVERSE_PERMISSIONS.equals(trimmedWord));
            }
            if (permissions.getCanSetPolicy()) continue;
            permissions.setCanSetPolicy(SETPOLICY_PERMISSIONS.equals(trimmedWord));
        }
        return permissions;
    }
}

