/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cogadmin.common;

import java.util.Set;

public class SearchPathUtils {
    public static String buildNameCritera(String name) {
        return SearchPathUtils.buildNameCriteria(name, true);
    }

    private static String buildNameCriteria(String name, boolean includeBrackets) {
        if (name == null) {
            throw new IllegalArgumentException("Undefined name");
        }
        StringBuffer criteria = new StringBuffer();
        if (includeBrackets) {
            criteria.append('[');
        }
        if (SearchPathUtils.containsSingleQuote(name) && SearchPathUtils.containsDoubleQuote(name)) {
            throw new IllegalArgumentException("the passed name contains both ' and \" characters");
        }
        if (SearchPathUtils.containsSingleQuote(name)) {
            criteria.append("@name=\"" + name + "\"");
        } else {
            criteria.append("@name='" + name + "'");
        }
        if (includeBrackets) {
            criteria.append(']');
        }
        return criteria.toString();
    }

    public static String buildNameCritera(Set<String> names) {
        StringBuffer criteria = new StringBuffer("[");
        for (String name : names) {
            if (criteria.length() > 1) {
                criteria.append(" or ");
            }
            criteria.append(SearchPathUtils.buildNameCriteria(name, false));
        }
        criteria.append(']');
        return criteria.toString();
    }

    private static boolean containsSingleQuote(String name) {
        return name.indexOf(39) >= 0;
    }

    private static boolean containsDoubleQuote(String name) {
        return name.indexOf(34) >= 0;
    }
}

