<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cogadmin

    (C) Copyright IBM Corp. 2005, 2012

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
   Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
   Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<!-- Notes/Issues :
	1)  What should be the resource-prop namespace? 
	2)  Only enums that are being used by the properties should be inserted in the output
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:resource-prop="http://developer.cognos.com/admin/properties" xmlns:nemo="http://developer.cognos.com/nemo" xmlns:exslt="http://exslt.org/sets" exclude-result-prefixes="exslt">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:key name="groups" match="property" use="MetricGroup"/>
	<xsl:key name="base-properties" match="property" use="@id"/>
	<!-- load in the schema helper file -->
	<xsl:variable name="metricsSchemaFile" select="iManage-metadata.xml"/>
	<xsl:variable name="metricsSchema" select="document($metricsSchemaFile)/metricsSchema"/>
	<xsl:param name="gClass"/>
	<xsl:variable name="currentClass">
		<xsl:choose>
			<xsl:when test="$gClass != ''">
				<xsl:value-of select="$gClass"/>
			</xsl:when>
			<xsl:when test="/root/currentClass!=''">
				<xsl:value-of select="/root/currentClass"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'dispatcher'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!-- namespaces -->
	<xsl:template match="/root">
		<xsl:apply-templates select="*[local-name()='cogadmin']"/>
	</xsl:template>
	<!-- 
	******************************************************
		entry point  
	******************************************************
	-->
	<xsl:template match="cogadmin">
		<!-- 
			xsl:element doesn't put the namespace definitions (i.e. xs, wsrp, ...) so don't use xsl:element for the
			root element so all the namespaces get defined
		-->
		<nemo:MetadataDescriptor xmlns:resource-prop="http://developer.cognos.com/admin/properties" xmlns:nemo="http://developer.cognos.com/nemo" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
			<xsl:variable name="class" select="./class[@name=string($currentClass)]"/>
			<nemo:Name>
				<xsl:value-of select="concat($currentClass,'MetadataDescriptor')"/>
			</nemo:Name>
			<nemo:PropertiesGroups>
				<xsl:apply-templates select="$class/Capability" mode="metadataGroupsGeneration"/>
				<xsl:apply-templates select="exslt:distinct( key('base-properties', $class/property[@refID]/@refID)/MetricGroup )" mode="metadataGroupGeneration"/>
			</nemo:PropertiesGroups>
			<xsl:apply-templates select="$class" mode="metadataGeneration"/>
		</nemo:MetadataDescriptor>
	</xsl:template>
	<!-- 
	******************************************************
		Take care of the recursion 
	******************************************************
	-->
	<xsl:template match="Capability" mode="metadataGroupsGeneration">
		<xsl:variable name="groupName" select="."/>
		<xsl:apply-templates select="../../property[Capability=string($groupName)][generate-id(.)=generate-id(key('groups',MetricGroup))]/MetricGroup" mode="metadataGroupGeneration"/>
	</xsl:template>
	<xsl:template match="MetricGroup" mode="metadataGroupGeneration">
		<xsl:variable name="groupName" select="."/>
		<xsl:variable name="groupWithoutPrefix" select="substring-after($groupName, '/Metrics/')"/>
		<xsl:variable name="upperName" select="translate($groupWithoutPrefix, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
		<nemo:PropertiesGroup>
			<nemo:Caption>
				<xsl:value-of select="concat('IDS_PROP_GRP_',$upperName,'_CAPTION')"/>
			</nemo:Caption>
			<nemo:Description>
				<xsl:value-of select="concat('IDS_PROP_GRP_',$upperName,'_DESC')"/>
			</nemo:Description>
			<nemo:URI>
				<xsl:value-of select="."/>
			</nemo:URI>
		</nemo:PropertiesGroup>
	</xsl:template>
	<!--
	<xsl:template match="class" mode="metadataGeneration">
		<xsl:apply-templates select="property" mode="metricGeneration"/>
		<xsl:apply-templates select="Capability" mode="capabilityGeneration"/>
	</xsl:template>
		-->
	<xsl:template match="class" mode="metadataGeneration">
		<xsl:apply-templates select="property[not (@refID)]" mode="metricGeneration"/>
		<xsl:apply-templates select="property[@refID]" mode="metricGenerationRef"/>
		<xsl:apply-templates select="Capability" mode="capabilityGeneration"/>
		<xsl:variable name="currentClass" select="."/>
		<xsl:for-each select="../action[Capability = $currentClass/Capability]">
			<xsl:apply-templates select="." mode="actionGeneration"/>
		</xsl:for-each>
		<xsl:apply-templates select="ActionContexts"/>
	</xsl:template>
	<xsl:template match="ActionContexts">
		<nemo:ActionContexts>
			<xsl:for-each select="Context">
				<nemo:Context>
					<xsl:copy-of select="./@*"/>
				</nemo:Context>
			</xsl:for-each>
		</nemo:ActionContexts>
	</xsl:template>
	<xsl:template match="Capability" mode="capabilityGeneration">
		<xsl:variable name="capabilityGroup" select="."/>
		<xsl:apply-templates select="../../property[Capability=string($capabilityGroup) and not (@refID)]" mode="metricGeneration"/>
		<xsl:apply-templates select="../../property[Capability=string($capabilityGroup) and @refID]" mode="metricGenerationRef"/>
	</xsl:template>
	<xsl:template match="property" mode="metricGenerationRef" priority="2">
		<xsl:apply-templates select="key('base-properties', @refID)" mode="metricGeneration">
			<xsl:with-param name="ref" select="."/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="property" mode="metricGeneration" priority="2">
		<xsl:param name="ref" select="."/>					
		<!-- 
			make sure we only put the metrics we find in schema-gen-helper (i.e. don't exist in ContentManagerRules). 
			Currently fetched from our file.
			<nemo:Property>
				<nemo:Name>resource-prop:failures</nemo:Name>
				<nemo:Caption>Number of requests received that resulted in a fault.</nemo:Caption>
				<nemo:Icon/>
				<nemo:Mutability>true</nemo:Mutability>
				<nemo:Modifiability>
					<nemo:Value>read-only</nemo:Value>
				</nemo:Modifiability>
				<nemo:Type>LongMetric</nemo:Type>
				<nemo:ChangeType>Counter</nemo:ChangeType>
				<nemo:TimeScope>SinceReset</nemo:TimeScope>
				<nemo:GatheringTime>OnChange</nemo:GatheringTime>
				<nemo:CanBeReset>true</nemo:CanBeReset>
				<nemo:Capability>http://docs.oasis-open.org/wsdm/2004/12/muws/capabilities/Metrics</nemo:Capability>
				<nemo:MetricGroup>http://cognos.com/admin/Metrics/JVM</nemo:MetricGroup>
				<nemo:MetricGroup>http://cognos.com/admin/Metrics/Request</nemo:MetricGroup>
				<nemo:Handler>
					<nemo:ObjectName>com.cognos:service=reportService,metricName=requestQueue</ObjectName>
					<nemo:Value>Count</Value>
					<nemo:Attribute wsdm="ResetAt" jmx="LastResetTime"/>
					<nemo:Attribute wsdm="LastUpdated" jmx="LastUpdateTime"/>
				</nemo:Handler>		
			</nemo:Property>

from 

			<property>
				<Name>UpTime</Name>
				<Type>time</Type>
				<ChangeType>Counter</ChangeType>
				<TimeScope>PointInTime</TimeScope>
				<GatheringTime>OnDemand</GatheringTime>
				<CanBeReset>false</CanBeReset>
				<Units>DateTime Interval</Units>
				<Capability>http://docs.oasis-open.org/wsdm/2004/12/muws/capabilities/Metrics</Capability>
				<MetricGroup>http://cognos.com/admin/Metrics/JVM</MetricGroup>
				<MetricGroup>http://cognos.com/admin/Metrics/Request</MetricGroup>
				<Handler>
					<ObjectName>com.cognos:service=reportService,metricName=requestQueue</ObjectName>
					<Value>Count</Value>
					<Attribute wsdm="ResetAt" jmx="LastResetTime"/>
					<Attribute wsdm="LastUpdated" jmx="LastUpdateTime"/>
				</Handler>		
			</property>       
-->
		<!-- 
				make sure we only put the properties we want to expose. Currently using metadata, but this should be
				pushed down into the object model 
			-->
		<xsl:variable name="metricName">
			<xsl:choose>
				<xsl:when test="$ref/@refID and $ref/Name">
					<xsl:value-of select="$ref/Name"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="Name"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="stringIDPref">
			<xsl:choose>
				<xsl:when test="$ref/@refID and $ref/StringID">
					<xsl:value-of select="$ref/StringID"/>
				</xsl:when>
				<xsl:when test="StringID">
					<xsl:value-of select="StringID"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('IDS_PROP_', $metricName)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="upperName" select="translate($stringIDPref, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
		<nemo:Property>
			<nemo:Name>
				<xsl:value-of select="$metricName"/>
			</nemo:Name>
			<nemo:Icon>Where does this come from</nemo:Icon>
			<nemo:Caption>
				<xsl:value-of select="concat($upperName,'_CAPTION')"/>
			</nemo:Caption>
			<nemo:Description>
				<xsl:value-of select="concat($upperName,'_DESC')"/>
			</nemo:Description>
			<nemo:Mutability>true</nemo:Mutability>
			<nemo:Modifiability>
				<xsl:choose>
					<xsl:when test="$ref/@refID and $ref/readWrite">read-write</xsl:when>
					<xsl:when test="readWrite">read-write</xsl:when>
					<xsl:otherwise>read-only</xsl:otherwise>
				</xsl:choose>
			</nemo:Modifiability>
			<nemo:Type>
				<xsl:choose>
					<xsl:when test="$ref/@refID and $ref/Type">
						<xsl:value-of select="$ref/Type"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="Type"/>
					</xsl:otherwise>
				</xsl:choose>
			</nemo:Type>
			<xsl:choose>
				<xsl:when test="$ref/@refID and $ref/Enumeration">
					<nemo:Enumeration>
						<xsl:apply-templates select="$ref/Enumeration" mode="copyEnumeration"/>
					</nemo:Enumeration>
				</xsl:when>
				<xsl:when test="Enumeration">
					<nemo:Enumeration>
						<xsl:apply-templates select="./Enumeration" mode="copyEnumeration"/>
					</nemo:Enumeration>
				</xsl:when>
			</xsl:choose>
			<xsl:variable name="metricChangeType">
				<xsl:choose>
					<xsl:when test="$ref/@refID and $ref/ChangeType">
						<xsl:value-of select="$ref/ChangeType"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="./ChangeType"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$metricChangeType != ''">
				<nemo:ChangeType>
					<xsl:value-of select="$metricChangeType"/>
				</nemo:ChangeType>
			</xsl:if>
			<xsl:variable name="metricTimeScope">
				<xsl:choose>
					<xsl:when test="$ref/@refID and $ref/TimeScope">
						<xsl:value-of select="$ref/TimeScope"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="./TimeScope"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$metricTimeScope != ''">
				<nemo:TimeScope>
					<xsl:value-of select="$metricTimeScope"/>
				</nemo:TimeScope>
			</xsl:if>
			<xsl:variable name="metricGatheringTime">
				<xsl:choose>
					<xsl:when test="$ref/@refID and $ref/GatheringTime">
						<xsl:value-of select="$ref/GatheringTime"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="./GatheringTime"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$metricGatheringTime != ''">
				<nemo:GatheringTime>
					<xsl:value-of select="$metricGatheringTime"/>
				</nemo:GatheringTime>
			</xsl:if>
			<xsl:variable name="metricUnits">
				<xsl:choose>
					<xsl:when test="$ref/@refID and $ref/Units">
						<xsl:value-of select="$ref/Units"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="./Units"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$metricUnits != ''">
				<nemo:Units>
					<xsl:value-of select="$metricUnits"/>
				</nemo:Units>
			</xsl:if>
			<xsl:variable name="metricCanBeReset">
				<xsl:choose>
					<xsl:when test="$ref/@refID and $ref/CanBeReset">
						<xsl:value-of select="$ref/CanBeReset"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="./CanBeReset"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$metricCanBeReset != ''">
				<nemo:CanBeReset>
					<xsl:value-of select="$metricCanBeReset"/>
				</nemo:CanBeReset>
			</xsl:if>
			<xsl:variable name="metricCanSetThreshold">
				<xsl:choose>
					<xsl:when test="$ref/@refID and $ref/CanSetThreshold">
						<xsl:value-of select="$ref/CanSetThreshold"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="./CanSetThreshold"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$metricCanSetThreshold != ''">
				<nemo:CanSetThreshold>
					<xsl:value-of select="$metricCanSetThreshold"/>
				</nemo:CanSetThreshold>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="$ref/@refID and $ref/Value">
					<xsl:apply-templates select="$ref/Value" mode="mValueElement"/>
				</xsl:when>
				<xsl:when test="Value">
					<xsl:apply-templates select="./Value" mode="mValueElement"/>
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="$ref/@refID and $ref/Handler">
					<nemo:Handler>
						<xsl:choose>
							<xsl:when test="Handler">
								<xsl:apply-templates select="Handler" mode="handlerProperty">
									<xsl:with-param name="ref" select=" $ref/Handler"/>
								</xsl:apply-templates>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select=" $ref/Handler" mode="handlerProperty">
									<xsl:with-param name="ref" select=" $ref/Handler"/>
								</xsl:apply-templates>
							</xsl:otherwise>
						</xsl:choose>
					</nemo:Handler>
				</xsl:when>
				<xsl:when test="Handler">
					<nemo:Handler>
						<xsl:apply-templates select="./Handler" mode="handlerProperty">
							<xsl:with-param name="ref" select=" ./Handler"/>
						</xsl:apply-templates>
					</nemo:Handler>
				</xsl:when>
			</xsl:choose>
			<xsl:variable name="metricGroup">
				<xsl:choose>
					<xsl:when test="$ref/@refID and $ref/MetricGroup">
						<xsl:value-of select="$ref/MetricGroup"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="./MetricGroup"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="$metricGroup != ''">
				<nemo:MetricGroup>
					<xsl:value-of select="$metricGroup"/>
				</nemo:MetricGroup>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="$ref/@refID and $ref/Capability">
					<xsl:apply-templates select="$ref/Capability" mode="metricProperty"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="./Capability" mode="metricProperty"/>
				</xsl:otherwise>
			</xsl:choose>
		</nemo:Property>
	</xsl:template>
	<xsl:template match="action" mode="actionGeneration" priority="2">
	<!--
	<action>
		<Name>Start</Name>
		<Tooltip/>
		<Icon/>
		<access>
			<condition>
				<properties>
					<property>
						<name>permissions</name>
						<values>read execute</values>
					</property>
					<property>
						<name>startAsActive</name>
						<values>false</values>
					</property>
				</properties>
			</condition>
			<condition/>
			..
		</access>
		<request type="bus">
			<bus:stopService xmlns:bus="TODO">
				<service>%STOREID%</service>
				<immediately>true</immediately>
			</bus:stopService>
		</request>
		<Handler>
			<ClassName>com.cognos.admin.resource.v1_0.BusActionsHandler</ClassName>
		</Handler>
		<Capability>http://cognos.com/admin/supportedactions/baseaction</Capability>
	</action>
	-->
		<xsl:variable name="actionClass" select="."/>
		<xsl:variable name="actionName" select="Name"/>
		<xsl:variable name="actionIcon" select="Icon"/>
		<xsl:variable name="confirm" select="Confirm"/>
		<xsl:variable name="group" select="Group"/>
		<xsl:variable name="actionContext" select="Context"/>
		<!-- 
				make sure we only put the properties we want to expose. Currently using metadata, but this should be
				pushed down into the object model 
			-->
		<xsl:variable name="upperName" select="translate($actionName, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
		<nemo:Action>
			<xsl:if test="RequiredComponents">
				<nemo:RequiredComponents>
					<xsl:value-of select="RequiredComponents"/>
				</nemo:RequiredComponents>
			</xsl:if>
			<nemo:Name>
				<xsl:value-of select="$actionName"/>
			</nemo:Name>
			<nemo:Caption>
				<xsl:value-of select="concat('IDS_PROP_',$upperName,'_CAPTION')"/>
			</nemo:Caption>
			<xsl:for-each select="$actionContext">
				<xsl:variable name="actionCaption" select="Caption"/>
				<xsl:variable name="upperCaption" select="translate($actionCaption, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
				<nemo:Context>
					<xsl:copy-of select="./@*"/>
					<xsl:if test="Caption">
						<nemo:Caption>
							<xsl:value-of select="concat('IDS_PROP_',$upperCaption,'_CAPTION')"/>
						</nemo:Caption>
					</xsl:if>
					<xsl:if test="QueryRelationshipsByType">
						<nemo:QueryRelationshipsByType>
							<xsl:value-of select="QueryRelationshipsByType"/>
						</nemo:QueryRelationshipsByType>
					</xsl:if>
					<xsl:if test="Target">
						<nemo:Target>
							<xsl:value-of select="Target"/>
						</nemo:Target>
					</xsl:if>
				</nemo:Context>
			</xsl:for-each>
			<xsl:if test="$actionIcon != ''">
				<nemo:Icon>
					<xsl:value-of select="Icon"/>
				</nemo:Icon>
			</xsl:if>
			<nemo:Tooltip>
				<xsl:value-of select="concat('IDS_PROP_',$upperName,'_TOOLTIP')"/>
			</nemo:Tooltip>
			<xsl:if test="$confirm">
				<nemo:Confirm>
					<xsl:if test="$confirm/Caption">
						<nemo:Caption>
							<xsl:value-of select="$confirm/Caption"/>
						</nemo:Caption>
					</xsl:if>
				</nemo:Confirm>
			</xsl:if>
			<xsl:if test="$group">
				<nemo:Group><xsl:value-of select="Group"/></nemo:Group>
			</xsl:if>
			<xsl:if test="OnSuccessCaption">
				<nemo:OnSuccessCaption>
					<xsl:value-of select="OnSuccessCaption"/>
				</nemo:OnSuccessCaption>
			</xsl:if>
			<xsl:if test="Arguments">
				<xsl:apply-templates select="./Arguments" mode="copyArguments"/>
			</xsl:if>
			<xsl:if test="request">
				<nemo:Request>
					<xsl:copy-of select="./request/@*"/>
					<xsl:apply-templates select="./request/soapAction" mode="copyRequestSoap"/>
					<xsl:apply-templates select="./request/target" mode="copyRequestTarget"/>
					<xsl:apply-templates select="./request/template" mode="copyRequestTemplate"/>
					<xsl:apply-templates select="./request/ObjectName" mode="copyObjectName"/>
					<xsl:apply-templates select="./request/Operation" mode="copyOperation"/>
					<xsl:apply-templates select="./request/Arguments" mode="copyArguments"/>
				</nemo:Request>
			</xsl:if>
			<xsl:if test="access">
				<nemo:Access>
					<xsl:copy-of select="./access/*"/>
				</nemo:Access>
			</xsl:if>
			<xsl:if test="Handler">
				<nemo:Handler>
					<xsl:apply-templates select="./Handler" mode="handlerProperty"/>
				</nemo:Handler>
			</xsl:if>
			<xsl:apply-templates select="./Capability" mode="metricProperty"/>
		</nemo:Action>
	</xsl:template>
	<xsl:template match="Capability" mode="metricProperty">
		<xsl:variable name="name" select="."/>
		<nemo:Capability>
			<xsl:value-of select="$name"/>
		</nemo:Capability>
	</xsl:template>
	<xsl:template match="Handler" mode="handlerProperty">
		<xsl:param name="ref" select="."/>
		<xsl:choose>
			<xsl:when test="$ref/ClassName">
				<nemo:ClassName>
					<xsl:value-of select="$ref/ClassName"/>
				</nemo:ClassName>
			</xsl:when>
			<xsl:when test="ClassName">
				<nemo:ClassName>
					<xsl:value-of select="./ClassName"/>
				</nemo:ClassName>
			</xsl:when>
		</xsl:choose>
		<xsl:variable name="objname">
			<xsl:choose>
				<xsl:when test="$ref/ObjectName">
					<xsl:value-of select="$ref/ObjectName"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./ObjectName"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$objname != ''">
			<nemo:ObjectName>
				<xsl:value-of select="$objname"/>
			</nemo:ObjectName>
		</xsl:if>
		<xsl:variable name="value">
			<xsl:choose>
				<xsl:when test="$ref/Value">
					<xsl:value-of select="$ref/Value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./Value"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$value != ''">
			<nemo:Value>
				<xsl:value-of select="$value"/>
			</nemo:Value>
			<xsl:choose>
				<xsl:when test="$ref/Attribute">
					<xsl:apply-templates select="$ref/Attribute" mode="mBeanAttribute"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="./Attribute" mode="mBeanAttribute"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="Enumeration" mode="copyEnumeration">
		<xsl:apply-templates select="./enum" mode="copyEnum"/>
	</xsl:template>
	<xsl:template match="soapAction" mode="copyRequestSoap">
		<nemo:SoapAction>
			<xsl:value-of select="."/>
		</nemo:SoapAction>
	</xsl:template>
	<xsl:template match="target" mode="copyRequestTarget">
		<nemo:Target>
			<xsl:value-of select="."/>
		</nemo:Target>
	</xsl:template>
	<xsl:template match="enum" mode="copyEnum">
		<nemo:Enum>
			<xsl:copy-of select="@*"/>
			<xsl:if test="Caption">
				<nemo:Caption>
					<xsl:copy-of select="./Caption/@*"/>
					<xsl:value-of select="Caption"/>
				</nemo:Caption>
			</xsl:if>
		</nemo:Enum>
	</xsl:template>
	<xsl:template match="template" mode="copyRequestTemplate">
		<nemo:Template>
			<xsl:apply-templates select="./*" mode="copyRequestBody"/>
		</nemo:Template>
	</xsl:template>
	<xsl:template match="ObjectName" mode="copyObjectName">
		<nemo:ObjectName>
			<xsl:value-of select="."/>
		</nemo:ObjectName>
	</xsl:template>
	<xsl:template match="Operation" mode="copyOperation">
		<nemo:Operation>
			<xsl:value-of select="."/>
		</nemo:Operation>
	</xsl:template>
	<xsl:template match="Arguments" mode="copyArguments">
		<xsl:copy-of select="@*"/>
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="Attribute" mode="mBeanAttribute">
		<nemo:Attribute>
			<xsl:copy-of select="@*"/>
		</nemo:Attribute>
	</xsl:template>
	<xsl:template match="Value" mode="mValueElement">
		<nemo:Value>
			<xsl:copy-of select="@localize"/>
			<xsl:value-of select="."/>
		</nemo:Value>
	</xsl:template>
	<xsl:template match="*" mode="copyRequestBody" priority="4">
		<xsl:copy-of select="."/>
	</xsl:template>
</xsl:stylesheet>
