<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cogadmin

    (C) Copyright IBM Corp. 2005, 2010

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->

<!--
   Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
   Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<!-- Notes/Issues :
 	1)  The <wsdl:definitions> doesn't have a name attribute.
	2)  For the <port>'s binding attribute, 'tns:' is missing'.  But when I add it, the transform fails.
	3)  For the <binding>'s type attribute, 'tns:' is missing.  But when I add it, the transform fails.
	4)  What should be the resource-prop namespace? 
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:wsrp="http://docs.oasis-open.org/wsrf/rp-2" xmlns:wsrpw="http://docs.oasis-open.org/wsrf/rpw-2" xmlns:muws-p2-wsdl="http://docs.oasis-open.org/wsdm/2004/12/muws/wsdm-muws-part2.wsdl" xmlns:resource-prop="http://developer.cognos.com/admin/properties" xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/" xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/" xmlns:nemo="http://developer.cognos.com/nemo">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:key name="metricGroups" match="//property[MetricGroup!='']" use="MetricGroup"/>
	<xsl:key name="metricTypes" match="//property[MetricGroup!='']" use="Type"/>
	<xsl:variable name="uniqueMetricTypes" select="/cogadmin/property[generate-id(.)=generate-id(key('metricTypes',Type))]/Type"/>
	<xsl:variable name="uniqueRootMetricTypes" select="/root/cogadmin/property[generate-id(.)=generate-id(key('metricTypes',Type))]/Type"/>
	<xsl:param name="gClass"/>
	<xsl:param name="targetNS"/>
	<xsl:param name="servletURI"/>
	<xsl:variable name="currentClass">
		<xsl:choose>
			<xsl:when test="$gClass != ''">
				<xsl:value-of select="$gClass"/>
			</xsl:when>
			<xsl:when test="/root/currentClass!=''">
				<xsl:value-of select="/root/currentClass"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'dispatcher'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="targetNamespace">
		<xsl:choose>
			<xsl:when test="$targetNS != ''">
				<xsl:value-of select="$targetNS"/>
			</xsl:when>
			<xsl:when test="/root/targetNamespace!=''">
				<xsl:value-of select="/root/targetNamespace"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'##resourceEndPointNamespace##'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="requestURI">
		<xsl:choose>
			<xsl:when test="$servletURI != ''">
				<xsl:value-of select="$servletURI"/>
			</xsl:when>
			<xsl:when test="/root/requestURI!=''">
				<xsl:value-of select="/root/requestURI"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'##servletURI##'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!-- namespaces -->
	<xsl:variable name="schemaNS" select="'http://www.w3.org/2001/XMLSchema'"/>
	<xsl:variable name="wsdlNS" select="'http://schemas.xmlsoap.org/wsdl/'"/>
	<xsl:variable name="cogPropSchemaNS" select="'http://developer.cognos.com/schemas/OM/props'"/>
	<xsl:variable name="resourcePropPrefix" select="'resource-prop'"/>
	<xsl:template match="/root" priority="4">
		<xsl:apply-templates select="*[local-name()='cogadmin']"/>
	</xsl:template>
	<!-- 
	******************************************************
		entry point  
	******************************************************
	-->
	<xsl:template match="cogadmin" priority="3">
		<!-- 
			xsl:element doesn't put the namespace definitions (i.e. xs, wsrp, ...) so don't use xsl:element for the
			root element so all the namespaces get defined
		-->
		<wsdl:definitions targetNamespace="{$targetNamespace}">
			<wsdl:import namespace="http://docs.oasis-open.org/wsrf/rpw-2" location="http://docs.oasis-open.org/wsrf/rpw-2"/>
			<wsdl:import namespace="http://docs.oasis-open.org/wsdm/muws2-2.wsdl" location="http://docs.oasis-open.org/wsdm/muws2-2.wsdl"/>
			<!-- schema definition -->
			<wsdl:types>
				<xs:schema targetNamespace="{$targetNamespace}" elementFormDefault="qualified" attributeFormDefault="unqualified">
					<xs:import namespace="http://docs.oasis-open.org/wsrf/bf-2" schemaLocation="http://docs.oasis-open.org/wsrf/bf-2"/>
					<xs:import namespace="http://docs.oasis-open.org/wsdm/muws1-2.xsd" schemaLocation="http://docs.oasis-open.org/wsdm/muws1-2.xsd"/>
					<xs:import namespace="http://ws.apache.org/namespaces/muse/muws-ext-1.xsd" schemaLocation="http://ws.apache.org/namespaces/muse/muws-ext-1.xsd"/>
					<xs:import namespace="http://developer.cognos.com/nemo" schemaLocation="mdd.xsd"/>

					<!-- Define metric types-->
					<xsl:for-each select="$uniqueMetricTypes | $uniqueRootMetricTypes">
						<xsl:variable name="type">
							<xsl:value-of select="."/>
						</xsl:variable>
						<xsl:if test="starts-with($type,'xs:')">
							<!-- Schema types: generate a metric type based on it. -->
							<xs:complexType name="{concat(substring-after($type, 'xs:'), 'MetricType')}">
								<xs:simpleContent>
									<xs:extension base="{$type}">
										<xs:attributeGroup ref="muws-p2-xs:MetricAttributes"/>
										<xs:anyAttribute namespace="##other" processContents="lax"/>
									</xs:extension>
								</xs:simpleContent>
							</xs:complexType>
						</xsl:if>
					</xsl:for-each>
					<xs:element name="{concat($currentClass,'Properties')}">
						<xs:complexType>
							<xs:sequence>
								<!-- Static Properties for all resources -->
								<xsl:comment>Properties for all resources</xsl:comment>
								<xs:element ref="muws-p1-xs:ResourceId"/>
								<xs:element ref="muws-p1-xs:ManageabilityCapability" minOccurs="0" maxOccurs="unbounded"/>
								<xs:element ref="muws-p2-xs:Caption" minOccurs="1" maxOccurs="unbounded"/>
								<xs:element ref="muws-p2-xs:Description" minOccurs="1" maxOccurs="unbounded"/>
								<xs:element ref="muws-p2-xs:Version" minOccurs="0"/>
								<xs:element ref="muws-p2-xs:CurrentTime"/>
								<xs:element ref="muws-p2-xs:Relationship" minOccurs="0" maxOccurs="unbounded"/>
								<xs:element ref="nemo:MetadataDescriptor" minOccurs="1" maxOccurs="1"/>
								<!-- TODO: properties from the Object Model >
								<xsl:comment>properties from the Object Model</xsl:comment>
								<xsl:comment>Need to handle collections</xsl:comment>
								<xsl:apply-templates select="./classes/class[name=string($currentClass)]" mode="configSchemaGeneration"/-->
								<!-- Metrics  -->
								<xsl:comment>Metrics</xsl:comment>
								<xsl:apply-templates select="./class[@name=string($currentClass)]" mode="schemaGeneration"/>
							</xs:sequence>
						</xs:complexType>
					</xs:element>
				</xs:schema>
			</wsdl:types>
			<!--
				portType
			-->
			<wsdl:portType name="{concat($currentClass,'PortType')}" wsrp:ResourceProperties="{concat($currentClass,'Properties')}">
				<!--			
				<wsdl:operation name="GetResourceProperty">
					<wsdl:input name="GetResourcePropertyRequest" message="wsrpw:GetResourcePropertyRequest"/>
					<wsdl:output name="GetResourcePropertyResponse" message="wsrpw:GetResourcePropertyResponse"/>
					<wsdl:fault name="ResourceUnknownFault" message="wsrpw:ResourceUnknownFault"/>
					<wsdl:fault name="InvalidResourcePropertyQNameFault" message="wsrpw:InvalidResourcePropertyQNameFault"/>
				</wsdl:operation>
-->
				<!--
				<operation name="GetMultipleResourceProperties">
					<input name="GetMultipleResourcePropertiesRequest" message="wsrpw:GetMultipleResourcePropertiesRequest"/>
					<output name="GetMultipleResourcePropertiesResponse" message="wsrpw:GetMultipleResourcePropertiesResponse"/>
					<fault name="ResourceUnknownFault" message="wsrpw:ResourceUnknownFault"/>
					<fault name="InvalidResourcePropertyQNameFault" message="wsrpw:InvalidResourcePropertyQNameFault"/>
				</operation>
-->
				<!--				
				<operation name="SetResourceProperties">
					<input name="SetResourcePropertiesRequest" message="wsrpw:SetResourcePropertiesRequest"/>
					<output name="SetResourcePropertiesResponse" message="wsrpw:SetResourcePropertiesResponse"/>
					<fault name="ResourceUnknownFault" message="wsrpw:ResourceUnknownFault"/>
					<fault name="InvalidResourcePropertyQNameFault" message="wsrpw:InvalidResourcePropertyQNameFault"/>
					<fault name="InvalidSetResourcePropertiesRequestContentFault" message="wsrpw:InvalidSetResourcePropertiesRequestContentFault"/>
					<fault name="UnableToModifyResourcePropertyFault" message="wsrpw:UnableToModifyResourcePropertyFault"/>
					<fault name="SetResourcePropertyRequestFailedFault" message="wsrpw:SetResourcePropertyRequestFailedFault"/>
				</operation>
-->
				<!--				
				<operation name="QueryResourceProperties">
					<input name="QueryResourcePropertiesRequest" message="wsrpw:QueryResourcePropertiesRequest"/>
					<output name="QueryResourcePropertiesResponse" message="wsrpw:QueryResourcePropertiesResponse"/>
					<fault name="ResourceUnknownFault" message="wsrpw:ResourceUnknownFault"/>
					<fault name="InvalidResourcePropertyQNameFault" message="wsrpw:InvalidResourcePropertyQNameFault"/>
					<fault name="UnknownQueryExpressionDialectFault" message="wsrpw:UnknownQueryExpressionDialectFault"/>
					<fault name="InvalidQueryExpressionFault" message="wsrpw:InvalidQueryExpressionFault"/>
					<fault name="QueryEvaluationErrorFault" message="wsrpw:QueryEvaluationErrorFault"/>
				</operation>
-->
				<!--				
				<operation name="QueryRelationshipsByType">
					<input message="muws-p2-wsdl:QueryRelationshipsByTypeRequest"/>
					<output message="muws-p2-wsdl:QueryRelationshipsByTypeResponse"/>         
				</operation>
-->
			</wsdl:portType>
			<!--
				binding
			-->
			<wsdl:binding name="{concat($currentClass,'SoapHttpBinding')}" type="{concat($currentClass,'PortType')}">
				<soap:binding style="document" transport="http://schemas.xmlsoap.org/soap/http"/>
				<!--				
				<wsdl:operation name="GetResourceProperty">
					<soap:operation style="document"/>
					<wsdl:input>
					   <soap:body use="literal"/>
					</wsdl:input>
					<wsdl:output>
					   <soap:body use="literal"/>
					</wsdl:output>
					<wsdl:fault name="ResourceUnknownFault">
					   <soap:fault name="ResourceUnknownFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="InvalidResourcePropertyQNameFault">
					   <soap:fault name="InvalidResourcePropertyQNameFault" use="literal"/>
					</wsdl:fault>
				</wsdl:operation>
-->
				<!--				
				<wsdl:operation name="GetMultipleResourceProperties">
					<soap:operation style="document"/>
					<wsdl:input>
					   <soap:body use="literal"/>
					</wsdl:input>
					<wsdl:output>
					   <soap:body use="literal"/>
					</wsdl:output>
					<wsdl:fault name="ResourceUnknownFault">
					   <soap:fault name="ResourceUnknownFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="InvalidResourcePropertyQNameFault">
					   <soap:fault name="InvalidResourcePropertyQNameFault" use="literal"/>
					</wsdl:fault>
				</wsdl:operation>
-->
				<!--				
				<wsdl:operation name="SetResourceProperties">
					<soap:operation style="document"/>
					<wsdl:input>
					   <soap:body use="literal"/>
					</wsdl:input>
					<wsdl:output>
					   <soap:body use="literal"/>
					</wsdl:output>
					<wsdl:fault name="ResourceUnknownFault">
					   <soap:fault name="ResourceUnknownFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="InvalidResourcePropertyQNameFault">
					   <soap:fault name="InvalidResourcePropertyQNameFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="UnableToModifyResourcePropertyFault">
					   <soap:fault name="UnableToModifyResourcePropertyFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="InvalidSetResourcePropertiesRequestContentFault">
					   <soap:fault name="InvalidSetResourcePropertiesRequestContentFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="SetResourcePropertyRequestFailedFault">
					   <soap:fault name="SetResourcePropertyRequestFailedFault" use="literal"/>
					</wsdl:fault>
				</wsdl:operation>
-->
				<!--				
				<wsdl:operation name="QueryResourceProperties">
					<soap:operation style="document"/>
					<wsdl:input>
					   <soap:body use="literal"/>
					</wsdl:input>
					<wsdl:output>
					   <soap:body use="literal"/>
					</wsdl:output>
					<wsdl:fault name="ResourceUnknownFault">
					   <soap:fault name="ResourceUnknownFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="InvalidResourcePropertyQNameFault">
					   <soap:fault name="InvalidResourcePropertyQNameFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="UnknownQueryExpressionDialectFault">
					   <soap:fault name="UnknownQueryExpressionDialectFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="InvalidQueryExpressionFault">
					   <soap:fault name="InvalidQueryExpressionFault" use="literal"/>
					</wsdl:fault>
					<wsdl:fault name="QueryEvaluationErrorFault">
					   <soap:fault name="QueryEvaluationErrorFault" use="literal"/>
					</wsdl:fault>
				</wsdl:operation>
-->
				<!--				
				<wsdl:operation name="QueryRelationshipsByType">
					<soap:operation style="document"/>
					<wsdl:input>
					   <soap:body use="literal"/>
					</wsdl:input>
					<wsdl:output>
					   <soap:body use="literal"/>
					</wsdl:output>
				</wsdl:operation> 
-->
			</wsdl:binding>
			<service name="{concat($currentClass,'Service')}">
				<port name="{$currentClass}" binding="{concat($currentClass,'SoapHttpBinding')}">
					<soap:address location="{$requestURI}"/>
				</port>
			</service>
		</wsdl:definitions>
	</xsl:template>
	<!-- 
	******************************************************
		Metric properties
	******************************************************
	-->
	<xsl:template match="class" mode="schemaGeneration">
		<!-- make sure we get all the derived classes -->
		<xsl:for-each select="derivedFrom">
			<xsl:variable name="class" select="."/>
			<xsl:apply-templates select="../class[name=string($class)]" mode="schemaGeneration"/>
		</xsl:for-each>
		<xsl:apply-templates select="MetricGroup" mode="metric"/>
		<!-- TODO Match any metrics that are not in metric group
		<xsl:apply-templates select="Metric" mode="metric"/>
		-->
	</xsl:template>
	<xsl:template match="MetricGroup" mode="metric">
		<xsl:variable name="groupName" select="."/>
		<xsl:apply-templates select="key('metricGroups', $groupName)" mode="metric"/>
	</xsl:template>
	<xsl:template match="property" mode="metric">
		<xs:element name="{concat($resourcePropPrefix,':',Name)}">
			<xsl:choose>
				<!-- Schema types: generate a metric type based on it. -->
				<xsl:when test="starts-with(Type,'xs:')">
						<xsl:attribute name="type"><xsl:value-of select="concat(substring-after(Type, 'xs:'), 'MetricType')"/></xsl:attribute>
				</xsl:when>
				<!-- Other types -->
				<xsl:otherwise>
					<xsl:attribute name="type"><xsl:value-of select="Type"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</xs:element>
	</xsl:template>
</xsl:stylesheet>
