/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.admin.common.NameSpace;
import com.cognos.admin.datasources.DataSource;
import com.cognos.admin.datasources.DataSourcePackage;
import com.cognos.admin.datasources.DataSourceUtil;
import com.cognos.admin.datasources.Error;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IJ2HTMLXmlProcessor;
import com.cognos.admin.portal.common.NavRequestBuilder;
import com.ibm.cognos.cogadmin.common.SearchPathUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class BuildNavRequest
extends NavRequestBuilder
implements IJ2HTMLXmlProcessor {
    public static final String NAV_REQUEST_WRITER_NAME = "navRequest";
    public static final String NAV_REQUEST_FLAG_WRITER_NAME = "navRequestFlag";
    static final String DATA_SOURCE_PERMISSIONS = "[permission(\"read\") or permission(\"write\") or permission(\"execute\") or permission(\"traverse\") or permission(\"setPolicy\")]";
    private XMLStreamReader dataSourceReader = null;
    private XMLStreamWriter navRequestWriter = null;
    private XMLStreamWriter navRequestFlagWriter = null;
    private XMLStreamWriter dataSourceWriter = null;
    private DataSourcePackage dataSourcePackage = null;
    private IContext context = null;

    public void writeToXMLWriterStream(IContext context, Map<String, XMLStreamReader> readers, Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.setContext(context);
        this.setDataSourceReader(readers);
        this.setNavRequestFlagWriter(writers);
        this.setDataSourceWriter(writers);
        this.readDataSources();
        if (BuildNavRequest.isNavRequestToBeSent(this.dataSourcePackage)) {
            this.setNavRequestWriter(writers);
            this.writeSoapEnvelope(this.navRequestWriter);
            this.writeNavRequestFlag(this.navRequestFlagWriter);
        } else {
            this.writeNoNavRequestFlag(this.navRequestFlagWriter);
        }
        this.writeDataSources();
    }

    String generateDataSourcePath(String dataSourceName) {
        return "//*[@objectClass='dataSource' or @objectClass='rolapDataSource' or @objectClass='rolapVirtualDataSource']" + SearchPathUtils.buildNameCritera((String)dataSourceName) + DATA_SOURCE_PERMISSIONS;
    }

    private void setContext(IContext context) throws J2HTMLException {
        this.checkContext(context);
        this.context = context;
    }

    @Override
    protected IContext getContext() {
        return this.context;
    }

    private void setDataSourceReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        this.dataSourceReader = this.findReader(readers, "packageDataSources");
        if (this.dataSourceReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_READER.getMsg());
        }
    }

    private void setNavRequestWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.navRequestWriter = this.findWriters(writers, NAV_REQUEST_WRITER_NAME);
        if (this.navRequestWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_NAV_REQUEST_WRITER.getMsg());
        }
    }

    private void setNavRequestFlagWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.navRequestFlagWriter = this.findWriters(writers, NAV_REQUEST_FLAG_WRITER_NAME);
        if (this.navRequestFlagWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_NAV_REQUEST_FLAG_WRITER.getMsg());
        }
    }

    private void setDataSourceWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.dataSourceWriter = this.findWriters(writers, "packageDataSources");
        if (this.dataSourceWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_WRITER.getMsg());
        }
    }

    private void readDataSources() throws J2HTMLException {
        List<DataSourcePackage> list = null;
        try {
            list = DataSourcePackage.fromXmlStreamReader(this.dataSourceReader);
            if (list == null || list.isEmpty()) {
                throw new J2HTMLException(Error.NO_PACKAGE.getMsg());
            }
            this.dataSourcePackage = list.get(0);
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.READING_DATA_SOURCES.getMsg());
        }
    }

    private void writeDataSources() throws J2HTMLException {
        try {
            this.dataSourceWriter.writeStartElement("packageDataSources");
            this.dataSourcePackage.toXmlStreamWriter(this.dataSourceWriter);
            this.dataSourceWriter.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.WRITING_DATA_SOURCES.getMsg());
        }
    }

    @Override
    protected void writeNavRequestQueries(XMLStreamWriter writer) throws J2HTMLException, XMLStreamException {
        writer.writeStartElement(NameSpace.NAV.getUri(), "queries");
        if (this.dataSourcePackage.getDataSources() != null) {
            for (DataSource dataSource : this.dataSourcePackage.getDataSources()) {
                if (!dataSource.isRegular()) continue;
                this.writeGetItemQuery(writer, this.generateDataSourcePath(dataSource.getName() == null ? "" : dataSource.getName()));
            }
        }
        writer.writeEndElement();
    }

    static boolean isNavRequestToBeSent(DataSourcePackage dataSourcePackage) {
        boolean isToBeSent = false;
        Iterator<DataSource> iterator = null;
        if (DataSourceUtil.canPackageBeProcessed(dataSourcePackage) && DataSourceUtil.doesPackageContaindataSources(dataSourcePackage)) {
            iterator = dataSourcePackage.getDataSources().iterator();
            while (!isToBeSent && iterator.hasNext()) {
                isToBeSent = iterator.next().isRegular();
            }
        }
        return isToBeSent;
    }
}

