/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.admin.datasources.DataSourceComponentFactory;
import com.cognos.admin.datasources.DataSourcePackage;
import com.cognos.admin.datasources.DataSourceUtil;
import com.cognos.admin.datasources.Error;
import com.cognos.admin.datasources.MessageComponentFactory;
import com.cognos.admin.j2html.ControlledComponent;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.DefaultControlledComponentFactory;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IControlledComponentFactory;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ComponentFactoryDispatcher
extends DefaultControlledComponentFactory
implements IControlledComponentFactory {
    private XMLStreamReader dataSourceReader = null;
    private DataSourcePackage dataSourcePackage = null;

    public ControlledComponent createControlledComponent(IContext context, Map<String, XMLStreamReader> readers) throws J2HTMLException {
        ControlledComponent component = null;
        DefaultControlledComponentFactory actualComponentFactory = null;
        this.setDataSourceReader(readers);
        this.readDataSourcePackage();
        actualComponentFactory = DataSourceUtil.canPackageBeProcessed(this.dataSourcePackage) ? new DataSourceComponentFactory(this.dataSourcePackage) : new MessageComponentFactory("IDS_ADM_OBJECT_INVALID", null);
        component = actualComponentFactory.createControlledComponent(context, readers);
        return component;
    }

    private void setDataSourceReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        if (readers != null) {
            this.dataSourceReader = readers.get("packageDataSources");
        }
        if (this.dataSourceReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_READER.getMsg());
        }
    }

    private void readDataSourcePackage() throws J2HTMLException {
        List<DataSourcePackage> list = null;
        try {
            list = DataSourcePackage.fromXmlStreamReader(this.dataSourceReader);
            if (list == null || list.isEmpty() || list.get(0) == null) {
                throw new J2HTMLException(Error.NO_PACKAGE.getMsg());
            }
            this.dataSourcePackage = list.get(0);
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.READING_DATA_SOURCES.getMsg());
        }
    }
}

