/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.admin.datasources.Error;
import com.cognos.admin.portal.common.NavResponseItem;
import com.cognos.portal.xml.stream.PathIterator;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DataSource {
    private String name = null;
    private String iconUrl = null;
    private String iconToolTip = null;
    private String type = null;
    private String sourcePath = null;
    private boolean directAccess = false;
    private boolean hidden = false;
    public static final String REGULAR_TYPE = "regular";

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    String getIconUrl() {
        return this.iconUrl;
    }

    void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    String getIconToolTip() {
        return this.iconToolTip;
    }

    void setIconToolTip(String iconToolTip) {
        this.iconToolTip = iconToolTip;
    }

    boolean isHidden() {
        return this.hidden;
    }

    void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    String getSourcePath() {
        return this.sourcePath;
    }

    void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    boolean isDirectAccess() {
        return this.directAccess;
    }

    void setDirectAccess(boolean directAccess) {
        this.directAccess = directAccess;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        DataSource dataSource = null;
        if (object instanceof DataSource) {
            dataSource = (DataSource)object;
            boolean bl = isEqual = this.getName() == null && dataSource.getName() == null || this.getName().equals(dataSource.getName());
            if (isEqual) {
                boolean bl2 = isEqual = this.getIconUrl() == null && dataSource.getIconUrl() == null || this.getIconUrl().equals(dataSource.getIconUrl());
            }
            if (isEqual) {
                isEqual = this.getIconToolTip() == null && dataSource.getIconToolTip() == null || this.getIconToolTip().equals(dataSource.getIconToolTip());
            }
        }
        return isEqual;
    }

    public void toXmlStreamWriter(XMLStreamWriter writer) throws XMLStreamException {
        if (!this.isXmlWriterDefined(writer)) {
            throw new IllegalArgumentException(Error.UNDEFINED_XML_WRITER.getMsg());
        }
        writer.writeStartElement("dataSource");
        if (this.isNameDefined()) {
            writer.writeStartElement("name");
            writer.writeCharacters(this.getName());
            writer.writeEndElement();
        }
        if (this.isIconUrlDefined()) {
            writer.writeStartElement("iconUrl");
            writer.writeCharacters(this.getIconUrl());
            writer.writeEndElement();
        }
        if (this.isIconToolTipDefined()) {
            writer.writeStartElement("iconToolTip");
            writer.writeCharacters(this.getIconToolTip());
            writer.writeEndElement();
        }
        if (this.isTypeDefined()) {
            writer.writeStartElement("type");
            writer.writeCharacters(this.getType());
            writer.writeEndElement();
        }
        if (this.isSourcePathDefined()) {
            writer.writeStartElement("sourcePath");
            writer.writeCharacters(this.getSourcePath());
            writer.writeEndElement();
        }
        writer.writeStartElement("hidden");
        writer.writeCharacters(String.valueOf(this.isHidden()));
        writer.writeEndElement();
        writer.writeStartElement("directAccess");
        writer.writeCharacters(String.valueOf(this.isDirectAccess()));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public boolean isNameDefined() {
        return this.name != null;
    }

    public boolean isIconUrlDefined() {
        return this.iconUrl != null;
    }

    public boolean isIconToolTipDefined() {
        return this.iconToolTip != null;
    }

    public boolean isTypeDefined() {
        return this.type != null;
    }

    public boolean isSourcePathDefined() {
        return this.sourcePath != null;
    }

    public boolean isRegular() {
        return REGULAR_TYPE.equals(this.getType());
    }

    private boolean isXmlWriterDefined(XMLStreamWriter writer) {
        return writer != null;
    }

    private static boolean isXmlReaderDefined(XMLStreamReader reader) {
        return reader != null;
    }

    static DataSource fromNavReponseItem(NavResponseItem navResponseItem) {
        DataSource dataSource = null;
        if (navResponseItem == null) {
            throw new IllegalArgumentException(Error.UNDEFINED_NAVRESPONSE_ITEM.getMsg());
        }
        dataSource = new DataSource();
        dataSource.setName(navResponseItem.getName());
        dataSource.setIconUrl(navResponseItem.getIconUrl());
        dataSource.setIconToolTip(navResponseItem.getToolTip());
        dataSource.setHidden(navResponseItem.isHidden());
        return dataSource;
    }

    static List<DataSource> fromXmlStreamReader(XMLStreamReader reader) throws XMLStreamException {
        PathIterator pathIterator = null;
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        int index = -1;
        DataSource dataSource = null;
        String baseXpath = "/dataSources/dataSource";
        if (!DataSource.isXmlReaderDefined(reader)) {
            throw new IllegalArgumentException(Error.UNDEFINED_XML_READER.getMsg());
        }
        pathIterator = new PathIterator(reader, new String[]{baseXpath, baseXpath + "/" + "name", baseXpath + "/" + "iconUrl", baseXpath + "/" + "iconToolTip", baseXpath + "/" + "hidden", baseXpath + "/" + "type", baseXpath + "/" + "sourcePath", baseXpath + "/" + "directAccess"});
        block10: while ((index = pathIterator.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    if (dataSource != null) {
                        dataSources.add(dataSource);
                    }
                    dataSource = new DataSource();
                    continue block10;
                }
                case 1: {
                    dataSource.setName(pathIterator.getElementText());
                    continue block10;
                }
                case 2: {
                    dataSource.setIconUrl(pathIterator.getElementText());
                    continue block10;
                }
                case 3: {
                    dataSource.setIconToolTip(pathIterator.getElementText());
                    continue block10;
                }
                case 4: {
                    dataSource.setHidden(Boolean.valueOf(pathIterator.getElementText()));
                    continue block10;
                }
                case 5: {
                    dataSource.setType(pathIterator.getElementText());
                    continue block10;
                }
                case 6: {
                    dataSource.setSourcePath(pathIterator.getElementText());
                    continue block10;
                }
                case 7: {
                    dataSource.setDirectAccess(Boolean.valueOf(pathIterator.getElementText()));
                    continue block10;
                }
            }
        }
        if (dataSource != null) {
            dataSources.add(dataSource);
        }
        return dataSources;
    }
}

