/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.admin.datasources.DataSource;
import com.cognos.admin.datasources.DataSourcePackage;
import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.ControlledComponent;
import com.cognos.admin.j2html.DefaultTableCellRenderer;
import com.cognos.admin.j2html.DefaultTableLayoutHandler;
import com.cognos.admin.j2html.ITableLayoutHandler;
import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.MainContentLink;
import com.cognos.admin.j2html.SectionPane;
import com.cognos.admin.j2html.Table;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.TableLayoutPane;
import com.cognos.admin.j2html.control.DefaultControlledComponentFactory;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IControlledComponentFactory;
import com.cognos.admin.j2html.table.DefaultTableModel;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.ITableModel;
import com.cognos.admin.j2html.table.ImageTableCellRenderer;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataSourceComponentFactory
extends DefaultControlledComponentFactory
implements IControlledComponentFactory {
    public static final int COL_IDX_ICON = 0;
    public static final int COL_IDX_NAME = 1;
    private DataSourcePackage dataSourcePackage = null;

    public DataSourceComponentFactory(DataSourcePackage dataSourcePackage) {
        this.dataSourcePackage = dataSourcePackage;
    }

    public ControlledComponent createControlledComponent(IContext context, Map<String, XMLStreamReader> readers) throws J2HTMLException {
        return this.createControlledComponent(context);
    }

    ControlledComponent createControlledComponent(IContext context) throws J2HTMLException {
        DataSourceTableModel model = null;
        DataSourceComponent component = null;
        try {
            model = this.createDataSourceModel();
            model.setSummary(context.localize("IDS_PDS_DESC", (Object[])new String[]{this.dataSourcePackage.getName()}));
            component = this.createDataSourceComponent(context, model);
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException("Failed reading the xml input while generating the controlled component for the datasource", (Throwable)xmle);
        }
        return component;
    }

    DataSourceTableModel createDataSourceModel() throws XMLStreamException {
        DataSourceTableModel model = new DataSourceTableModel();
        List<DataSource> dataSources = null;
        model.addColumn("Icon");
        model.addColumn("Name");
        model.setPackageName(this.dataSourcePackage.getName());
        dataSources = this.dataSourcePackage.getDataSources();
        if (dataSources != null && !dataSources.isEmpty()) {
            this.addDataSourcesInModel(dataSources, model);
        }
        return model;
    }

    DataSourceComponent createDataSourceComponent(IContext context, DataSourceTableModel model) {
        DataSourceComponent component = null;
        Table table = null;
        TableLayoutPane tableLayoutPane = null;
        SectionPane mainSection = new SectionPane();
        component = new DataSourceComponent(context);
        table = this.createTable(context, model);
        tableLayoutPane = this.createTableLayoutPane(context, table);
        mainSection.setSeparator(false);
        mainSection.setDescription(context.localize("IDS_PDS_DESC", (Object[])new String[]{this.dataSourcePackage.getName()}));
        mainSection.add((Component)new MainContentLink());
        mainSection.add((Component)tableLayoutPane);
        component.add((Component)mainSection);
        return component;
    }

    private TableLayoutPane createTableLayoutPane(IContext context, Table table) {
        TableLayoutPane tableLayoutPane = null;
        DefaultTableLayoutHandler defaultTableLayoutHandler = null;
        tableLayoutPane = new TableLayoutPane(1, 1);
        defaultTableLayoutHandler = new DefaultTableLayoutHandler();
        defaultTableLayoutHandler.add((Component)table, 0, 0, null);
        defaultTableLayoutHandler.getDefaultConstraint().setPadding("5 0 0 0");
        tableLayoutPane.setTableLayoutHandler((ITableLayoutHandler)defaultTableLayoutHandler);
        return tableLayoutPane;
    }

    private Table createTable(IContext context, DefaultTableModel model) {
        Table table = null;
        table = new Table((ITableModel)model);
        table.createDefaultColumnsFromModel();
        table.setSortable(true);
        table.setSortedColumn(1, true, true);
        this.formatIconColumn(table, context);
        this.formatDataSourceNameColumn(table, context);
        return table;
    }

    private void formatIconColumn(Table table, IContext context) {
        TableColumn iconColumn = null;
        iconColumn = table.getColumn(0);
        iconColumn.setHeaderValue((Object)"");
        iconColumn.setWidth("16px");
        iconColumn.setHeaderRenderer((ITableCellRenderer)new DefaultTableCellRenderer());
        iconColumn.setCellRenderer((ITableCellRenderer)new DataSourceIconCellRenderer());
        iconColumn.setSortable(false, false);
    }

    private void formatDataSourceNameColumn(Table table, IContext context) {
        TableColumn nameColumn = null;
        nameColumn = table.getColumn(1);
        nameColumn.setHeaderValue((Object)context.localize("IDS_HEADING_NAME"));
        nameColumn.setAlign("left");
        nameColumn.setHeaderRenderer((ITableCellRenderer)new DefaultTableCellRenderer());
        nameColumn.setWordWrap(true);
        nameColumn.setSortable(true, false);
    }

    private void addDataSourcesInModel(List<DataSource> dataSources, DataSourceTableModel model) {
        for (DataSource dataSource : dataSources) {
            Object[] newRow = new Object[]{dataSource, dataSource.getName()};
            model.addRow(newRow);
        }
    }

    public class DataSourceIconCellRenderer
    extends ImageTableCellRenderer {
        public DataSourceIconCellRenderer() {
            this.setImage(new Image());
        }

        public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DataSource dataSource = null;
            dataSource = (DataSource)value;
            this.getImage().setPath(dataSource.getIconUrl(), true);
            this.getImage().setToolTip(dataSource.getIconToolTip());
            this.getImage().setDisabled(dataSource.isHidden());
            return this.getImage();
        }
    }

    public class DataSourceComponent
    extends ControlledComponent {
        public DataSourceComponent(IContext context) {
            super(context);
        }

        public int getDepth() {
            return 0;
        }

        public int getNumRow() {
            return 0;
        }

        public String getTargetURI() {
            return null;
        }
    }

    public class DataSourceTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -1527762997980926023L;
        private String packageName = null;

        public String getPackageName() {
            return this.packageName;
        }

        void setPackageName(String packageName) {
            this.packageName = packageName;
        }
    }
}

