/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.admin.datasources.DataSource;
import com.cognos.admin.datasources.Error;
import com.cognos.portal.xml.stream.IsolatedXMLStreamReader;
import com.cognos.portal.xml.stream.PathIterator;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DataSourcePackage {
    private String searchPath = null;
    private String id = null;
    private String name = null;
    private List<DataSource> dataSources = null;

    public String getSearchPath() {
        return this.searchPath;
    }

    void setSearchPath(String searchParh) {
        this.searchPath = searchParh;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void toXmlStreamWriter(XMLStreamWriter writer) throws XMLStreamException {
        if (!this.isXmlWriterDefined(writer)) {
            throw new IllegalArgumentException(Error.UNDEFINED_XML_WRITER.getMsg());
        }
        writer.writeStartElement("package");
        if (this.isSearchPathDefined()) {
            writer.writeStartElement("searchPath");
            writer.writeCharacters(this.getSearchPath());
            writer.writeEndElement();
        }
        if (this.isNameDefined()) {
            writer.writeStartElement("name");
            writer.writeCharacters(this.getName());
            writer.writeEndElement();
        }
        if (this.isIdDefined()) {
            writer.writeStartElement("storeID");
            writer.writeCharacters(this.getId());
            writer.writeEndElement();
        }
        if (this.areDataSourcesDefined()) {
            writer.writeStartElement("dataSources");
            for (DataSource dataSource : this.dataSources) {
                dataSource.toXmlStreamWriter(writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    static List<DataSourcePackage> fromXmlStreamReader(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<DataSourcePackage> list = new ArrayList<DataSourcePackage>();
        PathIterator pathIterator = null;
        int index = -1;
        DataSourcePackage dataSourcePackage = null;
        if (!DataSourcePackage.isXmlReaderDefined(reader)) {
            throw new IllegalArgumentException(Error.UNDEFINED_XML_READER.getMsg());
        }
        pathIterator = new PathIterator(reader, new String[]{"/packageDataSources/package", "/packageDataSources/package/searchPath", "/packageDataSources/package/name", "/packageDataSources/package/storeID", "/packageDataSources/package/dataSources"});
        block7: while ((index = pathIterator.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    if (dataSourcePackage != null) {
                        list.add(dataSourcePackage);
                    }
                    dataSourcePackage = new DataSourcePackage();
                    continue block7;
                }
                case 1: {
                    dataSourcePackage.setSearchPath(pathIterator.getElementText());
                    continue block7;
                }
                case 2: {
                    dataSourcePackage.setName(pathIterator.getElementText());
                    continue block7;
                }
                case 3: {
                    dataSourcePackage.setId(pathIterator.getElementText());
                    continue block7;
                }
                case 4: {
                    dataSourcePackage.setDataSources(DataSource.fromXmlStreamReader((XMLStreamReader)new IsolatedXMLStreamReader((XMLStreamReader)pathIterator)));
                    continue block7;
                }
            }
        }
        if (dataSourcePackage != null) {
            list.add(dataSourcePackage);
        }
        return list;
    }

    private boolean isXmlWriterDefined(XMLStreamWriter writer) {
        return writer != null;
    }

    private boolean isSearchPathDefined() {
        return this.getSearchPath() != null;
    }

    private boolean isNameDefined() {
        return this.getName() != null;
    }

    private boolean isIdDefined() {
        return this.getId() != null;
    }

    private boolean areDataSourcesDefined() {
        return this.dataSources != null;
    }

    private static boolean isXmlReaderDefined(XMLStreamReader reader) {
        return reader != null;
    }
}

