/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.admin.common.NameSpace;
import com.cognos.portal.soap.impl.bus.BusCommand;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GetPackageDataSourcesRequest
extends BusCommand {
    public static final String MS_SOAP_ACTION = NameSpace.MDS.getUri();
    public static final String QUERY_TAG = "queryModelDataSources";
    public static final String INPUT_TAG = "input";
    public static final String SEARCH_PATH_TAG = "cmSearchPath";
    public static final String OUTPUT_TAG = "output";
    public static final String DATA_SOURCE_TAG = "dataSource";
    public static final String SOURCE_TYPE_TAG = "sourceType";
    public static final String SOURCE_PATH_TAG = "sourcePath";
    public static final String DIRECT_ACCESS_TAG = "directAccess";
    public static final String CM_DATA_SOURCE_TAG = "cmDataSource";
    private String packageSearchPath;

    public GetPackageDataSourcesRequest(String packageSearchPath) {
        if (!this.isSearchPathDefined(packageSearchPath)) {
            throw new IllegalArgumentException("Undefined package search path");
        }
        this.packageSearchPath = packageSearchPath;
        this.setSOAPAction(MS_SOAP_ACTION);
    }

    public void writeBody(Writer writer) throws IOException {
        try {
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter((Writer)writer);
            xsw.writeStartElement(QUERY_TAG);
            xsw.writeStartElement(INPUT_TAG);
            xsw.writeStartElement(SEARCH_PATH_TAG);
            xsw.writeCharacters(this.getModelSearchPath());
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }

    String getModelSearchPath() {
        return this.packageSearchPath + "/model[last()]";
    }

    private boolean isSearchPathDefined(String searchPath) {
        return searchPath != null && searchPath.trim().length() > 0;
    }
}

