/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.admin.datasources.BuildNavRequest;
import com.cognos.admin.datasources.DataSource;
import com.cognos.admin.datasources.DataSourcePackage;
import com.cognos.admin.datasources.Error;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IJ2HTMLXmlProcessor;
import com.cognos.admin.portal.common.NavRequestProcessor;
import com.cognos.admin.portal.common.NavResponseItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ParseNavResponse
extends NavRequestProcessor
implements IJ2HTMLXmlProcessor {
    public static final String NAV_RESPONSE_READER = "navResponse";
    public static final String DATA_SOURCE_CAPABILITY = "canUseDataSourcesTool";
    static final String DEFAULT_DATA_SOURCE_ICON = "/ps/portal/images/icon_data_source.gif";
    private XMLStreamReader navResponseReader = null;
    private XMLStreamReader dataSourceReader = null;
    private XMLStreamWriter dataSourceWriter = null;
    private DataSourcePackage rawDataSourcePackage = null;
    private DataSourcePackage dataSourcePackage = null;
    private List<DataSource> dataSources = null;
    private List<String> dataSourceIds = null;
    private IContext context = null;

    public void writeToXMLWriterStream(IContext context, Map<String, XMLStreamReader> readers, Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        List<NavResponseItem> navResponseItems = null;
        this.setContext(context);
        this.setDataSourceReader(readers);
        this.setDataSourceWriter(writers);
        this.readRawDataSources();
        if (BuildNavRequest.isNavRequestToBeSent(this.rawDataSourcePackage)) {
            this.setNavResponseReader(readers);
            navResponseItems = this.parseNavResponse();
        }
        this.registerDataSources(navResponseItems);
        this.writeRegisteredDateSources();
    }

    private void setContext(IContext context) throws J2HTMLException {
        if (context == null) {
            throw new J2HTMLException(Error.UNDEFINED_CONTEXT.getMsg());
        }
        this.context = context;
    }

    private void setNavResponseReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        this.navResponseReader = this.findReader(readers, NAV_RESPONSE_READER);
        if (this.navResponseReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_NAV_RESPONSE_READER.getMsg());
        }
    }

    private void setDataSourceReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        this.dataSourceReader = this.findReader(readers, "packageDataSources");
        if (this.dataSourceReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_READER.getMsg());
        }
    }

    private void setDataSourceWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.dataSourceWriter = this.findWriters(writers, "packageDataSources");
        if (this.dataSourceWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_WRITER.getMsg());
        }
    }

    private void readRawDataSources() throws J2HTMLException {
        List<DataSourcePackage> list = null;
        try {
            list = DataSourcePackage.fromXmlStreamReader(this.dataSourceReader);
            if (list != null && !list.isEmpty()) {
                this.rawDataSourcePackage = list.get(0);
            }
            if (this.rawDataSourcePackage == null) {
                throw new J2HTMLException(Error.NO_PACKAGE.getMsg());
            }
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.READING_DATA_SOURCES.getMsg(), (Throwable)xmle);
        }
    }

    private List<NavResponseItem> parseNavResponse() throws J2HTMLException {
        List<NavResponseItem> list = null;
        try {
            list = NavResponseItem.fromXmlReader(this.navResponseReader, null);
        }
        catch (Exception e) {
            throw new J2HTMLException(Error.PARSING_NAV_RESPONSE.getMsg(), (Throwable)e);
        }
        return list;
    }

    private void writeRegisteredDateSources() throws J2HTMLException {
        try {
            this.dataSourceWriter.writeStartElement("packageDataSources");
            this.dataSourcePackage.toXmlStreamWriter(this.dataSourceWriter);
            this.dataSourceWriter.writeEndElement();
            this.dataSourceWriter.flush();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.WRITING_DATA_SOURCES.getMsg());
        }
    }

    private void initializeDataSourcePackage() {
        this.dataSourcePackage = new DataSourcePackage();
        this.dataSourcePackage.setName(this.rawDataSourcePackage.getName());
        this.dataSourcePackage.setId(this.rawDataSourcePackage.getId());
        this.dataSourcePackage.setSearchPath(this.rawDataSourcePackage.getSearchPath());
    }

    private void registerDataSources(List<NavResponseItem> navResponseItems) throws J2HTMLException {
        int index = 0;
        try {
            this.initializeDataSourcePackage();
            this.dataSources = new ArrayList<DataSource>();
            if (this.rawDataSourcePackage.getDataSources() != null) {
                for (DataSource rawDataSource : this.rawDataSourcePackage.getDataSources()) {
                    if (rawDataSource.isRegular()) {
                        this.registerRegularDataSource(rawDataSource, navResponseItems.get(index));
                        ++index;
                        continue;
                    }
                    this.registerNonRegularDataSource(rawDataSource);
                }
                this.dataSourcePackage.setDataSources(this.dataSources);
            }
            if (navResponseItems != null && index != navResponseItems.size()) {
                throw new J2HTMLException(Error.DATA_INCONSISTENCY.getMsg());
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new J2HTMLException(Error.DATA_INCONSISTENCY.getMsg(), (Throwable)iobe);
        }
    }

    private void registerNonRegularDataSource(DataSource rawDataSource) throws J2HTMLException {
        DataSource dataSource = null;
        String name = null;
        dataSource = new DataSource();
        name = rawDataSource.isDirectAccess() ? this.context.localize("IDS_ADM_EXTERNAL_DIRECT_ACCESS_DATA_SOURCE", (Object[])new String[]{rawDataSource.getSourcePath()}) : this.context.localize("IDS_ADM_EXTERNAL_DATA_SOURCE");
        dataSource.setName(name);
        dataSource.setIconToolTip(name);
        dataSource.setIconUrl(this.context.getEnv().getWebContent() + DEFAULT_DATA_SOURCE_ICON);
        dataSource.setHidden(false);
        this.dataSources.add(dataSource);
    }

    private void registerRegularDataSource(DataSource rawDataSource, NavResponseItem navResponseItem) throws J2HTMLException {
        if (this.doesDataSourceExist(navResponseItem)) {
            if (this.hasReadAccess(navResponseItem)) {
                this.registerExistingRegularDataSourceReadAccess(navResponseItem);
            } else {
                this.registerExistingRegularDataSourceNoReadAccess(navResponseItem);
            }
        } else {
            this.registerNotExistingRegularDataSource(rawDataSource);
        }
    }

    private void registerNotExistingRegularDataSource(DataSource rawDataSource) throws J2HTMLException {
        DataSource dataSource = null;
        String name = null;
        name = this.hasDataSourceCapability() ? this.context.localize("IDS_ADM_DATA_SOURCE_UNAVAILABLE", (Object[])new String[]{rawDataSource.getName()}) : this.context.localize("IDS_ADM_UNAVAILABLE");
        dataSource = new DataSource();
        dataSource.setName(name);
        dataSource.setIconToolTip(name);
        dataSource.setIconUrl(this.context.getEnv().getWebContent() + DEFAULT_DATA_SOURCE_ICON);
        dataSource.setHidden(false);
        this.dataSources.add(dataSource);
    }

    private void registerExistingRegularDataSourceNoReadAccess(NavResponseItem navResponseItem) {
        DataSource dataSource = null;
        String name = null;
        if (!this.isDataSourceRegistered(navResponseItem.getId())) {
            name = this.context.localize("IDS_ADM_UNAVAILABLE");
            dataSource = new DataSource();
            dataSource.setName(name);
            dataSource.setIconToolTip(name);
            dataSource.setIconUrl(this.context.getEnv().getWebContent() + DEFAULT_DATA_SOURCE_ICON);
            dataSource.setHidden(false);
            this.dataSources.add(dataSource);
        }
    }

    private void registerExistingRegularDataSourceReadAccess(NavResponseItem navResponseItem) throws J2HTMLException {
        DataSource dataSource = null;
        if (!this.isDataSourceRegistered(navResponseItem.getId())) {
            this.dataSourceIds.add(navResponseItem.getId());
            dataSource = DataSource.fromNavReponseItem(navResponseItem);
            if (!navResponseItem.isNameDefined()) {
                throw new J2HTMLException(Error.NO_DATA_SOURCE_NAME.getMsg());
            }
            if (!navResponseItem.isIconUrlDefined()) {
                throw new J2HTMLException(Error.NO_DATA_SOURCE_ICON.getMsg());
            }
            if (!navResponseItem.isToolTipDefined()) {
                throw new J2HTMLException(Error.NO_DATA_SOURCE_TOOL_TIP.getMsg());
            }
            this.dataSources.add(dataSource);
        }
    }

    private boolean hasReadAccess(NavResponseItem navResponseItem) {
        return navResponseItem.getPermissions() != null && navResponseItem.getPermissions().getCanRead();
    }

    private boolean hasDataSourceCapability() throws J2HTMLException {
        return this.context.getUserCapabilities().contains(DATA_SOURCE_CAPABILITY);
    }

    private boolean doesDataSourceExist(NavResponseItem navResponseItem) {
        return navResponseItem.getId() != null && navResponseItem.getId().length() > 0;
    }

    private boolean isDataSourceRegistered(String id) {
        boolean isDuplicate = false;
        if (this.dataSourceIds == null) {
            this.dataSourceIds = new ArrayList<String>();
        } else {
            isDuplicate = this.dataSourceIds.contains(id);
        }
        return isDuplicate;
    }
}

