/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.admin.datasources.DataSourcePackage;
import com.cognos.admin.datasources.DataSourceUtil;
import com.cognos.admin.datasources.Error;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IJ2HTMLXmlProcessor;
import com.cognos.admin.portal.common.NavResponseItem;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ParsePackageNavResponse
implements IJ2HTMLXmlProcessor {
    public static final String NAV_RESPONSE_READER_NAME = "packageNavResponse";
    public static final String QUERY_RESPONSE_WRITER_NAME = "response";
    private static final String PACKAGE_TYPE = "package";
    private XMLStreamReader navResponseReader = null;
    private XMLStreamWriter queryResponseWriter = null;
    private DataSourcePackage dataSourcePackage = null;

    public void writeToXMLWriterStream(IContext context, Map<String, XMLStreamReader> readers, Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.setNavResponseReader(readers);
        this.setQueryResponseWriter(writers);
        this.readNavResponse();
        if (!DataSourceUtil.canPackageBeProcessed(this.dataSourcePackage)) {
            this.writeEmptyResponse();
        }
    }

    public DataSourcePackage getDataSourcePackage() {
        return this.dataSourcePackage;
    }

    private void setNavResponseReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        if (readers != null) {
            this.navResponseReader = readers.get(NAV_RESPONSE_READER_NAME);
        }
        if (this.navResponseReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_NAV_RESPONSE_READER.getMsg());
        }
    }

    private void setQueryResponseWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        if (writers != null) {
            this.queryResponseWriter = writers.get(QUERY_RESPONSE_WRITER_NAME);
        }
        if (this.queryResponseWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_QUERY_RESPONSE_WRITER.getMsg());
        }
    }

    private void readNavResponse() throws J2HTMLException {
        List<NavResponseItem> list = null;
        try {
            list = NavResponseItem.fromXmlReader(this.navResponseReader, null);
            if (list == null || list.size() == 0 || list.get(0) == null) {
                throw new J2HTMLException(Error.NO_PACKAGE.getMsg());
            }
            this.dataSourcePackage = new DataSourcePackage();
            this.dataSourcePackage.setId(list.get(0).getId());
            this.dataSourcePackage.setName(list.get(0).getName());
            this.dataSourcePackage.setSearchPath(list.get(0).getSearchPath());
            if (DataSourceUtil.canPackageBeProcessed(this.dataSourcePackage) && !PACKAGE_TYPE.equals(list.get(0).getDataType())) {
                throw new J2HTMLException(Error.NO_PACKAGE.getMsg());
            }
        }
        catch (J2HTMLException j2htmle) {
            throw j2htmle;
        }
        catch (Exception e) {
            throw new J2HTMLException(Error.PARSING_NAV_RESPONSE.getMsg(), (Throwable)e);
        }
    }

    private void writeEmptyResponse() throws J2HTMLException {
        try {
            this.queryResponseWriter.writeStartElement("packageDataSources");
            this.dataSourcePackage.toXmlStreamWriter(this.queryResponseWriter);
            this.queryResponseWriter.writeEndElement();
            this.queryResponseWriter.flush();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.WRITING_DATA_SOURCES.getMsg());
        }
    }
}

