/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.admin.datasources.DataSource;
import com.cognos.admin.datasources.DataSourcePackage;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.xml.stream.PathIterator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ReportMetadataResponseHandler
implements IXMLHandler {
    IContext context;
    XMLStreamWriter output;
    DataSourcePackage dataSourcePackage = null;

    public ReportMetadataResponseHandler(IContext context, XMLStreamWriter output, DataSourcePackage dataSourcePackage) {
        this.context = context;
        this.output = output;
        this.dataSourcePackage = dataSourcePackage;
    }

    public void handle(XMLStreamReader reader) throws XMLStreamException {
        Map<String, DataSource> dataSources = this.parseMetadata(reader);
        this.generateResponse(dataSources);
    }

    private Map<String, DataSource> parseMetadata(XMLStreamReader reader) throws XMLStreamException {
        LinkedHashMap<String, DataSource> dataSources = null;
        String dataSourcePath = null;
        PathIterator datasourceIterator = null;
        int index = -1;
        DataSource dataSource = null;
        dataSources = new LinkedHashMap<String, DataSource>();
        dataSourcePath = "/queryModelDataSources/output/dataSource";
        datasourceIterator = new PathIterator(reader, new String[]{dataSourcePath, dataSourcePath + "/" + "cmDataSource", dataSourcePath + "/" + "sourceType", dataSourcePath + "/" + "sourcePath", dataSourcePath + "/" + "directAccess"});
        block7: while ((index = datasourceIterator.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    if (dataSource != null && dataSource.getName() != null) {
                        dataSources.put(dataSource.getName(), dataSource);
                    }
                    dataSource = new DataSource();
                    continue block7;
                }
                case 1: {
                    dataSource.setName(datasourceIterator.getElementText());
                    continue block7;
                }
                case 2: {
                    dataSource.setType(datasourceIterator.getElementText());
                    continue block7;
                }
                case 3: {
                    dataSource.setSourcePath(datasourceIterator.getElementText());
                    continue block7;
                }
                case 4: {
                    dataSource.setDirectAccess(Boolean.valueOf(datasourceIterator.getElementText()));
                    continue block7;
                }
            }
        }
        if (dataSource != null && dataSource.getName() != null) {
            dataSources.put(dataSource.getName(), dataSource);
        }
        return dataSources;
    }

    private void generateResponse(Map<String, DataSource> dataSources) throws XMLStreamException {
        this.output.writeStartElement("packageDataSources");
        this.output.writeStartElement("package");
        this.output.writeStartElement("searchPath");
        this.output.writeCharacters(this.dataSourcePackage.getSearchPath());
        this.output.writeEndElement();
        this.output.writeStartElement("storeID");
        this.output.writeCharacters(this.dataSourcePackage.getId());
        this.output.writeEndElement();
        this.output.writeStartElement("name");
        this.output.writeCharacters(this.dataSourcePackage.getName());
        this.output.writeEndElement();
        this.output.writeStartElement("dataSources");
        Iterator<String> nameIter = dataSources.keySet().iterator();
        while (nameIter.hasNext()) {
            dataSources.get(nameIter.next()).toXmlStreamWriter(this.output);
        }
        this.output.writeEndElement();
        this.output.writeEndElement();
        this.output.writeEndElement();
    }
}

