/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.Model;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.ibm.cognos.cogadmin.Permissions;
import com.ibm.cognos.cogadmin.PermissionsUtils;
import com.ibm.cognos.soap.SoapServiceCallInfo;
import com.ibm.cognos.soap.cmservice.CMServiceLocatorFactory;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;

public class SoapServiceCall {
    public String getQueryStackInfo(SoapServiceCallInfo soapCallInfo, String modelPath) {
        String queryStack = null;
        ContentManagerService_ServiceLocator locator = null;
        ContentManagerService_PortType cmService = null;
        SearchPathMultipleObject searchPath = null;
        BaseClass[] baseClasses = null;
        try {
            locator = this.getCMServiceLocator();
            cmService = locator.getcontentManagerService(soapCallInfo.getUrl());
            ((Stub)cmService).setHeader(soapCallInfo.getSoapHeader());
            searchPath = new SearchPathMultipleObject(modelPath);
            baseClasses = cmService.query(searchPath, new PropEnum[]{PropEnum.options, PropEnum.permissions}, new Sort[0], new QueryOptions());
            if (baseClasses != null && baseClasses.length > 0) {
                queryStack = this.extractQueryStackInfoFromModel((Model)baseClasses[0]);
            }
        }
        catch (ServiceException se) {
            throw new SoapServiceCallException(se);
        }
        catch (RemoteException re) {
            throw new SoapServiceCallException(re);
        }
        return queryStack;
    }

    private ContentManagerService_ServiceLocator getCMServiceLocator() {
        CMServiceLocatorFactory factory = null;
        ContentManagerService_ServiceLocator locator = null;
        factory = new CMServiceLocatorFactory();
        locator = factory.createCMServiceLocator();
        return locator;
    }

    private String extractQueryStackInfoFromModel(Model model) {
        String queryStackInfo = null;
        OptionArrayProp optionArrayProp = null;
        Permissions permissions = null;
        permissions = PermissionsUtils.createPermissions((String[])model.getPermissions().getValue());
        if (permissions.getCanRead() && (queryStackInfo = this.extractQueryStackInfoFromOptionArray(optionArrayProp = model.getOptions())) == null) {
            queryStackInfo = "http://developer.cognos.com/ceba/constants/queryStackEnum#queryFramework";
        }
        return queryStackInfo;
    }

    private String extractQueryStackInfoFromOptionArray(OptionArrayProp optionArrayProp) {
        String queryStackInfo = null;
        Option[] options = null;
        GenericOptionAnyURI option = null;
        int j = 0;
        if (optionArrayProp != null) {
            options = optionArrayProp.getValue();
        }
        if (options != null && options.length > 0) {
            while (queryStackInfo == null && j < options.length) {
                if (options[j] instanceof GenericOptionAnyURI && "http://developer.cognos.com/ceba/constants/queryOptionEnum#queryStack".equals((option = (GenericOptionAnyURI)options[j]).getName())) {
                    queryStackInfo = option.getValue();
                }
                ++j;
            }
        }
        return queryStackInfo;
    }

    public static class SoapServiceCallException
    extends RuntimeException {
        private static final long serialVersionUID = -2846921516134213271L;

        public SoapServiceCallException(Throwable cause) {
            super(cause);
        }
    }
}

