/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.datasources.stages;

import com.cognos.admin.datasources.DataSourcePackage;
import com.cognos.admin.datasources.DataSourceUtil;
import com.cognos.admin.datasources.Error;
import com.cognos.admin.datasources.GetPackageDataSourcesRequest;
import com.cognos.admin.datasources.ParsePackageNavResponse;
import com.cognos.admin.datasources.ReportMetadataResponseHandler;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IJ2HTMLXmlProcessor;
import com.cognos.admin.j2html.control.IMessagesManager;
import com.cognos.admin.j2html.portal.producer.control.IXMLWriterProvider;
import com.cognos.admin.j2html.portal.producer.control.J2HTMLXMLWriterStage;
import com.cognos.admin.j2html.portal.producer.control.ProducerContext;
import com.cognos.admin.portal.common.messages.MessagesManagerFacade;
import com.cognos.admin.portal.producer.process.request.BusRequestStage;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.impl.bus.BusCommand;
import com.cognos.portal.xml.pipeline.PipelineException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class GetPackageDataSourcesStage
extends BusRequestStage {
    InternalReadNavResponseStage internalStage = null;

    public GetPackageDataSourcesStage(ServiceLogger logger) {
        super(logger);
    }

    @Override
    public void executeImpl(StageContext context) throws PipelineException {
        this.internalStage = new InternalReadNavResponseStage(null);
        this.internalStage.executeImpl(context);
        if (DataSourceUtil.canPackageBeProcessed(this.internalStage.getDataSourcePackage())) {
            super.executeImpl(context);
        }
    }

    @Override
    public BusCommand getBusCommand(StageContext context) throws PipelineException {
        ProducerContext producerContext = new ProducerContext(context, null);
        String searchPath = DataSourceUtil.getSearchPath((IContext)producerContext);
        if (null == searchPath || searchPath.length() == 0) {
            throw new IllegalArgumentException("Missing parameter: m_path");
        }
        return new GetPackageDataSourcesRequest(searchPath);
    }

    @Override
    protected IXMLHandler getResponseBodyHandler(StageContext context, XMLStreamWriter streamWriter) {
        return new ReportMetadataResponseHandler((IContext)new ProducerContext(context, null), streamWriter, this.internalStage.getDataSourcePackage());
    }

    @Override
    protected IXMLHandler getResponseFaultHandler(StageContext context, XMLStreamWriter streamWriter) {
        return new IXMLHandler(){

            public void handle(XMLStreamReader reader) throws XMLStreamException {
                throw new RuntimeException(Error.RETRIEVING_DATA_SOURCES_FROM_PACKAGE_MODEL.getMsg());
            }
        };
    }

    private class InternalReadNavResponseStage
    extends J2HTMLXMLWriterStage
    implements IXMLWriterProvider {
        private ParsePackageNavResponse getPackageDataSources;

        protected void executeImpl(StageContext context) throws PipelineException {
            super.executeImpl(context);
        }

        public InternalReadNavResponseStage(ServiceLogger logger) {
            super(logger);
            this.getPackageDataSources = null;
            this.getPackageDataSources = new ParsePackageNavResponse();
        }

        public IMessagesManager getMessagesManager() {
            return new MessagesManagerFacade();
        }

        public String[] getXMLReaderNames() {
            return new String[]{"packageNavResponse"};
        }

        public String[] getXMLWriterNames() {
            return new String[]{"response"};
        }

        public IJ2HTMLXmlProcessor getJ2HTMLXmlProcessor() {
            return this.getPackageDataSources;
        }

        public DataSourcePackage getDataSourcePackage() {
            return this.getPackageDataSources.getDataSourcePackage();
        }
    }
}

