/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.common;

import com.cognos.admin.common.NameSpace;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.portal.common.CommonError;
import com.cognos.admin.portal.common.NavRequestProcessor;
import com.cognos.portal.utils.XMLString;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class NavRequestBuilder
extends NavRequestProcessor {
    public static final String BUS_HEADER_PARAM = "busHeader";
    public static final String NAV_REQUEST_FLAG_TAG = "navRequest";
    public static final String NO_NAV_REQUEST_FLAG_TAG = "noNavRequest";
    public static final String ERROR_UNDEFINED_BUS_HEADER = "Undefined bus header";
    public static final String ERROR_WRITING_NAV_REQUEST = "Error while writing the nav request";

    protected void writeSoapEnvelope(XMLStreamWriter writer) throws J2HTMLException {
        try {
            writer.writeStartElement(NameSpace.SOAP_ENV.getPrefix(), "SOAP_ENV", NameSpace.SOAP_ENV.getUri());
            writer.setPrefix(NameSpace.SOAP_ENV.getPrefix(), NameSpace.SOAP_ENV.getUri());
            writer.setPrefix(NameSpace.SOAP_ENC.getPrefix(), NameSpace.SOAP_ENC.getUri());
            writer.setPrefix(NameSpace.BUS.getPrefix(), NameSpace.BUS.getUri());
            writer.setPrefix(NameSpace.XS.getPrefix(), NameSpace.XS.getUri());
            writer.setPrefix(NameSpace.XSD.getPrefix(), NameSpace.XSD.getUri());
            writer.setPrefix(NameSpace.NAV.getPrefix(), NameSpace.NAV.getUri());
            writer.writeNamespace(NameSpace.SOAP_ENV.getPrefix(), NameSpace.SOAP_ENV.getUri());
            writer.writeNamespace(NameSpace.SOAP_ENC.getPrefix(), NameSpace.SOAP_ENC.getUri());
            writer.writeNamespace(NameSpace.BUS.getPrefix(), NameSpace.BUS.getUri());
            writer.writeNamespace(NameSpace.XS.getPrefix(), NameSpace.XS.getUri());
            writer.writeNamespace(NameSpace.XSD.getPrefix(), NameSpace.XSD.getUri());
            writer.writeNamespace(NameSpace.NAV.getPrefix(), NameSpace.NAV.getUri());
            this.writeSoapHeader(writer);
            this.writeSoapBody(writer);
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(ERROR_WRITING_NAV_REQUEST, (Throwable)xmle);
        }
    }

    private void writeSoapHeader(XMLStreamWriter writer) throws XMLStreamException, J2HTMLException {
        XMLString busHeader = null;
        writer.writeStartElement(NameSpace.SOAP_ENV.getUri(), "Header");
        busHeader = (XMLString)this.getContext().getParameter(BUS_HEADER_PARAM);
        if (busHeader == null) {
            throw new J2HTMLException(ERROR_UNDEFINED_BUS_HEADER);
        }
        busHeader.write(writer);
        writer.writeEndElement();
    }

    private void writeSoapBody(XMLStreamWriter writer) throws XMLStreamException, J2HTMLException {
        writer.writeStartElement(NameSpace.SOAP_ENV.getUri(), "Body");
        this.writeNavRequest(writer);
        writer.writeEndElement();
    }

    private void writeNavRequest(XMLStreamWriter writer) throws XMLStreamException, J2HTMLException {
        writer.writeStartElement(NameSpace.NAV.getUri(), "request");
        this.writeNavRequestParams(writer);
        this.writeNavRequestQueries(writer);
        writer.writeEndElement();
    }

    protected void writeNavRequestParams(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NameSpace.NAV.getUri(), "param");
        writer.writeAttribute("name", "webContentURL");
        writer.writeCharacters(this.getContext().getEnv().getWebContent());
        writer.writeEndElement();
    }

    protected void writeGetItemQuery(XMLStreamWriter writer, String path) throws XMLStreamException {
        List<String> defaultProperties = Arrays.asList("searchPath", "screenTip", "permissions", "hidden", "tenantID");
        this.writeGetItemQuery(writer, path, defaultProperties);
    }

    protected void writeGetItemQuery(XMLStreamWriter writer, String path, List<String> properties) throws XMLStreamException {
        writer.writeStartElement(NameSpace.NAV.getUri(), "query");
        writer.writeStartElement(NameSpace.NAV.getUri(), "getItem");
        writer.writeStartElement(NameSpace.NAV.getUri(), "id");
        writer.writeCharacters(this.getPathCriteria(path));
        writer.writeEndElement();
        for (String propertyName : properties) {
            writer.writeStartElement(NameSpace.NAV.getUri(), "property");
            writer.writeAttribute("name", propertyName);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void writeNoNavRequestFlag(XMLStreamWriter writer) throws J2HTMLException {
        try {
            writer.writeStartElement(NO_NAV_REQUEST_FLAG_TAG);
            writer.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(CommonError.WRITING_NO_NAV_REQUEST_FLAG.getMsg(), (Throwable)xmle);
        }
    }

    protected void writeNavRequestFlag(XMLStreamWriter writer) throws J2HTMLException {
        try {
            writer.writeStartElement(NAV_REQUEST_FLAG_TAG);
            writer.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(CommonError.WRITING_NAV_REQUEST_FLAG.getMsg(), (Throwable)xmle);
        }
    }

    protected abstract void writeNavRequestQueries(XMLStreamWriter var1) throws J2HTMLException, XMLStreamException;

    protected abstract IContext getContext();

    public String getPathCriteria(String path) {
        return "path:" + path;
    }
}

