/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.components.policy;

import com.cognos.admin.j2html.Attributes;
import com.cognos.admin.j2html.CheckBox;
import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.ControlledComponent;
import com.cognos.admin.j2html.DefaultTableCellRenderer;
import com.cognos.admin.j2html.DefaultTableLayoutHandler;
import com.cognos.admin.j2html.ITableLayoutHandler;
import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.Label;
import com.cognos.admin.j2html.Link;
import com.cognos.admin.j2html.Message;
import com.cognos.admin.j2html.Panel;
import com.cognos.admin.j2html.SectionPane;
import com.cognos.admin.j2html.SkinImage;
import com.cognos.admin.j2html.Table;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.TableLayoutConstraint;
import com.cognos.admin.j2html.TableLayoutPane;
import com.cognos.admin.j2html.actions.AbstractAction;
import com.cognos.admin.j2html.actions.CheckBoxTogglerAction;
import com.cognos.admin.j2html.actions.IAction;
import com.cognos.admin.j2html.actions.RetrieveAction;
import com.cognos.admin.j2html.actions.ShowIFrameDialog;
import com.cognos.admin.j2html.actions.TransientUpdate;
import com.cognos.admin.j2html.actions.TransientUpdateAction;
import com.cognos.admin.j2html.common.message.MessagesManagerFacade;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.portal.producer.common.XMLProperties;
import com.cognos.admin.j2html.table.DefaultTableModel;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.ITableModel;
import com.cognos.admin.j2html.table.ITableRowRenderer;
import com.cognos.admin.j2html.table.TableRowSeparator;
import com.cognos.admin.j2html.utils.Parameters;
import com.cognos.admin.portal.components.policy.Policy;
import com.cognos.admin.portal.components.policy.PolicyEditorTableModel;
import com.cognos.admin.portal.components.policy.PolicyMetaData;
import com.cognos.admin.portal.components.policy.PolicyMetaDataList;
import com.cognos.admin.portal.components.policy.PrivilegeAction;
import com.cognos.admin.portal.components.policy.PrivilegeTooltip;
import com.cognos.admin.portal.components.policy.Resource;
import com.cognos.admin.portal.components.policy.ResourceEditorRenderer;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PolicyComponent
extends ControlledComponent {
    private static final int COLUMN_ICON = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_CAPABILITIES = 2;
    private static final String PERMISSION_DISPLAY = "display";
    static final String PERMISSION_GRANT = "grant";
    private static final String PERMISSION_DENY = "deny";
    private static final String PERMISSION_NOT_SET = "";
    static final String PERMISSION_FLAG_GRANT = "y";
    static final String PERMISSION_FLAG_DENY = "n";
    private static final String MSG_KEY_PERMISSIONS_COLUMN_HEADING = "permissionsColumnHeading";
    private static final String MSG_KEY_DIALOG_INTRODUCTORY_TEXT = "dialogIntroductoryText";
    private static final String MSG_KEY_OVERRIDE_PARENT_TEXT = "overrideParentText";
    private static final String MSG_KEY_OVERRIDE_CONFIRM_TEXT = "overrideConfirmText";
    private static final String MSG_KEY_DELETE_INTRODUCTORY_TEXT = "deleteIntroductoryText";
    private static final String MSG_KEY_DELETE_TEXT = "deleteText";
    private static final String MSG_KEY_SORT = "sortEditor";
    private static final String META_KEY_ICON_SIZE = "iconSize";
    private Table policyTable = null;

    public PolicyComponent(IContext context, Policy policy, DefaultTableModel tableModel, PolicyMetaDataList permissionsMetadata, XMLProperties uiStrings) throws J2HTMLException {
        super(context);
        boolean is3rdPartyNamespace = "true".equals(context.getEnv().getParameter("3rdPartyNS"));
        policy.setAcquired(policy.isAcquirable() && policy.isAcquired());
        context.setStateParameter("acquired", Boolean.toString(policy.isAcquired()));
        this.policyTable = new Table((ITableModel)tableModel);
        this.policyTable.setSortable(true, true);
        boolean sort = "true".equals(uiStrings.getProperty(MSG_KEY_SORT));
        JSONObject clientPublicModel = new JSONObject();
        JSONObject clientStateModel = new JSONObject();
        clientPublicModel.put((Object)"title", (Object)policy.getTitle());
        JSONArray clientPublicModelMetaArray = new JSONArray();
        clientPublicModel.put((Object)"meta", (Object)clientPublicModelMetaArray);
        Iterator<PolicyMetaData> iter = permissionsMetadata.iterator(sort);
        while (iter.hasNext()) {
            PolicyMetaData permissionMetadata = iter.next();
            JSONObject clientPublicModelMeta = new JSONObject();
            clientPublicModelMetaArray.add((Object)clientPublicModelMeta);
            clientPublicModelMeta.put((Object)"name", (Object)permissionMetadata.getValue());
            clientPublicModelMeta.put((Object)"caption", (Object)permissionMetadata.getTitle());
            clientPublicModelMeta.put((Object)"icon", (Object)permissionMetadata.getIconPath(PERMISSION_DISPLAY));
            clientPublicModelMeta.put((Object)"scope", (Object)permissionMetadata.getScope());
            JSONArray childClientPublicModelMetaArray = new JSONArray();
            clientPublicModelMeta.put((Object)"meta", (Object)childClientPublicModelMetaArray);
            Iterator<PolicyMetaData> childIter = permissionMetadata.getChildPolicies(sort);
            while (childIter.hasNext()) {
                PolicyMetaData childPermission = childIter.next();
                JSONObject childClientPublicModelMeta = new JSONObject();
                childClientPublicModelMetaArray.add((Object)childClientPublicModelMeta);
                childClientPublicModelMeta.put((Object)"name", (Object)childPermission.getValue());
                childClientPublicModelMeta.put((Object)"caption", (Object)childPermission.getTitle());
                childClientPublicModelMeta.put((Object)"icon", (Object)permissionMetadata.getIconPath(PERMISSION_DISPLAY));
                childClientPublicModelMeta.put((Object)"scope", (Object)childPermission.getScope());
            }
        }
        this.addClientPublicVariable(clientPublicModel, false);
        clientStateModel.put((Object)"acquired", (Object)policy.isAcquired());
        clientStateModel.put((Object)"3rdPartyNS", (Object)is3rdPartyNamespace);
        clientStateModel.put((Object)"object", (Object)policy.getStoreID());
        JSONArray privileges = new JSONArray();
        clientStateModel.put((Object)"privileges", (Object)privileges);
        for (int ii = 0; ii < this.policyTable.getRowCount(); ++ii) {
            Resource resource = (Resource)this.policyTable.getValue(ii, 0);
            HashMap permissions = resource.getPermissions();
            JSONObject privilege = new JSONObject();
            privileges.add((Object)privilege);
            privilege.put((Object)"key", (Object)resource.getStoreID());
            JSONArray privilegeArray = new JSONArray();
            privilege.put((Object)"privilege", (Object)privilegeArray);
            for (Map.Entry policyPermission : permissions.entrySet()) {
                String capability = (String)policyPermission.getKey();
                String permission = (String)policyPermission.getValue();
                JSONObject privilegeEntry = new JSONObject();
                privilegeArray.add((Object)privilegeEntry);
                privilegeEntry.put((Object)"name", (Object)capability);
                privilegeEntry.put((Object)"flag", (Object)(PERMISSION_GRANT.equals(permission) ? PERMISSION_FLAG_GRANT : (PERMISSION_DENY.equals(permission) ? PERMISSION_FLAG_DENY : PERMISSION_NOT_SET)));
            }
        }
        this.addClientPublicVariable(clientStateModel, true);
        PolicyEditorTableModel policyEditorTableModel = new PolicyEditorTableModel(context, permissionsMetadata, sort);
        policyEditorTableModel.setSummary(context.localize("IDS_PPP_HEADING_SET_PERMISSIONS"));
        Table policyEditor = new Table((ITableModel)policyEditorTableModel);
        policyEditor.setSupportsListViewSeparatorPreference(false);
        policyEditor.createDefaultColumnsFromModel();
        ResourceEditorRenderer renderer = new ResourceEditorRenderer((Component)this, "true".equals(uiStrings.getProperty("displayEditorGroupLines")));
        policyEditor.setDefaultRenderer((ITableCellRenderer)renderer);
        policyEditor.setRowRenderer((ITableRowRenderer)renderer);
        policyEditor.getTableHeader().setDefaultRenderer((ITableCellRenderer)new DefaultTableCellRenderer());
        policyEditor.getTableHeader().setDefaultRenderer((ITableCellRenderer)new PolicyEditorHeaderRenderer());
        this.policyTable.setRowRenderer((ITableRowRenderer)new ResourceTableRowRenderer());
        this.policyTable.createDefaultColumnsFromModel();
        TableColumn resourceIconCol = this.policyTable.getColumn(0);
        TableColumn resourceNameCol = this.policyTable.getColumn(1);
        this.policyTable.setSortedColumn(1, true, true);
        resourceNameCol.setTextAlign("left");
        final String policyText = uiStrings.getProperty(MSG_KEY_PERMISSIONS_COLUMN_HEADING);
        TableColumn policyColumn = this.policyTable.getColumn(2);
        policyColumn.setColumnSpan(this.policyTable.getColumnCount() - 2);
        policyColumn.setSortable(false);
        policyColumn.setHeaderRenderer(new ITableCellRenderer(){

            public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return new Label(policyText);
            }
        });
        this.policyTable.setDefaultRenderer((ITableCellRenderer)new ResourcePermissionsColRenderer(permissionsMetadata, 2, uiStrings.getProperty(META_KEY_ICON_SIZE), sort));
        resourceIconCol.setCellRenderer((ITableCellRenderer)new ResourceImageTableCellRenderer());
        resourceNameCol.setCellRenderer((ITableCellRenderer)new ResourceNameTableCellRenderer());
        resourceNameCol.setHeaderRenderer((ITableCellRenderer)new ResourceNameTableCellRenderer());
        resourceIconCol.setWidth("16px");
        resourceNameCol.setHeaderValue((Object)context.localize("IDS_HEADING_NAME"));
        this.policyTable.getTableHeader().setWhiteSpaceWordWrap(true);
        SectionPane mainSection = new SectionPane();
        mainSection.setSeparator(false);
        mainSection.setDescription(uiStrings.getProperty(MSG_KEY_DIALOG_INTRODUCTORY_TEXT));
        if (policy.isPartiallyUnavailable()) {
            Message message = new Message();
            message.setMessageText(context.localize("IDS_PEP_ENTRIES_HIDDEN_WARNING"));
            message.setMessageType("wrn");
            mainSection.add((Component)message);
        }
        CheckBox overridePolicyCheckbox = new CheckBox("overridePolicy", (Object)Boolean.TRUE);
        overridePolicyCheckbox.setID("overridePolicy");
        overridePolicyCheckbox.setLabel(uiStrings.getProperty(MSG_KEY_OVERRIDE_PARENT_TEXT));
        Parameters actionArguments = new Parameters();
        overridePolicyCheckbox.setChecked(!policy.isAcquired());
        overridePolicyCheckbox.setDisabled(is3rdPartyNamespace);
        RetrieveAction ra = new RetrieveAction((ControlledComponent)this, actionArguments);
        overridePolicyCheckbox.setAction((IAction)ra);
        mainSection.add((Component)overridePolicyCheckbox);
        Link addLink = new Link(context.localize("IDS_ADD"));
        addLink.setAction((IAction)new ShowIFrameDialog("portal/add_entries_cap.xts"));
        Link removeLink = new Link(context.localize("IDS_REMOVE"));
        removeLink.setAction((IAction)new PrivilegeAction("removeEntries"));
        TableLayoutPane policyTableLayout = new TableLayoutPane(2, 2);
        DefaultTableLayoutHandler policyTableLayoutHandler = new DefaultTableLayoutHandler();
        policyTableLayout.setTableLayoutHandler((ITableLayoutHandler)policyTableLayoutHandler);
        policyTableLayout.setCellPadding(1);
        policyTableLayout.setCellSpacing(0);
        TableLayoutConstraint constraintTop = new TableLayoutConstraint();
        policyTableLayoutHandler.add((Component)this.policyTable, 0, 0, constraintTop);
        TableLayoutConstraint constraintBot = new TableLayoutConstraint();
        constraintBot.setAlign("right");
        addLink.setPadding("4px");
        Panel btnPanel = new Panel();
        btnPanel.add((Component)addLink);
        btnPanel.add((Component)removeLink);
        policyTableLayoutHandler.add((Component)btnPanel, 1, 0, constraintBot);
        boolean editable = true;
        if (policy.isAcquirable()) {
            if (policy.isAcquired() || !policy.isModifiable()) {
                editable = false;
            }
            if (!policy.isAcquired()) {
                ra.setPrompt(uiStrings.getProperty(MSG_KEY_OVERRIDE_CONFIRM_TEXT), "confirm");
            }
            if (!policy.isModifiable()) {
                overridePolicyCheckbox.setEnabled(false);
            }
        } else {
            editable = policy.isModifiable();
            overridePolicyCheckbox.setVisible(false);
        }
        if (!editable) {
            policyEditor.setVisible(false);
            addLink.setVisible(false);
            removeLink.setVisible(false);
        }
        this.policyTable.setSupportsGroupActions(true, editable);
        actionArguments.setValue("acquired", Boolean.toString(!policy.isAcquired()));
        TableLayoutPane layoutPane = new TableLayoutPane(2, 2);
        DefaultTableLayoutHandler layoutHandler = new DefaultTableLayoutHandler();
        layoutHandler.getDefaultConstraint().setVerticalAlign("top");
        layoutHandler.getDefaultConstraint().setPadding("0 20 0 0");
        TableLayoutConstraint editorConstraint = new TableLayoutConstraint();
        editorConstraint.setPadding("1 20 0 0");
        editorConstraint.setVerticalAlign("top");
        layoutHandler.setConstraint(editorConstraint, 1);
        layoutPane.setTableLayoutHandler((ITableLayoutHandler)layoutHandler);
        layoutPane.setHeight("50px");
        layoutHandler.add((Component)policyTableLayout, 0, 0);
        layoutHandler.add((Component)policyEditor, 0, 1);
        mainSection.add((Component)layoutPane);
        SectionPane optionSection = new SectionPane();
        optionSection.setTitle(context.localize("IDS_PEP_OPTION_SEP"));
        optionSection.setDescription(uiStrings.getProperty(MSG_KEY_DELETE_INTRODUCTORY_TEXT));
        CheckBox clearChildPoliciesCheckbox = new CheckBox("clearChildPolicies", (Object)Boolean.TRUE);
        clearChildPoliciesCheckbox.setID("clearChildPolicies");
        clearChildPoliciesCheckbox.setLabel(uiStrings.getProperty(MSG_KEY_DELETE_TEXT));
        optionSection.add((Component)clearChildPoliciesCheckbox);
        this.add((Component)mainSection);
        this.add((Component)optionSection);
    }

    public int getDepth() {
        return 0;
    }

    public int getNumRow() {
        return 0;
    }

    public String getTargetURI() {
        return this.getContext().getEnv().getTarget();
    }

    private class PolicyEditorHeaderRenderer
    implements ITableCellRenderer {
        CheckBox checkBox = new CheckBox();
        Label label = new Label();

        public PolicyEditorHeaderRenderer() {
            this.checkBox.setAction((IAction)new PrivilegeAction("update"));
            this.checkBox.setEnabled(false);
        }

        public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text = table.getModel().getColumnName(column);
            if (column == 2 || column == 3) {
                this.checkBox.setLabel(text);
                this.checkBox.setID(new StringBuffer("_toggle_all_").append(column == 2 ? (char)'y' : 'n').toString());
                return this.checkBox;
            }
            this.label.setText(text);
            return this.label;
        }
    }

    private class ResourcePermissionsColRenderer
    extends DefaultTableCellRenderer {
        PolicyMetaDataList permissionsMetadata = null;
        Image icon = new Image();
        int offset = 0;
        boolean sort = false;
        PrivilegeTooltip tooltip = new PrivilegeTooltip();

        public ResourcePermissionsColRenderer(PolicyMetaDataList permissionsMetadata, int offset, String iconSize, boolean sort) {
            this.permissionsMetadata = permissionsMetadata;
            this.offset = offset;
            this.sort = sort;
            this.icon.setAction((IAction)this.tooltip);
            this.icon.setWidth(iconSize);
        }

        private String getAltText(String title, String value) {
            String valueText = PolicyComponent.PERMISSION_NOT_SET;
            if (PolicyComponent.PERMISSION_GRANT.equals(value)) {
                valueText = this.getLocalText(title, "IDS_PCP_ALT_GRANT");
            } else if (PolicyComponent.PERMISSION_DENY.equals(value)) {
                valueText = this.getLocalText(title, "IDS_PCP_ALT_DENY");
            }
            return valueText;
        }

        private String getLocalText(String title, String stringID) {
            return MessagesManagerFacade.getInstance().getMessage(PolicyComponent.this.getContext().getEnv().getProductLocale(), stringID, (Object[])new String[]{title}) + ",";
        }

        public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            PolicyMetaData meta;
            PolicyMetaData permissionMetadata = this.permissionsMetadata.get(column - this.offset);
            table.getColumn(0).setAttribute("scope", "row");
            table.getColumn(2).setColumnSpan(1);
            String permission = String.valueOf(((HashMap)value).get(permissionMetadata.getValue()));
            Iterator<PolicyMetaData> iter = permissionMetadata.getChildPolicies(this.sort);
            StringBuffer alt = new StringBuffer(this.getAltText(permissionMetadata.getTitle(), permission));
            if (!permissionMetadata.isObjectScope() && iter.hasNext()) {
                meta = iter.next();
                permission = new StringBuffer().append(((HashMap)value).get(meta.getValue())).toString();
                alt = new StringBuffer(this.getAltText(meta.getTitle(), permission));
            }
            while (iter.hasNext()) {
                meta = iter.next();
                String childPermission = String.valueOf(((HashMap)value).get(meta.getValue()));
                alt.append(this.getAltText(meta.getTitle(), childPermission));
                if (permission.equals(childPermission)) continue;
                permission = "mixed";
            }
            if (permission.equals("null")) {
                this.icon.setPath("/ps/portal/images/access_none.gif", false);
                this.icon.setAlt(PolicyComponent.PERMISSION_NOT_SET);
            } else {
                this.icon.setPath(permissionMetadata.getIconPath(permission), false);
                this.icon.setAlt(alt.toString());
            }
            Resource resource = (Resource)table.getValue(row, 0);
            this.tooltip.setContext(resource.getStoreID(), permissionMetadata.getValue());
            this.icon.setID(new StringBuffer("_").append(resource.getStoreID()).append("_").append(permissionMetadata.getValue()).toString());
            return this.icon;
        }
    }

    private class ResourceNameTableCellRenderer
    extends DefaultTableCellRenderer {
        TableLayoutPane container = new TableLayoutPane(1, 2);
        SkinImage image = new SkinImage("/portal/images/path.gif");
        Label label = new Label();
        TableLayoutConstraint constraint = new TableLayoutConstraint();

        public ResourceNameTableCellRenderer() {
            this.constraint.setPadding("0px");
            this.constraint.setWordWrap(false);
            this.image.setPadding("0px");
            this.container.setCellPadding(0);
            this.container.setCellSpacing(0);
            this.container.setTableLayoutHandler(new ITableLayoutHandler(){

                public TableLayoutConstraint getTableLayoutConstaint(int row, int column) {
                    return ResourceNameTableCellRenderer.this.constraint;
                }

                public Component getTableLayoutComponent(int row, int column) {
                    if (column == 0) {
                        return ResourceNameTableCellRenderer.this.image;
                    }
                    return ResourceNameTableCellRenderer.this.label;
                }
            });
        }

        public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String resourcePath = PolicyComponent.PERMISSION_NOT_SET;
            if (value instanceof Resource) {
                Resource resource = (Resource)value;
                resourcePath = resource.getFullPath();
                this.image.setVisible(resource.isAvailable());
                this.label.setText(resource.getTitle());
            } else {
                resourcePath = table.getContext().localize("IDS_PEP_ACCESS_FULL_PATH");
                this.label.setText(value.toString());
            }
            this.image.setToolTip(resourcePath);
            this.image.setAlt(resourcePath);
            return this.container;
        }
    }

    private class ResourceImageTableCellRenderer
    extends DefaultTableCellRenderer {
        Image image = new Image();

        private ResourceImageTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Resource resource = (Resource)value;
            this.image.setToolTip(resource.getTitle());
            this.image.setAlt(resource.getTitle());
            this.image.setPath(resource.getIcon(), false);
            return this.image;
        }
    }

    private class ResourceTableRowRenderer
    implements ITableRowRenderer {
        TransientUpdate transientUpdate;
        TransientUpdateAction action;
        Resource resource;
        Table table = null;
        CheckBoxTogglerAction checkBoxAction = new CheckBoxTogglerAction("Privileges", "show");
        int row = 0;
        TableRowSeparator tableRowSeparator = new TableRowSeparator(true);

        private ResourceTableRowRenderer() {
        }

        public void init(Table table, int row) {
            this.table = table;
            table.getColumn(0).setCellRenderer((ITableCellRenderer)new ResourceImageTableCellRenderer());
            this.row = row;
            this.resource = (Resource)table.getValue(row, 0);
        }

        public AbstractAction getSelectionAction() {
            return null;
        }

        public String getSelectedRowStateKey() {
            return this.resource.getStoreID();
        }

        public String getGroupActionKey() {
            return this.resource.getStoreID();
        }

        public TableRowSeparator getTableRowSeparator(boolean isAfter) {
            return null;
        }

        public AbstractAction getGroupAction() {
            return this.checkBoxAction;
        }

        public Attributes getRowAttributes() {
            return null;
        }
    }
}

