/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.components.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class PolicyMetaData
implements Comparable {
    private String value = null;
    private String title = null;
    private HashMap<String, String> icons = new HashMap();
    private String scope = null;
    private ArrayList<PolicyMetaData> childPolicies = new ArrayList();
    private int level = 0;
    private boolean isLastSibling = false;
    private boolean isGranted = false;
    public static final String GLOBAL_SCOPE = "global";
    public static final String OBJECT_SCOPE = "package";
    private static final String DISPLAY_ICON_POSTFIX = "_grant.gif";
    private static final String GRANT_ICON_POSTFIX = "_g.gif";

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void addIcon(String use, String path) {
        if ("grant".equals(use)) {
            path = path.replaceFirst(DISPLAY_ICON_POSTFIX, GRANT_ICON_POSTFIX);
        }
        this.icons.put(use, path);
    }

    public String getIconPath(String use) {
        return this.icons.get(use);
    }

    public boolean isObjectScope() {
        return OBJECT_SCOPE.equals(this.scope);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = OBJECT_SCOPE.equals(scope) ? OBJECT_SCOPE : GLOBAL_SCOPE;
    }

    public void addPolicy(PolicyMetaData policy) {
        this.childPolicies.add(policy);
    }

    public ArrayList<PolicyMetaData> getChildPolicyList(boolean sort) {
        if (sort) {
            Collections.sort(this.childPolicies);
        }
        return this.childPolicies;
    }

    public Iterator<PolicyMetaData> getChildPolicies(boolean sort) {
        if (sort) {
            Collections.sort(this.childPolicies);
        }
        return this.childPolicies.iterator();
    }

    public boolean containsObjectScope() {
        for (PolicyMetaData childPolicy : this.getChildPolicyList(false)) {
            if (!childPolicy.isObjectScope()) continue;
            return true;
        }
        return false;
    }

    public void filterGlobalPolicies() {
        Iterator<PolicyMetaData> iter = this.getChildPolicies(false);
        while (iter.hasNext()) {
            PolicyMetaData policy = iter.next();
            if (!policy.isObjectScope() && !policy.containsObjectScope()) {
                iter.remove();
                continue;
            }
            policy.filterGlobalPolicies();
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isRootLevel() {
        return this.getLevel() == 0;
    }

    public boolean isLastSibling() {
        return this.isLastSibling;
    }

    public void setLastSibling(boolean isLastSibling) {
        this.isLastSibling = isLastSibling;
    }

    public boolean isGranted() {
        return this.isGranted;
    }

    public void setGranted(boolean isGranted) {
        this.isGranted = isGranted;
    }

    public int compareTo(Object obj) {
        return this.getTitle().compareTo(((PolicyMetaData)obj).getTitle());
    }
}

