/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.components.policy;

import com.cognos.admin.portal.components.policy.PolicyMetaData;
import com.cognos.portal.xml.stream.PathIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PolicyMetaDataList {
    ArrayList<PolicyMetaData> policyList;
    private static final String ROOT_METADATA = "/metadata/permission";

    public void loadFromXML(XMLStreamReader metadataReader) throws XMLStreamException {
        int index;
        this.policyList = new ArrayList();
        PathIterator metadataIter = new PathIterator(metadataReader, new String[]{ROOT_METADATA, "/metadata/permission/value", "/metadata/permission/title", "/metadata/permission/icon", "/metadata/permission/scope", "/metadata/permission/permission", "/metadata/permission/permission/value", "/metadata/permission/permission/title", "/metadata/permission/permission/icon", "/metadata/permission/permission/scope"});
        PolicyMetaData currentPolicy = null;
        PolicyMetaData childPolicy = null;
        String value = null;
        while ((index = metadataIter.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    currentPolicy = new PolicyMetaData();
                    break;
                }
                case 1: {
                    value = metadataIter.getElementText();
                    currentPolicy.setValue(value);
                    break;
                }
                case 2: {
                    String title = metadataIter.getElementText();
                    currentPolicy.setTitle(title);
                    break;
                }
                case 3: {
                    currentPolicy.addIcon(metadataIter.getAttributeValue(0), metadataIter.getElementText());
                    break;
                }
                case 4: {
                    currentPolicy.setScope(metadataIter.getElementText());
                    this.policyList.add(currentPolicy);
                    break;
                }
                case 5: {
                    childPolicy = new PolicyMetaData();
                    childPolicy.setLevel(1);
                    break;
                }
                case 6: {
                    childPolicy.setValue(metadataIter.getElementText());
                    break;
                }
                case 7: {
                    childPolicy.setTitle(metadataIter.getElementText());
                    break;
                }
                case 8: {
                    childPolicy.addIcon(metadataIter.getAttributeLocalName(0), metadataIter.getElementText());
                    break;
                }
                case 9: {
                    childPolicy.setScope(metadataIter.getElementText());
                    currentPolicy.addPolicy(childPolicy);
                }
            }
        }
    }

    public void filterPolicies(HashSet<String> filterPolicies) {
        Iterator<PolicyMetaData> iter = this.policyList.iterator();
        this.filterPolicies(filterPolicies, iter);
    }

    public void filterPolicies(HashSet<String> filterPolicies, Iterator<PolicyMetaData> policyMetaDataIterator) {
        while (policyMetaDataIterator.hasNext()) {
            PolicyMetaData policy = policyMetaDataIterator.next();
            if (!this.includePolicy(filterPolicies, policy)) {
                policyMetaDataIterator.remove();
            }
            this.filterPolicies(filterPolicies, policy.getChildPolicies(true));
        }
    }

    private boolean includePolicy(HashSet<String> filterPolicies, PolicyMetaData policy) {
        if (filterPolicies.contains(policy.getValue())) {
            return true;
        }
        for (PolicyMetaData childPolicy : policy.getChildPolicyList(true)) {
            if (!filterPolicies.contains(childPolicy.getValue())) continue;
            return true;
        }
        return false;
    }

    public void filterGlobalPolicies() {
        Iterator<PolicyMetaData> iter = this.policyList.iterator();
        while (iter.hasNext()) {
            PolicyMetaData policy = iter.next();
            if (!policy.isObjectScope() && !policy.containsObjectScope()) {
                iter.remove();
                continue;
            }
            policy.filterGlobalPolicies();
        }
    }

    public int size() {
        return this.policyList.size();
    }

    public ArrayList<PolicyMetaData> getList(boolean sort) {
        if (sort) {
            Collections.sort(this.policyList);
        }
        return this.policyList;
    }

    public Iterator<PolicyMetaData> iterator(boolean sort) {
        if (sort) {
            Collections.sort(this.policyList);
        }
        return this.policyList.iterator();
    }

    public PolicyMetaData get(int index) {
        return this.policyList.get(index);
    }

    public PolicyMetaData get(String key) {
        for (PolicyMetaData policy : this.policyList) {
            if (policy.getValue().equals(key)) {
                return policy;
            }
            for (PolicyMetaData childPolicy : policy.getChildPolicyList(false)) {
                if (!childPolicy.getValue().equals(key)) continue;
                return childPolicy;
            }
        }
        return null;
    }
}

