/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.components.system;

import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.resource.v1_0.Constants;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.xts.ext.XTSExt;
import java.io.UnsupportedEncodingException;

public class Resource
implements Comparable {
    private String name;
    private String detailedName = null;
    private String resourceId = null;
    private String encodedResourceId = null;
    private String storeId = null;
    private String objectClass = null;
    private String iconPath;
    private String iconTooltip = null;
    private String ancestors = "";
    private boolean isVirtual = false;
    private boolean hasChildren = false;
    private boolean isDispatcher = false;
    private String operationalStatus = null;
    private String health = null;
    private boolean canNavigate = false;
    private boolean enableActions = false;
    private String type = null;
    private boolean hidden = false;
    private String tenantID = null;

    public Resource() {
    }

    public Resource(String name, String resourceId, String iconPath, boolean hasChildren) throws UnsupportedEncodingException, BaseFaultType {
        this.setName(name);
        this.setDetailedName(name);
        this.setResourceId(resourceId);
        this.setIconPath(iconPath);
        this.setHasChildren(hasChildren);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDetailedName(String name) {
        this.detailedName = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDetailedName() {
        return this.detailedName;
    }

    public void setResourceId(String resourceId) throws UnsupportedEncodingException, BaseFaultType {
        this.resourceId = resourceId;
        this.encodedResourceId = XTSExt.urlencode((String)resourceId);
        IResourceID id = ResourceIdFactory.getResourceID((String)resourceId);
        this.isVirtual = Constants.RESOURCE_TYPES_VIRTUAL.contains(id.getBaseType());
        this.isDispatcher = "dispatcher".equals(id.getBaseType());
        this.setHasChildren(this.isVirtual() || this.isDispatcher);
        if (!this.isVirtual()) {
            this.setStoreId(id.getId());
        } else {
            this.setStoreId(null);
        }
    }

    public String getResourceId() {
        return this.getResourceId(true);
    }

    public String getResourceId(boolean urlEncoded) {
        return urlEncoded ? this.encodedResourceId : this.resourceId;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId != null ? storeId : "";
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public void setIconTooltip(String iconTooltip) {
        this.iconTooltip = iconTooltip;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public String getObjectClass() {
        return this.objectClass != null ? this.objectClass : this.getType();
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getIconTooltip() {
        return this.iconTooltip;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String toString() {
        return this.detailedName;
    }

    public String getOperationalStatus() {
        return this.operationalStatus;
    }

    public void setOperationalStatus(String operationalStatus) {
        this.operationalStatus = operationalStatus;
    }

    public String getHealth() {
        return this.health;
    }

    public void setHealth(String health) {
        this.health = health;
    }

    public void setCanNavigate(boolean canNavigate) {
        this.canNavigate = canNavigate;
    }

    public boolean canNavigate() {
        return this.canNavigate;
    }

    public void enableActions(boolean enableActions) {
        this.enableActions = enableActions;
    }

    public boolean isActionsEnabled() {
        return this.enableActions;
    }

    public void setAncestors(String ancestors) {
        String[] aAncestors;
        if (ancestors != null && (aAncestors = ancestors.split(">", 2)).length > 1) {
            this.ancestors = aAncestors[aAncestors.length - 1];
        }
    }

    public String getAncestors() {
        return this.ancestors;
    }

    public int compareTo(Object obj) {
        return this.getDetailedName().compareToIgnoreCase(((Resource)obj).getDetailedName());
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public String getTenantID() {
        return this.tenantID;
    }
}

