/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.components.system;

import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.Container;
import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.Link;
import com.cognos.admin.j2html.SkinImage;
import com.cognos.admin.j2html.Table;
import com.cognos.admin.j2html.actions.IAction;
import com.cognos.admin.j2html.actions.JavascriptAction;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.portal.components.system.Resource;

public class ResourceTableCellRenderer
implements ITableCellRenderer {
    private Image resourceIcon = new Image();
    private Link navigateLink = new Link();
    private JavascriptAction navigateAction = null;
    private JavascriptAction menuAction = null;
    private SkinImage actionMenu;
    private Container container = new Container();

    public ResourceTableCellRenderer(IContext context) {
        this(context, false, false);
    }

    public ResourceTableCellRenderer(IContext context, boolean displayActions, boolean drillable) {
        this.actionMenu = new SkinImage("/shared/images/dropdown_arrow.gif");
        this.actionMenu.setAriaRole("button");
        this.actionMenu.setAccesssible(true);
        this.resourceIcon.setVerticalAlign("middle");
        this.resourceIcon.setBorder("0px");
        this.navigateLink.setPaddingLeft("2px");
        this.container.add((Component)this.resourceIcon);
        this.container.add((Component)this.navigateLink);
        this.navigateAction = new JavascriptAction(new StringBuffer(context.getUniqueID()).append(".navigate").toString());
        this.actionMenu.setToolTip(context.localize("IDS_ADM_TOP_ACTIONS_TOOLTIP"));
        this.menuAction = new JavascriptAction(new StringBuffer(context.getUniqueID()).append(".relationshipsObj.showActionsMenu").toString());
        this.menuAction.setPropogateEvent(true);
        this.actionMenu.setAction(this.menuAction, true);
        this.menuAction.setEventKey("ENTER");
        this.container.add((Component)this.actionMenu);
    }

    public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.container.setContext(table.getContext());
        if (value != null) {
            Resource prevResource;
            Resource resource = (Resource)value;
            this.menuAction.setArguments(new String[]{"_EVENT_", resource.getResourceId()});
            this.resourceIcon.setRelativePath(resource.getIconPath());
            String resourceTooltip = resource.getName();
            if (resource.getIconTooltip() != null) {
                resourceTooltip = resourceTooltip + " - " + resource.getIconTooltip();
            }
            this.resourceIcon.setToolTip(resourceTooltip);
            this.resourceIcon.setDisabled(resource.isHidden());
            if (resource.hasChildren()) {
                if (resource.canNavigate() && row > 0 && this.navigateAction != null) {
                    String bcDepth = table.getContext().getStateParameter("bcDepth");
                    if (bcDepth == null) {
                        bcDepth = "1";
                    }
                    this.navigateAction.setArguments(new String[]{resource.getResourceId(true), resource.getStoreId(), bcDepth});
                    this.navigateLink.setAction((IAction)this.navigateAction);
                }
            } else {
                this.navigateLink.setAction(null);
            }
            if (row == 1 && (prevResource = (Resource)table.getValue(row - 1, column)).hasChildren() && !resource.getType().equals(prevResource.getType())) {
                table.getColumn(0).indent();
            }
            this.actionMenu.setRenderable(resource.isActionsEnabled());
            this.navigateLink.setText(resource.getDetailedName());
        }
        return this.container;
    }
}

