/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.components.system;

import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.portal.producer.control.ProducerContext;
import com.cognos.admin.j2html.table.DefaultTableModel;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.ImageTableCellRenderer;
import com.cognos.admin.j2html.table.TableColumnModel;
import com.cognos.admin.portal.components.system.Resource;
import com.cognos.admin.portal.components.system.ResourceTableCellRenderer;
import com.cognos.admin.portal.components.system.summary.RSProcessTableCellRenderer;
import com.cognos.admin.portal.components.system.table.HealthIconTableCellRenderer;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.bus.xmlHandler.CMResponseXMLHandler;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class ResourceTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    protected boolean displayTenantInfo = false;
    public static final int COLUMN_IDX_RESOURCE = 0;
    public static final int COLUMN_IDX_HEALTH = 1;
    public static final int COLUMN_IDX_STATUS = 2;
    public static final int COLUMN_IDX_TENANTID = 3;
    private static final String STATUS_AVAILABLE = "Available";
    private static final String STATUS_PARTIALLY_AVAILABLE = "PartiallyAvailable";
    private static final String STATUS_UNAVAILABLE = "Unavailable";
    private static final int TABLE_COLUMN_OFFSET = 2;
    private TableColumnModel columnModel;
    private HashMap localizedState;
    private String localizedDefaultState;
    private IContext context;
    private static final String NOT_APPLICABLE = "--";
    private static final char SLASH = '/';
    private HashMap<String, String> tenantMap = null;

    public ResourceTableModel(IContext producerContext) {
        this(producerContext, 0);
    }

    public ResourceTableModel(IContext producerContext, int rowCount) {
        this(producerContext, rowCount, "true".equals(producerContext.getSessionParameter("e_showTenantInfo")) ? 4 : 3);
    }

    public ResourceTableModel(IContext producerContext, int rowCount, int colCount) {
        super(rowCount, colCount);
        this.context = producerContext;
        this.displayTenantInfo = "true".equals(producerContext.getSessionParameter("e_showTenantInfo"));
        this.initColumnModel(producerContext);
        this.initState(producerContext);
    }

    public TableColumnModel getTableColumnModel() {
        return this.columnModel;
    }

    public void setValueAt(Object value, int row, int column) {
        super.setValueAt(value, row, column + 1);
    }

    public void setResourceAt(Resource resource, int row) {
        super.setValueAt((Object)resource, row, 0);
    }

    public Object getValueAt(int row, int col) {
        if (this.tenantMap == null) {
            this.buildTenantNameLookupCache();
        }
        Resource resource = (Resource)super.getValueAt(row, 0);
        switch (col) {
            case 0: {
                return resource;
            }
            case 1: {
                return resource.getHealth();
            }
            case 2: {
                return this.getLocalizedStatus(resource.getOperationalStatus());
            }
        }
        if (this.displayTenantInfo && col == 3) {
            if (this.tenantMap != null) {
                return resource.getTenantID() != null ? this.tenantMap.get(resource.getTenantID()) : "";
            }
            return resource.getTenantID() != null ? resource.getTenantID() : "";
        }
        ITableCellRenderer renderer = this.getTableColumnModel().getColumn(col).getCellRenderer();
        if (renderer != null && RSProcessTableCellRenderer.class.getName().equals(renderer.getClass().getName())) {
            return new StringBuffer(this.getValue(super.getValueAt(row, col - this.getColumnOffset()))).append('/').append(this.getValue(this.getValueAt(row, this.getColumnCount() - 1))).toString();
        }
        return super.getValueAt(row, col - 2);
    }

    public String getTenantName(Resource resource) {
        if (this.tenantMap != null) {
            return resource.getTenantID() != null ? this.tenantMap.get(resource.getTenantID()) : "";
        }
        return resource.getTenantID() != null ? resource.getTenantID() : "";
    }

    private void buildTenantNameLookupCache() {
        HashSet<String> distinctTenantIds = new HashSet<String>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            Resource resource = (Resource)super.getValueAt(row, 0);
            if (resource.getTenantID() == null) continue;
            distinctTenantIds.add(resource.getTenantID());
        }
        if (distinctTenantIds.size() > 0) {
            StageContext sContext = ((ProducerContext)this.context).getStageContext();
            Query query = new Query();
            query.addProperty("tenantID");
            query.addProperty("defaultName");
            String searchPath = "/directory/tenants/tenant[";
            for (String tenantId : distinctTenantIds) {
                searchPath = searchPath + "@tenantID='" + this.cmEncode(tenantId) + "'";
            }
            searchPath = searchPath + "]";
            query.setSearchPath(searchPath);
            String header = sContext.getEnv().getBusHeader();
            query.setBusHeader((Object)(header != null ? header.toString() : null));
            try {
                CMResponseXMLHandler handler = new CMResponseXMLHandler();
                query.setResponseBodyHandler((IXMLHandler)handler);
                this.sendCMRequest((SOAPMessage)query, (PipelineContext)sContext, false);
                this.tenantMap = new HashMap();
                List tenantList = handler.getCMResponse().getObjectsFromQuery(0);
                for (GenericCMObject cmObj : tenantList) {
                    String tenantId = cmObj.getParameter("tenantID", null);
                    this.tenantMap.put(tenantId, cmObj.getParameter("defaultName", tenantId));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String cmEncode(String value) {
        return value.replaceAll("'", "''");
    }

    protected void initColumnModel(IContext producerContext) {
        this.columnModel = new TableColumnModel();
        TableColumn colResource = new TableColumn(0);
        this.columnModel.addColumn(colResource);
        colResource.setToolTip(producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_NAME"));
        colResource.setHeaderValue((Object)producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_NAME"));
        colResource.setCellRenderer((ITableCellRenderer)new ResourceTableCellRenderer(producerContext));
        TableColumn colHealth = new TableColumn(1);
        this.columnModel.addColumn(colHealth);
        colHealth.setToolTip(producerContext.localize("IDS_ADM_TOP_HEALTH_TOOLTIP"));
        colHealth.setHeaderValue((Object)producerContext.localize("IDS_ADM_TOP_HEALTH_TOOLTIP"));
        HealthIconTableCellRenderer healthRenderer = new HealthIconTableCellRenderer();
        colHealth.setCellRenderer((ITableCellRenderer)healthRenderer);
        colHealth.setComparator((Comparator)healthRenderer);
        colHealth.setHeaderRenderer((ITableCellRenderer)new ImageTableCellRenderer(new Image("/ps/cogadmin/images/icon_streetlight.gif")));
        TableColumn colState = new TableColumn(2);
        this.columnModel.addColumn(colState);
        colState.setToolTip(producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_STATUS"));
        colState.setHeaderValue((Object)producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_STATUS"));
        if (this.displayTenantInfo) {
            TableColumn colTenantID = new TableColumn(3);
            this.columnModel.addColumn(colTenantID);
            colTenantID.setToolTip(producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_TENANT"));
            colTenantID.setHeaderValue((Object)producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_TENANT"));
            colTenantID.setSortable(false);
        }
    }

    protected void initState(IContext producerContext) {
        this.localizedState = new HashMap();
        this.localizedState.put(STATUS_AVAILABLE, producerContext.localize("IDS_ADM_TOP_STATE_AVAILABLE"));
        this.localizedState.put(STATUS_PARTIALLY_AVAILABLE, producerContext.localize("IDS_ADM_TOP_STATE_PARTIALLY_AVAILABLE"));
        this.localizedState.put(STATUS_UNAVAILABLE, producerContext.localize("IDS_ADM_TOP_STATE_UNAVAILABLE"));
        this.localizedDefaultState = producerContext.localize("IDS_ADM_TOP_STATE_UNKNOWN");
    }

    protected int getColumnOffset() {
        return 2;
    }

    protected String getLocalizedStatus(String stateKey) {
        String state = (String)this.localizedState.get(stateKey);
        return state != null ? state : this.localizedDefaultState;
    }

    protected String getValue(Object value) {
        return value != null ? value.toString() : NOT_APPLICABLE;
    }

    protected void sendCMRequest(SOAPMessage message, PipelineContext pipelineContext, boolean trustedConnection) throws PipelineException {
        StageContext sContext = ((ProducerContext)this.context).getStageContext();
        ServiceLogger logger = sContext.getEnv().getLogger();
        SOAPConnection connection = trustedConnection ? ((SOAPConnectionFactory)pipelineContext.getEnv().getProperty("consumerTrustedSoapConnectionFactory")).createConnection(logger) : ((SOAPConnectionFactory)pipelineContext.getEnv().getProperty("SoapConnectionFactory")).createConnection(logger);
        try {
            connection.execute(message, (String)pipelineContext.getEnv().getProperty("contentManager"));
        }
        catch (MalformedURLException e) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("bad url.", (Throwable)e);
            }
            throw new PipelineException("error while retrieving object from CM", (Throwable)e);
        }
        catch (SOAPFault e) {
            String detail = e.getDetail();
            if (detail != null && detail.indexOf("CM-REQ-4159") != -1) {
                throw new InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, (Throwable)e);
            }
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("Content Manager returned a fault in the response.", (Throwable)e);
            }
            throw new PipelineException("error while retrieving object from CM", (Throwable)e);
        }
        catch (IOException e) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("Encountered an IO exception while retrieving the object from cm.", (Throwable)e);
            }
            throw new PipelineException("error while retrieving object from CM", (Throwable)e);
        }
        catch (XMLStreamException e) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("Encountered an xml stream exception while retrieving the object from cm.", (Throwable)e);
            }
            throw new PipelineException("error while retrieving object from CM", (Throwable)e);
        }
    }
}

