/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.components.system.metrics;

import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.DefaultTableCellRenderer;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.Panel;
import com.cognos.admin.j2html.ScriptComponent;
import com.cognos.admin.j2html.Table;
import com.cognos.admin.j2html.table.BooleanTableCellRenderer;
import com.cognos.admin.j2html.table.DefaultTableModel;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.ITableModel;
import com.cognos.admin.j2html.table.TableColumnFilter;
import com.cognos.admin.portal.components.system.metrics.Health;
import com.cognos.admin.portal.components.system.table.HealthIconTableCellRenderer;
import com.ibm.json.java.JSONObject;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class HealthSummary
extends Panel
implements TableModelListener {
    private TableColumnFilter cf;
    private Health m_poor;
    private Health m_average;
    private Health m_good;
    private Table summaryTable = new Table();

    public HealthSummary() {
        this(0, 0, 0);
    }

    public HealthSummary(int poor, int average, int good) {
        this.summaryTable.setWidth("");
        this.m_poor = new Health("Poor", poor);
        this.m_average = new Health("Average", average);
        this.m_good = new Health("Good", good);
        this.setPadding("5px 0 5px 0");
        this.add((Component)this.summaryTable);
    }

    public void init() {
        final DefaultTableModel dataModel = new DefaultTableModel(1, 11);
        String filter = this.getContext().getEnv().getParameter("healthFilter");
        if (filter == null) {
            this.cf = new TableColumnFilter((Object[])new String[]{"Poor", "Average", "Good", "NotApplicable", "None"}, 2);
            filter = this.cf.toString();
            this.getContext().setStateParameter("healthFilter", filter);
        } else {
            this.cf = TableColumnFilter.decode((String)filter);
        }
        dataModel.setValueAt((Object)new Boolean(filter.indexOf("Good") > -1), 0, 0);
        dataModel.setValueAt((Object)this.m_good, 0, 1);
        dataModel.setValueAt((Object)this.m_good, 0, 2);
        dataModel.setValueAt((Object)new Boolean(filter.indexOf("Average") > -1), 0, 3);
        dataModel.setValueAt((Object)this.m_average, 0, 4);
        dataModel.setValueAt((Object)this.m_average, 0, 5);
        dataModel.setValueAt((Object)new Boolean(filter.indexOf("Poor") > -1), 0, 6);
        dataModel.setValueAt((Object)this.m_poor, 0, 7);
        dataModel.setValueAt((Object)this.m_poor, 0, 8);
        dataModel.setValueAt((Object)new Boolean(filter.indexOf("NotApplicable") > -1), 0, 9);
        dataModel.setValueAt((Object)this.getContext().localize("IDS_ADM_MET_FILTER_OTHER"), 0, 10);
        HealthIconTableCellRenderer healthIconRenderer = new HealthIconTableCellRenderer();
        DefaultTableCellRenderer healthCountRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) throws J2HTMLException {
                return super.getTableCellRendererComponent(table, (Object)((Health)value).getCount(), isSelected, hasFocus, row, column);
            }
        };
        BooleanTableCellRenderer booleanRenderer = new BooleanTableCellRenderer(){

            public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put((Object)"value", (Object)(column != 9 ? dataModel.getValueAt(row, column + 1).toString().toLowerCase() : "other"));
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        };
        this.summaryTable.setModel((ITableModel)dataModel);
        this.summaryTable.getColumn(2).setCellRenderer((ITableCellRenderer)healthCountRenderer);
        this.summaryTable.getColumn(5).setCellRenderer((ITableCellRenderer)healthCountRenderer);
        this.summaryTable.getColumn(8).setCellRenderer((ITableCellRenderer)healthCountRenderer);
        this.summaryTable.getColumn(1).setCellRenderer((ITableCellRenderer)healthIconRenderer);
        this.summaryTable.getColumn(4).setCellRenderer((ITableCellRenderer)healthIconRenderer);
        this.summaryTable.getColumn(7).setCellRenderer((ITableCellRenderer)healthIconRenderer);
        this.summaryTable.getColumn(0).setCellRenderer((ITableCellRenderer)booleanRenderer);
        this.summaryTable.getColumn(3).setCellRenderer((ITableCellRenderer)booleanRenderer);
        this.summaryTable.getColumn(6).setCellRenderer((ITableCellRenderer)booleanRenderer);
        this.summaryTable.getColumn(9).setCellRenderer((ITableCellRenderer)booleanRenderer);
        this.summaryTable.getTableHeader().hide(true);
        this.add((Component)new ScriptComponent("initFilter(" + this.getContext().getUniqueID() + ",'" + this.cf + "');"));
    }

    public TableColumnFilter getFilter() {
        return this.cf;
    }

    public int getPoorCount() {
        return this.m_poor.count;
    }

    public void setPoorCount(int count) {
        this.m_poor.count = count;
    }

    public int getAverageCount() {
        return this.m_average.count;
    }

    public void setAverageCount(int count) {
        this.m_average.count = count;
    }

    public int getGoodCount() {
        return this.m_good.count;
    }

    public void setGoodCount(int count) {
        this.m_good.count = count;
    }

    public int adjustGoodCount(int offset) {
        return this.m_good.count += offset;
    }

    public int adjustAverageCount(int offset) {
        return this.m_average.count += offset;
    }

    public int adjustPoorCount(int offset) {
        return this.m_poor.count += offset;
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        TableModel model = (TableModel)evt.getSource();
        int offset = 1;
        if (evt.getType() == -1) {
            offset = -1;
        }
        for (int row = evt.getFirstRow(); row > 0 && row <= evt.getLastRow(); ++row) {
            String health = (String)model.getValueAt(row, 1);
            if (health.equals("Good")) {
                this.adjustGoodCount(offset);
                continue;
            }
            if (health.equals("Average")) {
                this.adjustAverageCount(offset);
                continue;
            }
            if (!health.equals("Poor")) continue;
            this.adjustPoorCount(offset);
        }
    }
}

