/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.components.system.metrics;

import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.Container;
import com.cognos.admin.j2html.ControlledComponent;
import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.Label;
import com.cognos.admin.j2html.Menu;
import com.cognos.admin.j2html.MenuItem;
import com.cognos.admin.j2html.Panel;
import com.cognos.admin.j2html.Table;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.table.DefaultTableModel;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.ITableModel;
import com.cognos.admin.j2html.table.ImageTableCellRenderer;
import com.cognos.admin.portal.components.system.Property;
import com.cognos.admin.portal.components.system.metrics.EditThresholdsTableCellRenderer;
import com.cognos.admin.portal.components.system.metrics.HealthSummary;
import com.cognos.admin.portal.components.system.table.HealthIconTableCellRenderer;
import java.util.Collection;
import java.util.Comparator;

public class MetricsComponent
extends ControlledComponent {
    public static final int METRIC_NAME_COL_IDX = 0;
    public static final int METRIC_HEALTH_COL_IDX = 1;
    public static final int METRIC_VALUE_COL_IDX = 2;
    public static final int METRIC_PROPERTY_COL_IDX = 3;
    private HealthSummary healthSummary;

    public MetricsComponent(IContext context, Collection groupModels, HealthSummary healthSummary) throws J2HTMLException {
        super(context);
        if (healthSummary == null) {
            healthSummary = new HealthSummary();
        }
        this.add((Component)healthSummary);
        ImageTableCellRenderer streetLightIcon = new ImageTableCellRenderer(new Image("/ps/cogadmin/images/icon_streetlight.gif"));
        DefaultTableModel groupTableModel = new DefaultTableModel();
        groupTableModel.setColumnIdentifiers((Object[])new String[]{context.localize("IDS_ADM_TOP_TABLE_HEADER_NAME"), context.localize("IDS_ADM_MET_HEALTH_TOOLTIP"), context.localize("IDS_ADM_SET_TABLE_HEADER_VALUE")});
        groupTableModel.setColumnCount(4);
        Table metricsTable = new Table((ITableModel)groupTableModel);
        metricsTable.setID("contentTable");
        metricsTable.getTableHeader().setCollapsable(true);
        metricsTable.setSortable(true);
        metricsTable.setFilterable(true);
        metricsTable.setDisplayEmptyTableText(false);
        metricsTable.setTextAlign("left");
        TableColumn nameColumn = metricsTable.getColumn(0);
        TableColumn healthColumn = metricsTable.getColumn(1);
        TableColumn valueColumn = metricsTable.getColumn(2);
        valueColumn.setSortable(false);
        TableColumn propertyColumn = metricsTable.getColumn(3);
        propertyColumn.setVisible(false);
        nameColumn.setCellRenderer((ITableCellRenderer)new EditThresholdsTableCellRenderer());
        healthColumn.setFilter(healthSummary.getFilter());
        HealthIconTableCellRenderer healthRenderer = new HealthIconTableCellRenderer();
        healthColumn.setCellRenderer((ITableCellRenderer)healthRenderer);
        healthColumn.setComparator((Comparator)healthRenderer);
        Panel metricsPanel = new Panel();
        metricsPanel.setHeight("250px");
        Panel metricsInnerPanel = new Panel();
        this.add((Component)metricsPanel);
        metricsPanel.add((Component)metricsInnerPanel);
        metricsInnerPanel.add((Component)metricsTable);
        TableColumn grpColumnName = metricsTable.getColumn(0);
        grpColumnName.setWidth("100%");
        TableColumn grpColumnHealth = metricsTable.getColumn(1);
        grpColumnHealth.setHeaderRenderer((ITableCellRenderer)streetLightIcon);
        try {
            GroupTableHeaderRenderer renderer = new GroupTableHeaderRenderer();
            for (ITableModel model : groupModels) {
                Table groupTable = new Table(model);
                TableColumn subTableNameColumn = groupTable.getColumnModel().getColumn(0);
                subTableNameColumn.setHeaderRenderer((ITableCellRenderer)renderer);
                metricsTable.addSubTable(groupTable);
            }
        }
        catch (Exception e) {
            throw new J2HTMLException((Throwable)e);
        }
    }

    public HealthSummary getHealthSummary() {
        return this.healthSummary;
    }

    public String getTargetURI() {
        return null;
    }

    public int getDepth() {
        return 0;
    }

    public int getNumRow() {
        return 2;
    }

    private class GroupTableHeaderRenderer
    implements ITableCellRenderer {
        Container container = new Container();
        Label groupLabel = new Label();
        Menu resetMenu = new Menu();
        MenuItem resetMenuItem = new MenuItem();

        public GroupTableHeaderRenderer() throws J2HTMLException {
            this.resetMenu.addMenuItem(this.resetMenuItem);
            this.resetMenuItem.setIconPath("/ps/cogadmin/images/action_reset_module.gif");
            this.container.add((Component)this.groupLabel);
            this.container.add((Component)this.resetMenu);
        }

        public Component getTableCellRendererComponent(Table table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String groupName = (String)value;
            this.groupLabel.setText(groupName);
            ITableModel groupModel = table.getModel();
            for (int i = 0; i < groupModel.getRowCount(); ++i) {
                Property prop = (Property)groupModel.getValueAt(row, 3);
                String canBeReset = prop.getAttribute("CanBeReset");
                boolean renderable = canBeReset != null && canBeReset.equals("true");
                this.resetMenu.setRenderable(renderable);
                if (renderable) break;
            }
            return this.container;
        }
    }
}

