/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.policy.common;

import com.cognos.admin.common.BusRequestHelper;
import com.cognos.admin.j2html.portal.producer.common.ProducerUtils;
import com.cognos.admin.portal.producer.process.policy.common.Utils;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.helpers.ContextImpl;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public abstract class PoliciesQuery {
    static final String SOAP_TARGET = "bus://cm";
    static final String SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201904/";
    private static final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final String CM_NAMESPACE_URI = "http://developer.cognos.com/schemas/bibus/3/";
    private static final String XSD_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";

    public String makeRequest(StageContext stageContext) throws BaseFaultType, IOException, DocumentException {
        ContextImpl context = new ContextImpl();
        context.setProperty("PRODUCT_LOCALE", (Object)stageContext.getEnv().getProductLocale());
        context.setProperty("CONTENT_LOCALE", (Object)stageContext.getEnv().getContentLocale());
        context.setProperty("BUS_HEADER", (Object)stageContext.getBusHeader());
        String policiesResponse = this.queryPolicies((IContext)context, Utils.getObject(stageContext));
        String sAcquired = ProducerUtils.getControllerAttributeValue((StageContext)stageContext, (String)"acquired");
        if (sAcquired != null && sAcquired.equals("true")) {
            policiesResponse = this.updatePoliciesFromParent((IContext)context, policiesResponse);
        }
        return policiesResponse;
    }

    private String queryPolicies(IContext context, String sObject) throws BaseFaultType, IOException {
        String request = this.makePolicyRequest(sObject);
        Reader response = BusRequestHelper.makeBusRequest((IContext)context, (String)request, (String)SOAP_TARGET, (String)SOAP_ACTION, (boolean)false, (boolean)false);
        return IOUtils.toString((Reader)response);
    }

    private String updatePoliciesFromParent(IContext context, String policiesResponse) throws BaseFaultType, IOException, DocumentException {
        Node policiesNode;
        Element policiesResponseElement = DocumentHelper.parseText((String)policiesResponse).getRootElement();
        String sObject = this.getParentObject(policiesResponseElement);
        Element rootElement = DocumentHelper.parseText((String)this.queryPolicies(context, sObject)).getRootElement();
        Node policiesValue = rootElement.selectSingleNode("/cm:queryResponse/queryResult/item/" + this.getPropertyName() + "/value");
        if (null != policiesValue) {
            policiesValue.detach();
        }
        if ((policiesNode = policiesResponseElement.selectSingleNode("/cm:queryResponse/queryResult/item/" + this.getPropertyName())) != null && policiesNode.getNodeType() == 1) {
            Element policiesElement = (Element)policiesNode;
            policiesElement.selectSingleNode("schemaInfo/acquired").setText("true");
            policiesElement.remove(policiesElement.element("value"));
            if (null != policiesValue) {
                policiesElement.add(policiesValue);
            }
        }
        return policiesResponseElement.asXML();
    }

    public String updatePolicies(String policiesResponse, String editedPolicies) throws DocumentException, IOException {
        HashMap<String, JSONObject> policesMap = new HashMap<String, JSONObject>();
        HashMap<String, Boolean> updatedMap = new HashMap<String, Boolean>();
        JSONArray policiesArray = JSONArray.parse((String)editedPolicies);
        for (int i = 0; i < policiesArray.size(); ++i) {
            JSONObject securityObject = (JSONObject)policiesArray.get(i);
            String sStoreID = (String)securityObject.get((Object)"key");
            policesMap.put(sStoreID, securityObject);
            updatedMap.put(sStoreID, Boolean.FALSE);
        }
        Element policiesResponseElement = DocumentHelper.parseText((String)policiesResponse).getRootElement();
        Node userCapabilityPoliciesNode = policiesResponseElement.selectSingleNode("//" + this.getPropertyName());
        if (userCapabilityPoliciesNode != null && userCapabilityPoliciesNode.getNodeType() == 1) {
            Node userCapabilityPoliciesValueNode;
            Element userCapabilityPoliciesElem = (Element)userCapabilityPoliciesNode;
            Node acquiredNode = userCapabilityPoliciesElem.selectSingleNode("schemaInfo/acquired");
            if (acquiredNode != null) {
                acquiredNode.setText("false");
            }
            if (null == (userCapabilityPoliciesValueNode = userCapabilityPoliciesElem.selectSingleNode("value")) && !updatedMap.isEmpty()) {
                userCapabilityPoliciesValueNode = DocumentHelper.createElement((String)"value");
                userCapabilityPoliciesElem.add(userCapabilityPoliciesValueNode);
            }
            if (userCapabilityPoliciesValueNode != null && userCapabilityPoliciesValueNode.getNodeType() == 1) {
                Element userCapabilityPoliciesValueElem = (Element)userCapabilityPoliciesValueNode;
                List policyNodes = userCapabilityPoliciesValueElem.selectNodes("item[@xsi:type='cm:policy']");
                for (Node node : policyNodes) {
                    Element policyElement = node.getNodeType() == 1 ? (Element)node : null;
                    if (policyElement == null) continue;
                    Node securityObjectNode = policyElement.selectSingleNode("securityObject|item");
                    String storeID = securityObjectNode.selectSingleNode("storeID/value").getText().trim();
                    Object securityObject = policesMap.get(storeID);
                    if (securityObject != null) {
                        Element permissions = policyElement.element("permissions");
                        if (permissions != null) {
                            policyElement.remove(permissions);
                        }
                        policyElement.add(this.createPermissions((JSONArray)((JSONObject)securityObject).get((Object)"privilege")));
                    } else {
                        userCapabilityPoliciesValueElem.remove(policyElement);
                    }
                    updatedMap.put(storeID, Boolean.TRUE);
                }
                for (Map.Entry entry : updatedMap.entrySet()) {
                    if (!entry.getValue().equals(Boolean.FALSE)) continue;
                    userCapabilityPoliciesValueElem.add(this.createPolicy((JSONObject)policesMap.get(entry.getKey())));
                }
            }
        }
        return policiesResponseElement.asXML();
    }

    private Element createPermissions(JSONArray permissionsArray) throws DocumentException {
        Element result = DocumentHelper.createElement((String)"permissions");
        for (int j = 0; permissionsArray != null && j < permissionsArray.size(); ++j) {
            JSONObject permObj = (JSONObject)permissionsArray.get(j);
            String sAccess = (String)permObj.get((Object)"flag");
            if (sAccess == null || sAccess.length() == 0) continue;
            Element item = DocumentHelper.createElement((String)"item");
            Element userCapability = item.addElement(this.getPermissionsName());
            userCapability.setText((String)permObj.get((Object)"name"));
            sAccess = sAccess.equals("y") ? "grant" : "deny";
            Element access = item.addElement("access");
            access.setText(sAccess);
            result.add(item);
        }
        return result;
    }

    private Element createPolicy(JSONObject securityObject) throws DocumentException {
        Element result = DocumentHelper.createElement((String)"item");
        result.addAttribute(new QName("type", new Namespace("xsi", XSI_NAMESPACE_URI)), "cm:policy");
        Element securityObj = result.addElement("securityObject");
        Element defaultName = securityObj.addElement("defaultName");
        Element defaultNameValue = defaultName.addElement("value");
        defaultNameValue.setText((String)securityObject.get((Object)"defaultName"));
        Element objectClass = securityObj.addElement("objectClass");
        Element objectClassValue = objectClass.addElement("value");
        objectClassValue.setText((String)securityObject.get((Object)"objectClass"));
        Element storeID = securityObj.addElement("storeID");
        Element storeIDValue = storeID.addElement("value");
        storeIDValue.setText((String)securityObject.get((Object)"key"));
        Element ancestors = securityObj.addElement("ancestors");
        Element ancestorsValue = ancestors.addElement("value");
        String sPath = (String)securityObject.get((Object)"path");
        String[] ancestorsTokens = sPath.split(">");
        for (int i = 0; i < ancestorsTokens.length; ++i) {
            Element item = ancestorsValue.addElement("item");
            Element title = item.addElement("title");
            title.setText(ancestorsTokens[i]);
        }
        Element iconURI = securityObj.addElement("iconURI");
        iconURI.setText((String)securityObject.get((Object)"iconURI"));
        return result;
    }

    protected abstract String getPropertyName();

    protected abstract String getPermissionsName();

    protected String getParentObject(Element policiesResponseElement) {
        String ancestorSearchPath;
        block0: {
            ancestorSearchPath = "/";
            List ancestorNodes = policiesResponseElement.selectNodes("/cm:queryResponse/queryResult/item/ancestors/value/item[@xsi:type='cm:ancestorInfo']");
            ListIterator iterator = ancestorNodes.listIterator(ancestorNodes.size());
            if (!iterator.hasPrevious()) break block0;
            Node ancestor = (Node)iterator.previous();
            ancestorSearchPath = ancestor.selectSingleNode("searchPath").getText().trim();
        }
        return ancestorSearchPath;
    }

    String makePolicyRequest(String searchPath) throws BaseFaultType {
        StringWriter writer = new StringWriter();
        try {
            XMLStreamWriter streamWriter = XMLStreamFactory.createXMLStreamWriter((Writer)writer);
            streamWriter.writeStartElement("cm", "query", CM_NAMESPACE_URI);
            streamWriter.writeNamespace("xsi", XSI_NAMESPACE_URI);
            streamWriter.writeNamespace("SOAP-ENC", SOAP_NAMESPACE_URI);
            streamWriter.writeNamespace("xsd", XSD_NAMESPACE_URI);
            this.writeSearchPath(streamWriter, searchPath);
            this.writeProperties(streamWriter, this.getRequestedProperties());
            this.writeOptions(streamWriter);
            streamWriter.writeEndElement();
            streamWriter.flush();
        }
        catch (Exception e) {
            throw new BaseFaultType("Failed to create the policy request", (Throwable)e);
        }
        return writer.toString();
    }

    String[] getRequestedProperties() {
        return new String[]{"defaultName", "objectClass", "storeID", "permissions", "modificationTime", "ancestors", this.getPropertyName()};
    }

    OptionsProperty[] getRequestedSimpleOptionsProperties() {
        return new OptionsProperty[]{new OptionsProperty("schemaInfo", "xsd:boolean", "true")};
    }

    String[] getRequestedOptionsRefProperties() {
        return new String[]{"defaultName", "objectClass", "storeID", "ancestors", "iconURI"};
    }

    private void writeSearchPath(XMLStreamWriter streamWriter, String searchPath) throws XMLStreamException {
        streamWriter.writeStartElement("search");
        streamWriter.writeAttribute(XSI_NAMESPACE_URI, "type", "xsd:string");
        streamWriter.writeCharacters(searchPath);
        streamWriter.writeEndElement();
    }

    private void writeProperties(XMLStreamWriter streamWriter, String[] names) throws XMLStreamException {
        streamWriter.writeStartElement("properties");
        streamWriter.writeAttribute(XSI_NAMESPACE_URI, "type", "SOAP-ENC:Array");
        for (String name : names) {
            streamWriter.writeStartElement("item");
            streamWriter.writeAttribute(XSI_NAMESPACE_URI, "type", "cm:propEnum");
            streamWriter.writeCharacters(name);
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    private void writeOptions(XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement("options");
        streamWriter.writeAttribute(XSI_NAMESPACE_URI, "type", "cm:queryOptions");
        for (OptionsProperty property : this.getRequestedSimpleOptionsProperties()) {
            streamWriter.writeStartElement(property.getName());
            streamWriter.writeAttribute(XSI_NAMESPACE_URI, "type", property.getType());
            streamWriter.writeCharacters(property.getValue());
            streamWriter.writeEndElement();
        }
        streamWriter.writeStartElement("refProps");
        streamWriter.writeAttribute(XSI_NAMESPACE_URI, "type", "SOAP-ENC:Array");
        streamWriter.writeStartElement("item");
        streamWriter.writeAttribute(XSI_NAMESPACE_URI, "type", "cm:refProp");
        streamWriter.writeStartElement("refPropName");
        streamWriter.writeAttribute(XSI_NAMESPACE_URI, "type", "cm:propEnum");
        streamWriter.writeCharacters(this.getPropertyName());
        streamWriter.writeEndElement();
        this.writeProperties(streamWriter, this.getRequestedOptionsRefProperties());
        streamWriter.writeEndElement();
        streamWriter.writeEndElement();
        streamWriter.writeEndElement();
    }

    static class OptionsProperty {
        private String name = null;
        private String type = null;
        private String value = null;

        public OptionsProperty(String name, String type, String value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

