/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.policy.common;

import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.table.DefaultTableModel;
import com.cognos.admin.portal.components.policy.PolicyMetaData;
import com.cognos.admin.portal.components.policy.PolicyMetaDataList;
import com.cognos.portal.xml.stream.PathIterator;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class UserPolicyTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;

    public UserPolicyTableModel(HashSet<String> grantedPolicies, XMLStreamReader policyMetadataStream, boolean bObjectLevelPoliciesOnly) throws J2HTMLException {
        try {
            this.setColumnCount(this.getNumCols());
            PolicyMetaDataList policyMetaDataList = this.buildPolicyMetaDataList(policyMetadataStream, bObjectLevelPoliciesOnly);
            policyMetaDataList.filterPolicies(grantedPolicies);
            this.populateDataModel(policyMetaDataList.iterator(true));
        }
        catch (XMLStreamException e) {
            throw new J2HTMLException((Throwable)e);
        }
    }

    public Object getValueAt(int row, int col) {
        this.getRowCount();
        PolicyMetaData policy = (PolicyMetaData)super.getValueAt(row, 0);
        switch (col) {
            case 0: {
                return policy;
            }
            case 1: {
                return policy.getTitle();
            }
        }
        return policy.isGranted();
    }

    public static HashSet<String> buildGrantedPolicyList(XMLStreamReader policyStream, String xPath) throws J2HTMLException {
        HashSet<String> grantedPolicies = null;
        if (policyStream != null) {
            PathIterator policies = new PathIterator(policyStream, new String[]{xPath});
            grantedPolicies = new HashSet<String>();
            try {
                while (policies.moveToNextPath() != -1) {
                    grantedPolicies.add(policies.getElementText());
                }
            }
            catch (XMLStreamException e) {
                throw new J2HTMLException((Throwable)e);
            }
        }
        return grantedPolicies;
    }

    private PolicyMetaDataList buildPolicyMetaDataList(XMLStreamReader streamReader, boolean bObjectLevelPoliciesOnly) throws XMLStreamException {
        PolicyMetaDataList policyMetaDataList = new PolicyMetaDataList();
        policyMetaDataList.loadFromXML(streamReader);
        if (bObjectLevelPoliciesOnly) {
            policyMetaDataList.filterGlobalPolicies();
        }
        return policyMetaDataList;
    }

    private void populateDataModel(Iterator<PolicyMetaData> policyMetaDataIterator) {
        while (policyMetaDataIterator.hasNext()) {
            PolicyMetaData policy = policyMetaDataIterator.next();
            policy.setLastSibling(!policyMetaDataIterator.hasNext());
            policy.setGranted(true);
            this.addRow(new PolicyMetaData[]{policy});
            this.populateDataModel(policy.getChildPolicies(true));
        }
    }

    protected abstract boolean isShowingOnlyGrantedPolicies();

    protected abstract int getNumCols();
}

