/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.policy.global_capabilities;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.portal.producer.process.policy.common.SecurityObject;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.PathIterator;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class GlobalPoliciesCapabilities
extends Stage {
    private static String ROOT_CAPABILITIES = "/queryResponse/returns/item/queryResult";
    private static String ROOT_SECURITYOBJECTS = ROOT_CAPABILITIES + "/item/policies/value/item";
    private static String ROOT_CAPABILITY_POLICIES = ROOT_CAPABILITIES + "/item/policies/value/item/permissions";
    private static XMLStreamWriter xmlWriter = null;

    public GlobalPoliciesCapabilities(ServiceLogger logger) {
        super(logger);
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        XMLStreamReader staxCapabilityPoliciesReader = context.getInputAsXMLStreamReader("capabilitiesResponse");
        try {
            int index;
            HashMap<String, SecurityObject> securityObjects = new HashMap<String, SecurityObject>();
            PathIterator policiesIter = new PathIterator(staxCapabilityPoliciesReader, new String[]{ROOT_CAPABILITIES + "/item/userCapability/value", ROOT_SECURITYOBJECTS + "/securityObject/storeID/value", ROOT_SECURITYOBJECTS + "/securityObject/objectClass/value", ROOT_SECURITYOBJECTS + "/securityObject/defaultName/value", ROOT_SECURITYOBJECTS + "/securityObject/iconURI/value", ROOT_CAPABILITY_POLICIES, ROOT_CAPABILITY_POLICIES + "/item/name", ROOT_CAPABILITY_POLICIES + "/item/access"});
            String value = null;
            SecurityObject securityObject = null;
            String userCapability = null;
            String objectClass = null;
            String permissionName = null;
            while ((index = policiesIter.moveToNextPath()) != -1) {
                switch (index) {
                    case 0: {
                        userCapability = policiesIter.getElementText();
                        break;
                    }
                    case 1: {
                        value = policiesIter.getElementText();
                        securityObject = (SecurityObject)securityObjects.get(value);
                        if (securityObject == null) {
                            securityObject = new SecurityObject();
                        }
                        securityObjects.put(value, securityObject);
                        if (objectClass != null) {
                            securityObject.setObjectClass(objectClass);
                            securityObject.setIcon();
                            objectClass = null;
                        }
                        securityObject.setStoreID(value);
                        break;
                    }
                    case 2: {
                        objectClass = policiesIter.getElementText();
                        break;
                    }
                    case 3: {
                        value = policiesIter.getElementText();
                        securityObject.setDefaultName(value);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        securityObject.addPermission(userCapability, "deny");
                        break;
                    }
                    case 6: {
                        permissionName = policiesIter.getElementText();
                        break;
                    }
                    case 7: {
                        value = policiesIter.getElementText();
                        if (!value.equals("grant") || !permissionName.equals("execute")) break;
                        securityObject.addCapability(userCapability, "grant");
                    }
                }
            }
            IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
            xmlWriter = output.getXMLStreamWriter();
            this.writeStartElement("policies");
            this.writeStartElement("feed");
            if (!securityObjects.isEmpty()) {
                for (String key : securityObjects.keySet()) {
                    SecurityObject obj = (SecurityObject)securityObjects.get(key);
                    this.writeStartElement("entry");
                    this.writeStartEndElement("title", obj.getDefaultName());
                    this.writeStartEndElement("storeID", obj.getStoreID());
                    this.writeStartEndElement("objectClass", obj.getObjectClass());
                    this.writeStartEndElement("icon", obj.getIcon());
                    this.writeStartElement("permissions");
                    HashMap permissions = obj.getCapabilities();
                    for (String kPerm : permissions.keySet()) {
                        String perm = (String)permissions.get(kPerm);
                        xmlWriter.writeStartElement("permission");
                        xmlWriter.writeAttribute("type", kPerm);
                        xmlWriter.writeCharacters(perm);
                        xmlWriter.writeEndElement();
                    }
                    this.writeEndElement();
                    this.writeEndElement();
                }
            }
            this.writeEndElement();
            this.writeEndElement();
            xmlWriter.flush();
            xmlWriter.close();
            context.addOutput("policies", output);
        }
        catch (XMLStreamException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PipelineException e) {
            CogAdminLogger.getInstance().error("executeImpl", (Throwable)e);
            throw e;
        }
    }

    private void writeStartElement(String name) throws XMLStreamException {
        xmlWriter.writeStartElement(name);
    }

    private void writeStartEndElement(String name, String value) throws XMLStreamException {
        xmlWriter.writeStartElement(name);
        xmlWriter.writeCharacters(value);
        xmlWriter.writeEndElement();
    }

    private void writeEndElement() throws XMLStreamException {
        xmlWriter.writeEndElement();
    }

    public boolean canShare() {
        return false;
    }
}

