/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.request;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.j2html.portal.producer.control.BaseJ2htmlStage;
import com.cognos.admin.portal.producer.process.request.CopyXMLHandler;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.bus.BusCommand;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputImpl;
import javax.xml.stream.XMLStreamWriter;

public abstract class BusRequestStage
extends BaseJ2htmlStage {
    public BusRequestStage(ServiceLogger logger) {
        super(logger);
    }

    public void executeImpl(StageContext context) throws PipelineException {
        PipelineOutputImpl output = new PipelineOutputImpl();
        context.addOutput("response", (IPipelineOutput)output);
        IXMLHandler bodyHandler = this.getResponseBodyHandler(context, output.getXMLStreamWriter());
        IXMLHandler faultHandler = this.getResponseFaultHandler(context, output.getXMLStreamWriter());
        BusCommand busCommand = this.getBusCommand(context);
        busCommand.setResponseBodyHandler(bodyHandler);
        busCommand.setResponseFaultHandler(faultHandler);
        busCommand.setBusHeader((Object)context.getEnv().getBusHeader());
        SOAPConnection connection = ((SOAPConnectionFactory)context.getEnv().getProperty("SoapConnectionFactory")).createConnection(context.getEnv().getLogger());
        try {
            connection.execute((SOAPMessage)busCommand, this.getTargetURI(context));
        }
        catch (Throwable t) {
            CogAdminLogger.getInstance().error(t.getMessage(), t);
            this.processExecutionError(t, context);
        }
    }

    protected IXMLHandler getResponseBodyHandler(StageContext context, XMLStreamWriter streamWriter) {
        return new CopyXMLHandler(streamWriter);
    }

    protected IXMLHandler getResponseFaultHandler(StageContext context, XMLStreamWriter streamWriter) {
        return new CopyXMLHandler(streamWriter);
    }

    protected String getTargetURI(StageContext context) {
        return (String)context.getEnv().getProperty("internalDispatcher");
    }

    protected String getGlobalErrorId() {
        return "IDS_ERROR_IN_XML_STAGE";
    }

    public abstract BusCommand getBusCommand(StageContext var1) throws PipelineException;

    public boolean canShare() {
        return false;
    }
}

