/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.system.datastores;

import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.TableColumnModel;
import com.cognos.admin.portal.components.system.Resource;
import com.cognos.admin.portal.components.system.ResourceTableCellRenderer;
import com.cognos.admin.portal.components.system.ResourceTableModel;

public class DatastoresResourceTableModel
extends ResourceTableModel {
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_IDX_RESOURCE = 0;
    public static final int COLUMN_IDX_STATUS = 1;
    public static final int COLUMN_IDX_TENANTID = 2;
    private static final int TABLE_COLUMN_OFFSET = 1;
    private TableColumnModel columnModel;

    public DatastoresResourceTableModel(IContext producerContext) {
        this(producerContext, 0);
    }

    public DatastoresResourceTableModel(IContext producerContext, int rowCount) {
        super(producerContext, rowCount, "true".equals(producerContext.getSessionParameter("e_showTenantInfo")) ? 3 : 2);
    }

    @Override
    public TableColumnModel getTableColumnModel() {
        return this.columnModel;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Resource resource = (Resource)super.getValueAt(row, 0);
        switch (col) {
            case 0: {
                return resource;
            }
            case 1: {
                return this.getLocalizedStatus(resource.getOperationalStatus());
            }
            case 2: {
                return this.getTenantName(resource);
            }
        }
        return super.getValueAt(row, col);
    }

    @Override
    protected void initColumnModel(IContext producerContext) {
        this.columnModel = new TableColumnModel();
        TableColumn colResource = new TableColumn(0);
        this.columnModel.addColumn(colResource);
        colResource.setToolTip(producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_NAME"));
        colResource.setHeaderValue((Object)producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_NAME"));
        colResource.setCellRenderer((ITableCellRenderer)new ResourceTableCellRenderer(producerContext));
        TableColumn colState = new TableColumn(1);
        this.columnModel.addColumn(colState);
        colState.setToolTip(producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_STATUS"));
        colState.setHeaderValue((Object)producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_STATUS"));
        if (this.displayTenantInfo) {
            TableColumn colTenantID = new TableColumn(2);
            this.columnModel.addColumn(colTenantID);
            colTenantID.setToolTip(producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_TENANT"));
            colTenantID.setHeaderValue((Object)producerContext.localize("IDS_ADM_ACT_TABLE_HEADER_TENANT"));
            colTenantID.setSortable(false);
        }
    }

    @Override
    protected int getColumnOffset() {
        return 1;
    }
}

