/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.system.metrics;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IMessagesManager;
import com.cognos.admin.j2html.portal.producer.common.ProducerUtils;
import com.cognos.admin.j2html.portal.producer.control.J2HTMLRenderStage;
import com.cognos.admin.j2html.portal.producer.control.ProducerContext;
import com.cognos.admin.portal.common.messages.MessagesManagerFacade;
import com.cognos.admin.portal.producer.process.system.metrics.TemplatesView;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.PipelineException;
import java.util.Enumeration;
import javax.xml.stream.XMLStreamException;

public class MetricsView
extends J2HTMLRenderStage {
    private static final String METRICS_FRAG_URI = "/cogadmin/metrics.xts";

    public MetricsView(ServiceLogger logger) {
        super(logger);
    }

    public boolean canShare() {
        return false;
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        super.executeImpl(context);
        try {
            if (MetricsView.isActiveView(context)) {
                Parameters params = new Parameters();
                Enumeration keys = context.getEnv().getParameterNames();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement().toString();
                    String value = context.getEnv().getParameter(key);
                    params.add(key, value);
                }
                Fragment xtsFrag = ProducerUtils.getXTSFragment((StageContext)context, (String)METRICS_FRAG_URI, (Parameters)params);
                Fragment thisFrag = context.getFragment();
                thisFrag.addMarkup(xtsFrag.getMarkup(0));
                thisFrag.setPreferredTitle(xtsFrag.getPreferredTitle());
            }
            ProducerContext pContext = new ProducerContext(context, (IMessagesManager)new MessagesManagerFacade());
            ProducerUtils.addStateParameter((IContext)pContext, (String)"rootRelationshipType", (String[])new String[]{"rootRelationshipType", "selectedRelationshipType", "relationshipType"}, null);
        }
        catch (XMLStreamException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (DashboardException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (LocalizableException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static boolean isActiveView(StageContext context) throws LocalizableException {
        return !TemplatesView.isActiveView(context);
    }
}

