/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.system.metrics;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.j2html.ControlledComponent;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IMessagesManager;
import com.cognos.admin.j2html.portal.producer.common.ProducerUtils;
import com.cognos.admin.j2html.portal.producer.control.ProducerContext;
import com.cognos.admin.j2html.table.DefaultTableModel;
import com.cognos.admin.portal.common.messages.MessagesManagerFacade;
import com.cognos.admin.portal.components.system.Property;
import com.cognos.admin.portal.components.system.templates.metrics.MetricsComponent;
import com.cognos.admin.portal.producer.process.system.scorecard.AbstractScorecardView;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.PathIterator;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TemplatesView
extends Stage {
    private static final String root = "/response/metadataAndDataResponse/Resource/PropertiesGroup";

    public TemplatesView(ServiceLogger logger) {
        super(logger);
    }

    public boolean canShare() {
        return false;
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        try {
            ProducerContext producerContext = new ProducerContext(context, (IMessagesManager)new MessagesManagerFacade());
            if (TemplatesView.isActiveView(context)) {
                XMLStreamReader staxReader = context.getInputAsXMLStreamReader("metadataAndDataResponse");
                TreeMap<String, DefaultTableModel> groups = new TreeMap<String, DefaultTableModel>();
                if (staxReader != null) {
                    PathIterator iter = new PathIterator(staxReader, new String[]{root, "/response/metadataAndDataResponse/Resource/PropertiesGroup/Property/Value", "/response/metadataAndDataResponse/Resource/PropertiesGroup/Property/Description", "/response/metadataAndDataResponse/Resource/PropertiesGroup/Property/Caption", "/response/metadataAndDataResponse/Resource/PropertiesGroup/Property/CanSetThreshold", "/response/metadataAndDataResponse/Resource/PropertiesGroup/Property/Name", "/response/metadataAndDataResponse/Resource/PropertiesGroup/Property/Type", "/response/metadataAndDataResponse/Resource/PropertiesGroup/Property/CanBeReset", "/response/metadataAndDataResponse/Resource/PropertiesGroup/Property/MetricGroup"});
                    int i = iter.moveToNextPath();
                    while (i != -1) {
                        String caption = null;
                        boolean canSetThreshold = false;
                        DefaultTableModel model = new DefaultTableModel();
                        if (i != 0 || !iter.moveToNextPath("/Caption")) continue;
                        Property metricProp = new Property();
                        String groupName = iter.getElementText();
                        metricProp.setAttribute("GroupName", groupName);
                        iter.moveToNextPath("/Description");
                        model.setColumnIdentifiers(new Object[]{groupName, iter.getElementText()});
                        i = iter.moveToNextPath();
                        while (i > 0) {
                            String name = iter.getLocalName();
                            if (name.equals("Caption")) {
                                caption = iter.getElementText();
                                metricProp.setAttribute(name, caption);
                            } else if (name.equals("CanSetThreshold")) {
                                canSetThreshold = Boolean.valueOf(iter.getElementText());
                            } else {
                                metricProp.setAttribute(name, iter.getElementText());
                            }
                            if (iter.isStartElement()) {
                                metricProp.setAttribute(name, iter.getElementText());
                            }
                            if (i == 1) {
                                if (canSetThreshold) {
                                    model.addRow(new Object[]{caption, metricProp});
                                }
                                metricProp = new Property();
                                metricProp.setAttribute("GroupName", groupName);
                            }
                            i = iter.moveToNextPath();
                        }
                        if (model.getRowCount() <= 0) continue;
                        groups.put(groupName, model);
                    }
                }
                MetricsComponent metricsComponent = new MetricsComponent((IContext)producerContext, groups.values(), null);
                producerContext.render((ControlledComponent)metricsComponent);
                String resourceLabel = context.getEnv().getParameter("resourceLabel");
                context.getFragment().setPreferredTitle(producerContext.localize("IDS_ADM_MET_HEADER", (Object[])new String[]{resourceLabel != null ? resourceLabel : context.getEnv().getParameter("resourceID")}));
            }
            ProducerUtils.addStateParameter((IContext)producerContext, (String)"rootRelationshipType", (String[])new String[]{"rootRelationshipType", "selectedRelationshipType", "relationshipType"}, null);
        }
        catch (XMLStreamException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (LocalizableException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (J2HTMLException e) {
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static boolean isActiveView(StageContext context) {
        return !AbstractScorecardView.isMaximized(context) && AbstractScorecardView.isTemplate(context);
    }
}

